/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedThinRegionEntryHeap
extends VersionedThinRegionEntry {
    private static final VersionedThinRegionEntryHeapFactory factory = new VersionedThinRegionEntryHeapFactory();

    public VersionedThinRegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedThinRegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinRegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinRegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinRegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedThinRegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinRegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedThinRegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedThinRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

