/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryHeap;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryOffHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryOffHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryOffHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryOffHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryOffHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryOffHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedThinLRURegionEntryOffHeap
extends VersionedThinLRURegionEntry
implements OffHeapRegionEntry {
    private static final VersionedThinLRURegionEntryOffHeapFactory factory = new VersionedThinLRURegionEntryOffHeapFactory();

    public VersionedThinLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedThinLRURegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedThinLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedThinLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedThinLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedThinLRURegionEntryHeap.getEntryFactory();
        }
    }
}

