/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedThinLRURegionEntryHeap
extends VersionedThinLRURegionEntry {
    private static final VersionedThinLRURegionEntryHeapFactory factory = new VersionedThinLRURegionEntryHeapFactory();

    public VersionedThinLRURegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedThinLRURegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinLRURegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinLRURegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinLRURegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedThinLRURegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinLRURegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedThinLRURegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedThinLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

