/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryHeap;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryOffHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryOffHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryOffHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryOffHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryOffHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryOffHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedThinDiskRegionEntryOffHeap
extends VersionedThinDiskRegionEntry
implements OffHeapRegionEntry {
    private static final VersionedThinDiskRegionEntryOffHeapFactory factory = new VersionedThinDiskRegionEntryOffHeapFactory();

    public VersionedThinDiskRegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinDiskRegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedThinDiskRegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinDiskRegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinDiskRegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinDiskRegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedThinDiskRegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinDiskRegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedThinDiskRegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedThinDiskRegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedThinDiskRegionEntryHeap.getEntryFactory();
        }
    }
}

