/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedThinDiskRegionEntryHeap
extends VersionedThinDiskRegionEntry {
    private static final VersionedThinDiskRegionEntryHeapFactory factory = new VersionedThinDiskRegionEntryHeapFactory();

    public VersionedThinDiskRegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinDiskRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedThinDiskRegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinDiskRegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinDiskRegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinDiskRegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedThinDiskRegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinDiskRegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedThinDiskRegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedThinDiskRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

