/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntryHeap;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntryOffHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntryOffHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntryOffHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntryOffHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntryOffHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntryOffHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedStatsRegionEntryOffHeap
extends VersionedStatsRegionEntry
implements OffHeapRegionEntry {
    private static final VersionedStatsRegionEntryOffHeapFactory factory = new VersionedStatsRegionEntryOffHeapFactory();

    public VersionedStatsRegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsRegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsRegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsRegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsRegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsRegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedStatsRegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsRegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedStatsRegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedStatsRegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedStatsRegionEntryHeap.getEntryFactory();
        }
    }
}

