/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryHeap;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryOffHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryOffHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryOffHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryOffHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryOffHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryOffHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedStatsLRURegionEntryOffHeap
extends VersionedStatsLRURegionEntry
implements OffHeapRegionEntry {
    private static final VersionedStatsLRURegionEntryOffHeapFactory factory = new VersionedStatsLRURegionEntryOffHeapFactory();

    public VersionedStatsLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsLRURegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedStatsLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedStatsLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedStatsLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedStatsLRURegionEntryHeap.getEntryFactory();
        }
    }
}

