/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedStatsLRURegionEntryHeap
extends VersionedStatsLRURegionEntry {
    private static final VersionedStatsLRURegionEntryHeapFactory factory = new VersionedStatsLRURegionEntryHeapFactory();

    public VersionedStatsLRURegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsLRURegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsLRURegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsLRURegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsLRURegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedStatsLRURegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsLRURegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedStatsLRURegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedStatsLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

