/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntryHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedStatsDiskRegionEntryHeap
extends VersionedStatsDiskRegionEntry {
    private static final VersionedStatsDiskRegionEntryHeapFactory factory = new VersionedStatsDiskRegionEntryHeapFactory();

    public VersionedStatsDiskRegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsDiskRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsDiskRegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsDiskRegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsDiskRegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsDiskRegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedStatsDiskRegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsDiskRegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedStatsDiskRegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedStatsDiskRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

