/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntry;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntryHeap;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntryOffHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntryOffHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntryOffHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntryOffHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntryOffHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMThinRegionEntryOffHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryOffHeap;
import java.util.UUID;

public abstract class VMThinRegionEntryOffHeap
extends VMThinRegionEntry
implements OffHeapRegionEntry {
    private static final VMThinRegionEntryOffHeapFactory factory = new VMThinRegionEntryOffHeapFactory();

    public VMThinRegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinRegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VMThinRegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinRegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMThinRegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinRegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMThinRegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinRegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMThinRegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMThinRegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinRegionEntryOffHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VMThinRegionEntryHeap.getEntryFactory();
        }
    }
}

