/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryHeap;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.cache.lru.LRUClockNode;
import com.gemstone.gemfire.internal.util.concurrent.CustomEntryConcurrentHashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class VMThinLRURegionEntryHeapUUIDKey
extends VMThinLRURegionEntryHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VMThinLRURegionEntryHeapUUIDKey> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VMThinLRURegionEntryHeapUUIDKey.class, "lastModified");
    private volatile Object value;
    private LRUClockNode nextLRU;
    private LRUClockNode prevLRU;
    private int size;
    private final long keyMostSigBits;
    private final long keyLeastSigBits;

    public VMThinLRURegionEntryHeapUUIDKey(RegionEntryContext context, UUID key, Object value) {
        super(context, value);
        this.keyMostSigBits = key.getMostSignificantBits();
        this.keyLeastSigBits = key.getLeastSignificantBits();
    }

    @Override
    protected final Object getValueField() {
        return this.value;
    }

    @Override
    protected void setValueField(Object v) {
        this.value = v;
    }

    @Override
    protected long getlastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public final int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public final CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public final void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    @Override
    public void setDelayedDiskId(LocalRegion r) {
    }

    @Override
    public final synchronized int updateEntrySize(EnableLRU capacityController) {
        return this.updateEntrySize(capacityController, this._getValue());
    }

    @Override
    public final synchronized int updateEntrySize(EnableLRU capacityController, Object value) {
        int oldSize = this.getEntrySize();
        int newSize = capacityController.entrySize(this.getKeyForSizing(), value);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public final boolean testRecentlyUsed() {
        return this.areAnyBitsSet(0x1000000000000000L);
    }

    @Override
    public final void setRecentlyUsed() {
        this.setBits(0x1000000000000000L);
    }

    @Override
    public final void unsetRecentlyUsed() {
        this.clearBits(-1152921504606846977L);
    }

    @Override
    public final boolean testEvicted() {
        return this.areAnyBitsSet(0x2000000000000000L);
    }

    @Override
    public final void setEvicted() {
        this.setBits(0x2000000000000000L);
    }

    @Override
    public final void unsetEvicted() {
        this.clearBits(-2305843009213693953L);
    }

    @Override
    public final void setNextLRUNode(LRUClockNode next) {
        this.nextLRU = next;
    }

    @Override
    public final LRUClockNode nextLRUNode() {
        return this.nextLRU;
    }

    @Override
    public final void setPrevLRUNode(LRUClockNode prev) {
        this.prevLRU = prev;
    }

    @Override
    public final LRUClockNode prevLRUNode() {
        return this.prevLRU;
    }

    @Override
    public final int getEntrySize() {
        return this.size;
    }

    protected final void setEntrySize(int size) {
        this.size = size;
    }

    @Override
    public Object getKeyForSizing() {
        return null;
    }

    @Override
    public final Object getKey() {
        return new UUID(this.keyMostSigBits, this.keyLeastSigBits);
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof UUID) {
            UUID uuid = (UUID)k;
            return uuid.getLeastSignificantBits() == this.keyLeastSigBits && uuid.getMostSignificantBits() == this.keyMostSigBits;
        }
        return false;
    }
}

