/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryHeap;
import java.util.UUID;

public abstract class VMThinLRURegionEntryHeap
extends VMThinLRURegionEntry {
    private static final VMThinLRURegionEntryHeapFactory factory = new VMThinLRURegionEntryHeapFactory();

    public VMThinLRURegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMThinLRURegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinLRURegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMThinLRURegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinLRURegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMThinLRURegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinLRURegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMThinLRURegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMThinLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinLRURegionEntryHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

