/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryHeap;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryOffHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryOffHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryOffHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryOffHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryOffHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryOffHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryOffHeap;
import java.util.UUID;

public abstract class VMThinDiskRegionEntryOffHeap
extends VMThinDiskRegionEntry
implements OffHeapRegionEntry {
    private static final VMThinDiskRegionEntryOffHeapFactory factory = new VMThinDiskRegionEntryOffHeapFactory();

    public VMThinDiskRegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinDiskRegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VMThinDiskRegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinDiskRegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMThinDiskRegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinDiskRegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMThinDiskRegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinDiskRegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMThinDiskRegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMThinDiskRegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinDiskRegionEntryOffHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VMThinDiskRegionEntryHeap.getEntryFactory();
        }
    }
}

