/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMThinDiskRegionEntryHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskRegionEntryHeap;
import java.util.UUID;

public abstract class VMThinDiskRegionEntryHeap
extends VMThinDiskRegionEntry {
    private static final VMThinDiskRegionEntryHeapFactory factory = new VMThinDiskRegionEntryHeapFactory();

    public VMThinDiskRegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinDiskRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMThinDiskRegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinDiskRegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMThinDiskRegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinDiskRegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMThinDiskRegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinDiskRegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMThinDiskRegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMThinDiskRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinDiskRegionEntryHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

