/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryHeap;
import java.util.UUID;

public abstract class VMThinDiskLRURegionEntryHeap
extends VMThinDiskLRURegionEntry {
    private static final VMThinDiskLRURegionEntryHeapFactory factory = new VMThinDiskLRURegionEntryHeapFactory();

    public VMThinDiskLRURegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinDiskLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMThinDiskLRURegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinDiskLRURegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMThinDiskLRURegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinDiskLRURegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMThinDiskLRURegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinDiskLRURegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMThinDiskLRURegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMThinDiskLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinDiskLRURegionEntryHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

