/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntry;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntryHeap;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntryOffHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntryOffHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntryOffHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntryOffHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntryOffHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntryOffHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsRegionEntryOffHeap;
import java.util.UUID;

public abstract class VMStatsRegionEntryOffHeap
extends VMStatsRegionEntry
implements OffHeapRegionEntry {
    private static final VMStatsRegionEntryOffHeapFactory factory = new VMStatsRegionEntryOffHeapFactory();

    public VMStatsRegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsRegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VMStatsRegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsRegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMStatsRegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsRegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMStatsRegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsRegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMStatsRegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMStatsRegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsRegionEntryOffHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VMStatsRegionEntryHeap.getEntryFactory();
        }
    }
}

