/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.InternalStatisticsDisabledException;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryOffHeap;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.cache.lru.LRUClockNode;
import com.gemstone.gemfire.internal.offheap.OffHeapRegionEntryHelper;
import com.gemstone.gemfire.internal.util.concurrent.CustomEntryConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class VMStatsLRURegionEntryOffHeapObjectKey
extends VMStatsLRURegionEntryOffHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VMStatsLRURegionEntryOffHeapObjectKey> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VMStatsLRURegionEntryOffHeapObjectKey.class, "lastModified");
    private volatile long ohAddress;
    private static final AtomicLongFieldUpdater<VMStatsLRURegionEntryOffHeapObjectKey> ohAddrUpdater = AtomicLongFieldUpdater.newUpdater(VMStatsLRURegionEntryOffHeapObjectKey.class, "ohAddress");
    private LRUClockNode nextLRU;
    private LRUClockNode prevLRU;
    private int size;
    private volatile long lastAccessed;
    private volatile int hitCount;
    private volatile int missCount;
    private static final AtomicIntegerFieldUpdater<VMStatsLRURegionEntryOffHeapObjectKey> hitCountUpdater = AtomicIntegerFieldUpdater.newUpdater(VMStatsLRURegionEntryOffHeapObjectKey.class, "hitCount");
    private static final AtomicIntegerFieldUpdater<VMStatsLRURegionEntryOffHeapObjectKey> missCountUpdater = AtomicIntegerFieldUpdater.newUpdater(VMStatsLRURegionEntryOffHeapObjectKey.class, "missCount");
    private final Object key;

    public VMStatsLRURegionEntryOffHeapObjectKey(RegionEntryContext context, Object key, Object value) {
        super(context, value);
        this.key = key;
    }

    @Override
    public Token getValueAsToken() {
        return OffHeapRegionEntryHelper.getValueAsToken(this);
    }

    @Override
    protected Object getValueField() {
        return OffHeapRegionEntryHelper._getValue(this);
    }

    @Override
    protected void setValueField(Object v) {
        OffHeapRegionEntryHelper.setValue(this, v);
    }

    @Override
    public Object _getValueRetain(RegionEntryContext context, boolean decompress) {
        return OffHeapRegionEntryHelper._getValueRetain(this, decompress, context);
    }

    @Override
    public long getAddress() {
        return ohAddrUpdater.get(this);
    }

    @Override
    public boolean setAddress(long expectedAddr, long newAddr) {
        return ohAddrUpdater.compareAndSet(this, expectedAddr, newAddr);
    }

    @Override
    public void release() {
        OffHeapRegionEntryHelper.releaseEntry(this);
    }

    @Override
    public void returnToPool() {
    }

    @Override
    protected long getlastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public final int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public final CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public final void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    @Override
    public void setDelayedDiskId(LocalRegion r) {
    }

    @Override
    public final synchronized int updateEntrySize(EnableLRU capacityController) {
        return this.updateEntrySize(capacityController, this._getValue());
    }

    @Override
    public final synchronized int updateEntrySize(EnableLRU capacityController, Object value) {
        int oldSize = this.getEntrySize();
        int newSize = capacityController.entrySize(this.getKeyForSizing(), value);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public final boolean testRecentlyUsed() {
        return this.areAnyBitsSet(0x1000000000000000L);
    }

    @Override
    public final void setRecentlyUsed() {
        this.setBits(0x1000000000000000L);
    }

    @Override
    public final void unsetRecentlyUsed() {
        this.clearBits(-1152921504606846977L);
    }

    @Override
    public final boolean testEvicted() {
        return this.areAnyBitsSet(0x2000000000000000L);
    }

    @Override
    public final void setEvicted() {
        this.setBits(0x2000000000000000L);
    }

    @Override
    public final void unsetEvicted() {
        this.clearBits(-2305843009213693953L);
    }

    @Override
    public final void setNextLRUNode(LRUClockNode next) {
        this.nextLRU = next;
    }

    @Override
    public final LRUClockNode nextLRUNode() {
        return this.nextLRU;
    }

    @Override
    public final void setPrevLRUNode(LRUClockNode prev) {
        this.prevLRU = prev;
    }

    @Override
    public final LRUClockNode prevLRUNode() {
        return this.prevLRU;
    }

    @Override
    public final int getEntrySize() {
        return this.size;
    }

    protected final void setEntrySize(int size) {
        this.size = size;
    }

    @Override
    public Object getKeyForSizing() {
        return this.getKey();
    }

    @Override
    public final void updateStatsForGet(boolean hit, long time) {
        this.setLastAccessed(time);
        if (hit) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
    }

    @Override
    protected final void setLastModified(long lastModified) {
        this._setLastModified(lastModified);
        if (!DISABLE_ACCESS_TIME_UPDATE_ON_PUT) {
            this.setLastAccessed(lastModified);
        }
    }

    @Override
    public final long getLastAccessed() throws InternalStatisticsDisabledException {
        return this.lastAccessed;
    }

    private void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    @Override
    public final long getHitCount() throws InternalStatisticsDisabledException {
        return (long)this.hitCount & 0xFFFFFFFFL;
    }

    @Override
    public final long getMissCount() throws InternalStatisticsDisabledException {
        return (long)this.missCount & 0xFFFFFFFFL;
    }

    private void incrementHitCount() {
        hitCountUpdater.incrementAndGet(this);
    }

    private void incrementMissCount() {
        missCountUpdater.incrementAndGet(this);
    }

    @Override
    public final void resetCounts() throws InternalStatisticsDisabledException {
        hitCountUpdater.set(this, 0);
        missCountUpdater.set(this, 0);
    }

    @Override
    public final void txDidDestroy(long currTime) {
        this.setLastModified(currTime);
        this.setLastAccessed(currTime);
        this.hitCount = 0;
        this.missCount = 0;
    }

    @Override
    public boolean hasStats() {
        return true;
    }

    @Override
    public final Object getKey() {
        return this.key;
    }
}

