/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryHeap;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryOffHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryOffHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryOffHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryOffHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryOffHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryOffHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryOffHeap;
import java.util.UUID;

public abstract class VMStatsLRURegionEntryOffHeap
extends VMStatsLRURegionEntry
implements OffHeapRegionEntry {
    private static final VMStatsLRURegionEntryOffHeapFactory factory = new VMStatsLRURegionEntryOffHeapFactory();

    public VMStatsLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VMStatsLRURegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMStatsLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMStatsLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMStatsLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMStatsLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsLRURegionEntryOffHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VMStatsLRURegionEntryHeap.getEntryFactory();
        }
    }
}

