/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMStatsLRURegionEntryHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsLRURegionEntryHeap;
import java.util.UUID;

public abstract class VMStatsLRURegionEntryHeap
extends VMStatsLRURegionEntry {
    private static final VMStatsLRURegionEntryHeapFactory factory = new VMStatsLRURegionEntryHeapFactory();

    public VMStatsLRURegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMStatsLRURegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsLRURegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMStatsLRURegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsLRURegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMStatsLRURegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsLRURegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMStatsLRURegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMStatsLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsLRURegionEntryHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

