/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMStatsDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.VMStatsDiskRegionEntryHeap;
import com.gemstone.gemfire.internal.cache.VMStatsDiskRegionEntryOffHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMStatsDiskRegionEntryOffHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMStatsDiskRegionEntryOffHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMStatsDiskRegionEntryOffHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMStatsDiskRegionEntryOffHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMStatsDiskRegionEntryOffHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntryOffHeap;
import java.util.UUID;

public abstract class VMStatsDiskRegionEntryOffHeap
extends VMStatsDiskRegionEntry
implements OffHeapRegionEntry {
    private static final VMStatsDiskRegionEntryOffHeapFactory factory = new VMStatsDiskRegionEntryOffHeapFactory();

    public VMStatsDiskRegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsDiskRegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VMStatsDiskRegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsDiskRegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMStatsDiskRegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsDiskRegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMStatsDiskRegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsDiskRegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMStatsDiskRegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMStatsDiskRegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsDiskRegionEntryOffHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VMStatsDiskRegionEntryHeap.getEntryFactory();
        }
    }
}

