/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMStatsDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.VMStatsDiskRegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMStatsDiskRegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMStatsDiskRegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMStatsDiskRegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMStatsDiskRegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMStatsDiskRegionEntryHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntryHeap;
import java.util.UUID;

public abstract class VMStatsDiskRegionEntryHeap
extends VMStatsDiskRegionEntry {
    private static final VMStatsDiskRegionEntryHeapFactory factory = new VMStatsDiskRegionEntryHeapFactory();

    public VMStatsDiskRegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsDiskRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMStatsDiskRegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsDiskRegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMStatsDiskRegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsDiskRegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMStatsDiskRegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsDiskRegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMStatsDiskRegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMStatsDiskRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsDiskRegionEntryHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

