/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryHeap;
import java.util.UUID;

public abstract class VMStatsDiskLRURegionEntryHeap
extends VMStatsDiskLRURegionEntry {
    private static final VMStatsDiskLRURegionEntryHeapFactory factory = new VMStatsDiskLRURegionEntryHeapFactory();

    public VMStatsDiskLRURegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsDiskLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMStatsDiskLRURegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsDiskLRURegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMStatsDiskLRURegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsDiskLRURegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMStatsDiskLRURegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsDiskLRURegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMStatsDiskLRURegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMStatsDiskLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsDiskLRURegionEntryHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

