/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.ByteBuffer;

public abstract class Token {
    public static final Invalid INVALID = new Invalid();
    public static final LocalInvalid LOCAL_INVALID = new LocalInvalid();
    public static final Destroyed DESTROYED = new Destroyed();
    public static final Tombstone TOMBSTONE = new Tombstone();
    public static final Removed REMOVED_PHASE1 = new Removed();
    public static final Removed2 REMOVED_PHASE2 = new Removed2();
    public static final EndOfStream END_OF_STREAM = new EndOfStream();
    public static final NotAvailable NOT_AVAILABLE = new NotAvailable();
    public static final NotAToken NOT_A_TOKEN = new NotAToken();

    public static final boolean isInvalidOrRemoved(Object o) {
        return Token.isInvalid(o) || Token.isRemoved(o);
    }

    public static final boolean isInvalid(Object o) {
        return o == INVALID || o == LOCAL_INVALID;
    }

    public static final boolean isRemoved(Object o) {
        return o == DESTROYED || o == REMOVED_PHASE1 || o == REMOVED_PHASE2 || o == TOMBSTONE;
    }

    public static final boolean isRemovedFromDisk(Object o) {
        return o == DESTROYED || o == REMOVED_PHASE1 || o == REMOVED_PHASE2;
    }

    public static final boolean isDestroyed(Object o) {
        return o == DESTROYED;
    }

    public static final class EndOfStream
    extends Token
    implements DataSerializableFixedID {
        public String toString() {
            return "EndOfStream";
        }

        private Object readResolve() throws ObjectStreamException {
            return END_OF_STREAM;
        }

        @Override
        public int getDSFID() {
            return 124;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void toData(DataOutput out) throws IOException {
        }

        @Override
        public Version[] getSerializationVersions() {
            return null;
        }
    }

    public static class NotAToken
    extends Token {
        protected NotAToken() {
        }

        public String toString() {
            return "NOT_A_TOKEN";
        }
    }

    public static class NotAvailable
    extends Token {
        protected NotAvailable() {
        }

        public String toString() {
            return "NOT_AVAILABLE";
        }
    }

    public static class Removed2
    extends Token
    implements DataSerializableFixedID,
    Serializable {
        private static final long serialVersionUID = 5122235867167804597L;

        protected Removed2() {
        }

        public String toString() {
            return "REMOVED_PHASE2";
        }

        private Object readResolve() throws ObjectStreamException {
            return REMOVED_PHASE2;
        }

        @Override
        public int getDSFID() {
            return 145;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public Version[] getSerializationVersions() {
            return null;
        }
    }

    public static class Removed
    extends Token
    implements DataSerializableFixedID,
    Serializable {
        private static final long serialVersionUID = -1999836887955504653L;

        protected Removed() {
        }

        public String toString() {
            return "REMOVED_PHASE1";
        }

        private Object readResolve() throws ObjectStreamException {
            return REMOVED_PHASE1;
        }

        @Override
        public int getDSFID() {
            return 144;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public Version[] getSerializationVersions() {
            return null;
        }
    }

    public static class Tombstone
    extends Token
    implements DataSerializableFixedID,
    Serializable {
        static final long serialVersionUID = -6388232623019450170L;

        protected Tombstone() {
        }

        public String toString() {
            return "TOMBSTONE";
        }

        private Object readResolve() throws ObjectStreamException {
            return TOMBSTONE;
        }

        @Override
        public int getDSFID() {
            return 149;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public Version[] getSerializationVersions() {
            return null;
        }
    }

    public static class Destroyed
    extends Token
    implements DataSerializableFixedID,
    Serializable {
        private static final long serialVersionUID = -1922513819482668368L;

        protected Destroyed() {
        }

        public String toString() {
            return "DESTROYED";
        }

        private Object readResolve() throws ObjectStreamException {
            return DESTROYED;
        }

        @Override
        public int getDSFID() {
            return 143;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public Version[] getSerializationVersions() {
            return null;
        }
    }

    public static class LocalInvalid
    extends Invalid {
        private static final long serialVersionUID = 4110159168041217249L;

        protected LocalInvalid() {
        }

        @Override
        public String toString() {
            return "LOCAL_INVALID";
        }

        private Object readResolve() throws ObjectStreamException {
            return LOCAL_INVALID;
        }

        @Override
        public int getDSFID() {
            return 142;
        }
    }

    public static class Invalid
    extends Token
    implements DataSerializableFixedID,
    Serializable {
        private static final long serialVersionUID = -4133205114649525169L;

        protected Invalid() {
        }

        public String toString() {
            return "INVALID";
        }

        private Object readResolve() throws ObjectStreamException {
            return INVALID;
        }

        @Override
        public int getDSFID() {
            return 141;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        }

        public boolean isSerializedValue(byte[] value) {
            ByteBuffer buf = ByteBuffer.wrap(value);
            return buf.capacity() == 3 && buf.get() == 2 && buf.getShort() == this.getDSFID();
        }

        @Override
        public Version[] getSerializationVersions() {
            return null;
        }
    }
}

