/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.LowMemoryException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.RemotePutMessage;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.TransactionMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class RemoteOperationMessage
extends DistributionMessage
implements MessageWithReply,
TransactionMessage {
    private static final Logger logger = LogService.getLogger();
    static final ForceReattemptException UNHANDLED_EXCEPTION = (ForceReattemptException)new ForceReattemptException(LocalizedStrings.PartitionMessage_UNKNOWN_EXCEPTION.toLocalizedString()).fillInStackTrace();
    protected int processorId;
    protected int processorType;
    protected String regionPath;
    private int txUniqId = -1;
    private InternalDistributedMember txMemberId = null;
    protected transient short flags;
    protected boolean isTransactionDistributed = false;
    private static final String PN_TOKEN = ".cache.";

    public RemoteOperationMessage() {
    }

    public RemoteOperationMessage(InternalDistributedMember recipient, String regionPath, ReplyProcessor21 processor) {
        Assert.assertTrue(recipient != null, "RemoteMesssage recipient can not be null");
        this.setRecipient(recipient);
        this.regionPath = regionPath;
        int n = this.processorId = processor == null ? 0 : processor.getProcessorId();
        if (processor != null && this.isSevereAlertCompatible()) {
            processor.enableSevereAlertProcessing();
        }
        this.txUniqId = TXManagerImpl.getCurrentTXUniqueId();
        TXStateProxy txState = TXManagerImpl.getCurrentTXState();
        if (txState != null && txState.isMemberIdForwardingRequired()) {
            this.txMemberId = txState.getOriginatingMember();
        }
        this.setIfTransactionDistributed();
    }

    public RemoteOperationMessage(Set recipients, String regionPath, ReplyProcessor21 processor) {
        this.setRecipients(recipients);
        this.regionPath = regionPath;
        int n = this.processorId = processor == null ? 0 : processor.getProcessorId();
        if (processor != null && this.isSevereAlertCompatible()) {
            processor.enableSevereAlertProcessing();
        }
        this.txUniqId = TXManagerImpl.getCurrentTXUniqueId();
        TXStateProxy txState = TXManagerImpl.getCurrentTXState();
        if (txState != null && txState.isMemberIdForwardingRequired()) {
            this.txMemberId = txState.getOriginatingMember();
        }
        this.setIfTransactionDistributed();
    }

    public RemoteOperationMessage(RemoteOperationMessage other) {
        this.regionPath = other.regionPath;
        this.processorId = other.processorId;
        this.txUniqId = other.getTXUniqId();
        this.txMemberId = other.getTXMemberId();
        this.isTransactionDistributed = other.isTransactionDistributed;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    public int getProcessorType() {
        return 78;
    }

    public final String getRegionPath() {
        return this.regionPath;
    }

    @Override
    public final int getProcessorId() {
        return this.processorId;
    }

    public final void registerProcessor(int processorId1) {
        this.processorId = processorId1;
    }

    public void setCacheOpRecipients(Collection cacheOpRecipients) {
        assert (this instanceof RemotePutMessage);
    }

    public final boolean checkCacheClosing(DistributionManager dm) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        return cache == null || cache.isClosed();
    }

    public final boolean checkDSClosing(DistributionManager dm) {
        InternalDistributedSystem ds = dm.getSystem();
        return ds == null || ds.isDisconnecting();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void process(DistributionManager dm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, LocalRegion pr, long startTime) {
        ReplyMessage.send(member, procId, ex, this.getReplySender(dm), pr != null && pr.isInternalRegion());
    }

    protected boolean failIfRegionMissing() {
        return true;
    }

    RemoteOperationResponse createReplyProcessor(PartitionedRegion r, Set recipients) {
        return new RemoteOperationResponse(r.getSystem(), (Collection)recipients);
    }

    protected abstract boolean operateOnRegion(DistributionManager var1, LocalRegion var2, long var3) throws RemoteOperationException;

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.flags = in.readShort();
        this.setFlags(this.flags, in);
        this.regionPath = DataSerializer.readString(in);
        this.isTransactionDistributed = in.readBoolean();
    }

    @Override
    public InternalDistributedMember getTXOriginatorClient() {
        return this.txMemberId;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        short flags = this.computeCompressedShort();
        out.writeShort(flags);
        if (this.processorId != 0) {
            out.writeInt(this.processorId);
        }
        if (this.processorType != 0) {
            out.writeByte(this.processorType);
        }
        if (this.getTXUniqId() != -1) {
            out.writeInt(this.getTXUniqId());
        }
        if (this.getTXMemberId() != null) {
            DataSerializer.writeObject(this.getTXMemberId(), out);
        }
        DataSerializer.writeString(this.regionPath, out);
        out.writeBoolean(this.isTransactionDistributed);
    }

    protected short computeCompressedShort() {
        short flags = 0;
        if (this.processorId != 0) {
            flags = (short)(flags | 1);
        }
        if (this.processorType != 0) {
            flags = (short)(flags | 0x20);
        }
        if (this.getTXUniqId() != -1) {
            flags = (short)(flags | 4);
        }
        if (this.getTXMemberId() != null) {
            flags = (short)(flags | 2);
        }
        return flags;
    }

    protected void setFlags(short flags, DataInput in) throws IOException, ClassNotFoundException {
        if ((flags & 1) != 0) {
            this.processorId = in.readInt();
            ReplyProcessor21.setMessageRPId(this.processorId);
        }
        if ((flags & 0x20) != 0) {
            this.processorType = in.readByte();
        }
        if ((flags & 4) != 0) {
            this.txUniqId = in.readInt();
        }
        if ((flags & 2) != 0) {
            this.txMemberId = (InternalDistributedMember)DataSerializer.readObject(in);
        }
    }

    protected final InternalDistributedMember getTXMemberId() {
        return this.txMemberId;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        String className = this.getClass().getName();
        buff.append(className.substring(className.indexOf(PN_TOKEN) + PN_TOKEN.length()));
        buff.append("(regionPath=");
        buff.append(this.regionPath);
        this.appendFields(buff);
        buff.append(" ,distTx=");
        buff.append(this.isTransactionDistributed);
        buff.append(")");
        return buff.toString();
    }

    protected void appendFields(StringBuffer buff) {
        buff.append("; sender=").append(this.getSender()).append("; recipients=[");
        InternalDistributedMember[] recips = this.getRecipients();
        for (int i = 0; i < recips.length - 1; ++i) {
            buff.append(recips[i]).append(',');
        }
        if (recips.length > 0) {
            buff.append(recips[recips.length - 1]);
        }
        buff.append("]; processorId=").append(this.processorId);
    }

    public InternalDistributedMember getRecipient() {
        return this.getRecipients()[0];
    }

    public void setOperation(Operation op) {
    }

    public void setHasOldValue(boolean value) {
    }

    @Override
    public final int getTXUniqId() {
        return this.txUniqId;
    }

    @Override
    public final InternalDistributedMember getMemberToMasqueradeAs() {
        if (this.txMemberId == null) {
            return this.getSender();
        }
        return this.txMemberId;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    @Override
    public boolean canParticipateInTransaction() {
        return true;
    }

    @Override
    public boolean isTransactionDistributed() {
        return this.isTransactionDistributed;
    }

    public void setTransactionDistributed(boolean isDistTx) {
        this.isTransactionDistributed = isDistTx;
    }

    private void setIfTransactionDistributed() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && cache.getTxManager() != null) {
            this.isTransactionDistributed = cache.getTxManager().isDistributed();
        }
    }

    public static class RemoteOperationResponse
    extends DirectReplyProcessor {
        volatile ForceReattemptException prce;
        volatile boolean responseReceived;
        boolean responseRequired;

        public RemoteOperationResponse(InternalDistributedSystem dm, Collection initMembers) {
            this(dm, initMembers, true);
        }

        public RemoteOperationResponse(InternalDistributedSystem dm, Collection initMembers, boolean register) {
            super(dm, initMembers);
            if (register) {
                this.register();
            }
        }

        public RemoteOperationResponse(InternalDistributedSystem dm, InternalDistributedMember member) {
            this(dm, member, true);
        }

        public RemoteOperationResponse(InternalDistributedSystem dm, InternalDistributedMember member, boolean register) {
            super(dm, member);
            if (register) {
                this.register();
            }
        }

        public void requireResponse() {
            this.responseRequired = true;
        }

        @Override
        public void memberDeparted(InternalDistributedMember id, boolean crashed) {
            if (id != null) {
                if (this.removeMember(id, true)) {
                    this.prce = new ForceReattemptException(LocalizedStrings.PartitionMessage_PARTITIONRESPONSE_GOT_MEMBERDEPARTED_EVENT_FOR_0_CRASHED_1.toLocalizedString(id, crashed));
                }
                this.checkIfDone();
            } else {
                Exception e = new Exception(LocalizedStrings.PartitionMessage_MEMBERDEPARTED_GOT_NULL_MEMBERID.toLocalizedString());
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionMessage_MEMBERDEPARTED_GOT_NULL_MEMBERID_CRASHED_0, crashed), (Throwable)e);
            }
        }

        public final void waitForCacheException() throws CacheException, RemoteOperationException, PrimaryBucketException {
            try {
                this.waitForRepliesUninterruptibly();
                if (this.prce != null || this.responseRequired && !this.responseReceived) {
                    throw new RemoteOperationException(LocalizedStrings.PartitionMessage_ATTEMPT_FAILED.toLocalizedString(), this.prce);
                }
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CacheException) {
                    throw (CacheException)t;
                }
                if (t instanceof RemoteOperationException) {
                    RemoteOperationException ft = (RemoteOperationException)t;
                    RemoteOperationException fre = new RemoteOperationException(LocalizedStrings.PartitionMessage_PEER_REQUESTS_REATTEMPT.toLocalizedString(), t);
                    if (ft.hasHash()) {
                        fre.setHash(ft.getHash());
                    }
                    throw fre;
                }
                if (t instanceof PrimaryBucketException) {
                    throw new PrimaryBucketException(LocalizedStrings.PartitionMessage_PEER_FAILED_PRIMARY_TEST.toLocalizedString(), t);
                }
                if (t instanceof RegionDestroyedException) {
                    RegionDestroyedException rde = (RegionDestroyedException)t;
                    throw rde;
                }
                if (t instanceof CancelException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("RemoteOperationResponse got CacheClosedException from {}, throwing ForceReattemptException", new Object[]{e.getSender(), t});
                    }
                    throw new RemoteOperationException(LocalizedStrings.PartitionMessage_PARTITIONRESPONSE_GOT_REMOTE_CACHECLOSEDEXCEPTION.toLocalizedString(), t);
                }
                if (t instanceof LowMemoryException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("RemoteOperationResponse re-throwing remote LowMemoryException from {}", new Object[]{e.getSender(), t});
                    }
                    throw (LowMemoryException)t;
                }
                e.handleAsUnexpected();
            }
        }

        @Override
        public void process(DistributionMessage msg) {
            this.responseReceived = true;
            super.process(msg);
        }
    }
}

