/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessage;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessageWithDirectReply;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class RemoteContainsKeyValueMessage
extends RemoteOperationMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private boolean valueCheck;
    private Object key;
    protected static final short VALUE_CHECK = 64;

    public RemoteContainsKeyValueMessage() {
    }

    public RemoteContainsKeyValueMessage(InternalDistributedMember recipient, String regionPath, DirectReplyProcessor processor, Object key, boolean valueCheck) {
        super(recipient, regionPath, processor);
        this.valueCheck = valueCheck;
        this.key = key;
    }

    public static RemoteContainsKeyValueResponse send(InternalDistributedMember recipient, LocalRegion r, Object key, boolean valueCheck) throws RemoteOperationException {
        Assert.assertTrue(recipient != null, "PRDistribuedRemoteContainsKeyValueMessage NULL reply message");
        RemoteContainsKeyValueResponse p = new RemoteContainsKeyValueResponse(r.getSystem(), Collections.singleton(recipient), key);
        RemoteContainsKeyValueMessage m = new RemoteContainsKeyValueMessage(recipient, r.getFullPath(), p, key, valueCheck);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws CacheException, RemoteOperationException {
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "DistributedRemoteContainsKeyValueMessage operateOnRegion: {}", new Object[]{r.getFullPath()});
        }
        if (!(r instanceof PartitionedRegion)) {
            r.waitOnInitialization();
        }
        if (r.keyRequiresRegionContext()) {
            ((KeyWithRegionContext)this.key).setRegionContext(r);
        }
        boolean replyVal = this.valueCheck ? r.containsValueForKey(this.key) : r.containsKey(this.key);
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.debug("DistributedRemoteContainsKeyValueMessage sending reply back using processorId: {}", new Object[]{this.getProcessorId()});
        }
        RemoteContainsKeyValueReplyMessage.send(this.getSender(), this.getProcessorId(), this.getReplySender(dm), replyVal);
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; valueCheck=").append(this.valueCheck).append("; key=").append(this.key);
    }

    @Override
    public int getDSFID() {
        return -27;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.key = DataSerializer.readObject(in);
        this.valueCheck = (this.flags & 0x40) != 0;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.key, out);
    }

    @Override
    protected short computeCompressedShort() {
        short flags = super.computeCompressedShort();
        if (this.valueCheck) {
            flags = (short)(flags | 0x40);
        }
        return flags;
    }

    public static class RemoteContainsKeyValueResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private volatile boolean returnValue;
        private volatile boolean returnValueReceived;
        final Object key;

        public RemoteContainsKeyValueResponse(InternalDistributedSystem ds, Set recipients, Object key) {
            super(ds, (Collection)recipients, false);
            this.key = key;
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof RemoteContainsKeyValueReplyMessage) {
                    RemoteContainsKeyValueReplyMessage reply = (RemoteContainsKeyValueReplyMessage)msg;
                    this.returnValue = reply.doesItContainKeyValue();
                    this.returnValueReceived = true;
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "ContainsKeyValueResponse return value is {}", new Object[]{this.returnValue});
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        public boolean waitForContainsResult() throws PrimaryBucketException, RemoteOperationException {
            try {
                this.waitForCacheException();
            }
            catch (RemoteOperationException rce) {
                rce.checkKey(this.key);
                throw rce;
            }
            catch (PrimaryBucketException pbe) {
                throw pbe;
            }
            catch (RegionDestroyedException e) {
                throw e;
            }
            catch (CacheException ce) {
                logger.debug("ContainsKeyValueResponse got remote CacheException; forcing reattempt.", (Throwable)ce);
                throw new RemoteOperationException(LocalizedStrings.RemoteContainsKeyValueMessage_CONTAINSKEYVALUERESPONSE_GOT_REMOTE_CACHEEXCEPTION.toLocalizedString(), ce);
            }
            if (!this.returnValueReceived) {
                throw new RemoteOperationException(LocalizedStrings.RemoteContainsKeyValueMessage_NO_RETURN_VALUE_RECEIVED.toLocalizedString());
            }
            return this.returnValue;
        }
    }

    public static final class RemoteContainsKeyValueReplyMessage
    extends ReplyMessage {
        private boolean containsKeyValue;

        public RemoteContainsKeyValueReplyMessage() {
        }

        private RemoteContainsKeyValueReplyMessage(int processorId, boolean containsKeyValue) {
            this.processorId = processorId;
            this.containsKeyValue = containsKeyValue;
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender replySender, boolean containsKeyValue) {
            Assert.assertTrue(recipient != null, "ContainsKeyValueReplyMessage NULL reply message");
            RemoteContainsKeyValueReplyMessage m = new RemoteContainsKeyValueReplyMessage(processorId, containsKeyValue);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "ContainsKeyValueReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -26;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.containsKeyValue = in.readBoolean();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.containsKeyValue);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ContainsKeyValueReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender()).append(" returning containsKeyValue=").append(this.doesItContainKeyValue());
            return sb.toString();
        }

        public boolean doesItContainKeyValue() {
            return this.containsKeyValue;
        }
    }
}

