/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.distributed.Role;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.ReliableDistributionData;
import com.gemstone.gemfire.internal.cache.ReliableMessageQueue;
import com.gemstone.gemfire.internal.cache.ReliableMessageQueueFactory;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReliableMessageQueueFactoryImpl
implements ReliableMessageQueueFactory {
    private boolean closed = false;
    private final ArrayList queues = new ArrayList();
    private final IdentityHashMap regionMap = new IdentityHashMap(128);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReliableMessageQueue create(DistributedRegion region) {
        if (this.closed) {
            throw new IllegalStateException(LocalizedStrings.ReliableMessageQueueFactoryImpl_RELIABLE_MESSAGE_QUEUE_IS_CLOSED.toLocalizedString());
        }
        ArrayList arrayList = this.queues;
        synchronized (arrayList) {
            Queue q = new Queue(region);
            this.queues.add(q);
            return q;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean force) {
        if (!force) {
            ArrayList arrayList = this.queues;
            synchronized (arrayList) {
                if (!this.queues.isEmpty()) {
                    throw new IllegalStateException(LocalizedStrings.ReliableMessageQueueFactoryImpl_REGIONS_WITH_MESSAGE_QUEUING_ALREADY_EXIST.toLocalizedString());
                }
            }
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(DistributedRegion r, ReliableDistributionData data, Set roles) {
        QueuedRegionData qrd = null;
        IdentityHashMap identityHashMap = this.regionMap;
        synchronized (identityHashMap) {
            qrd = (QueuedRegionData)this.regionMap.get(r);
        }
        qrd.add(r, data, roles);
        r.getCachePerfStats().incReliableQueuedOps(data.getOperationCount() * roles.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getQueuingRoles(DistributedRegion r) {
        QueuedRegionData qrd = null;
        IdentityHashMap identityHashMap = this.regionMap;
        synchronized (identityHashMap) {
            qrd = (QueuedRegionData)this.regionMap.get(r);
        }
        return qrd.getQueuingRoles(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean roleReady(DistributedRegion r, Role role) {
        QueuedRegionData qrd = null;
        IdentityHashMap identityHashMap = this.regionMap;
        synchronized (identityHashMap) {
            qrd = (QueuedRegionData)this.regionMap.get(r);
        }
        return qrd.roleReady(r, role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(DistributedRegion r) {
        QueuedRegionData qrd = new QueuedRegionData();
        IdentityHashMap identityHashMap = this.regionMap;
        synchronized (identityHashMap) {
            QueuedRegionData old = this.regionMap.put(r, qrd);
            if (old != null) {
                throw new IllegalStateException(LocalizedStrings.ReliableMessageQueueFactoryImpl_UNEXPECTED_QUEUEDREGIONDATA_0_FOR_REGION_1.toLocalizedString(old, r));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy(DistributedRegion r) {
        QueuedRegionData qrd = null;
        IdentityHashMap identityHashMap = this.regionMap;
        synchronized (identityHashMap) {
            qrd = (QueuedRegionData)this.regionMap.remove(r);
        }
        if (qrd != null) {
            qrd.destroy(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeQueue(Queue q) {
        ArrayList arrayList = this.queues;
        synchronized (arrayList) {
            this.queues.remove(q);
        }
    }

    protected static class QueuedRegionData {
        private final HashMap roleMap = new HashMap();

        protected QueuedRegionData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void add(DistributedRegion r, ReliableDistributionData data, Set roles) {
            QueuedRegionData queuedRegionData = this;
            synchronized (queuedRegionData) {
                for (Role role : roles) {
                    ArrayList l = (ArrayList)this.roleMap.get(role);
                    if (l == null) {
                        l = new ArrayList();
                        this.roleMap.put(role, l);
                    }
                    l.addAll(data.getOperations());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Set getQueuingRoles(DistributedRegion r) {
            HashSet result = null;
            QueuedRegionData queuedRegionData = this;
            synchronized (queuedRegionData) {
                for (Map.Entry me : this.roleMap.entrySet()) {
                    List l = (List)me.getValue();
                    if (l == null || l.isEmpty()) continue;
                    if (result == null) {
                        result = new HashSet();
                    }
                    result.add(me.getKey());
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean roleReady(DistributedRegion r, Role role) {
            List l = null;
            QueuedRegionData queuedRegionData = this;
            synchronized (queuedRegionData) {
                l = (List)this.roleMap.get(role);
            }
            if (l != null) {
                while (!l.isEmpty()) {
                    if (r.sendQueue(l, role)) continue;
                    return false;
                }
            }
            return true;
        }

        public void destroy(DistributedRegion r) {
        }
    }

    public class Queue
    implements ReliableMessageQueue {
        private final DistributedRegion r;

        Queue(DistributedRegion r) {
            this.r = r;
            ReliableMessageQueueFactoryImpl.this.init(this.r);
        }

        @Override
        public DistributedRegion getRegion() {
            return this.r;
        }

        @Override
        public void add(ReliableDistributionData data, Set roles) {
            ReliableMessageQueueFactoryImpl.this.add(this.r, data, roles);
        }

        @Override
        public Set getQueuingRoles() {
            return ReliableMessageQueueFactoryImpl.this.getQueuingRoles(this.r);
        }

        @Override
        public boolean roleReady(Role role) {
            return ReliableMessageQueueFactoryImpl.this.roleReady(this.r, role);
        }

        @Override
        public void destroy() {
            ReliableMessageQueueFactoryImpl.this.destroy(this.r);
        }

        @Override
        public void close() {
            ReliableMessageQueueFactoryImpl.this.removeQueue(this);
        }
    }
}

