/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionExpiryTask;

class RegionTTLExpiryTask
extends RegionExpiryTask {
    RegionTTLExpiryTask(LocalRegion reg) {
        super(reg);
    }

    @Override
    public long getExpirationTime() throws EntryNotFoundException {
        ExpirationAction action = this.getAction();
        if ((action == ExpirationAction.INVALIDATE || action == ExpirationAction.LOCAL_INVALIDATE) && this.getLocalRegion().regionInvalid) {
            int timeout = this.getTTLAttributes().getTimeout();
            if (timeout == 0) {
                return 0L;
            }
            if (!this.getLocalRegion().EXPIRY_UNITS_MS) {
                timeout *= 1000;
            }
            return (long)timeout + this.getLocalRegion().cacheTimeMillis();
        }
        return this.getTTLExpirationTime();
    }

    @Override
    protected ExpirationAction getAction() {
        return this.getTTLAttributes().getAction();
    }

    @Override
    protected final void addExpiryTask() {
        this.getLocalRegion().addTTLExpiryTask(this);
    }

    @Override
    public boolean isPending() {
        return false;
    }
}

