/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.DataLocationException;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.LocalRegionDataView;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import java.util.Set;

public class PartitionedRegionDataView
extends LocalRegionDataView {
    @Override
    public void updateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
        PartitionedRegion pr = (PartitionedRegion)event.getLocalRegion();
        pr.updateEntryVersionInBucket(event);
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        PartitionedRegion pr = (PartitionedRegion)event.getLocalRegion();
        pr.invalidateInBucket(event);
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) {
        PartitionedRegion pr = (PartitionedRegion)event.getLocalRegion();
        pr.destroyInBucket(event, expectedOldValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region.Entry getEntry(KeyInfo keyInfo, LocalRegion localRegion, boolean allowTombstones) {
        TXStateProxy tx = localRegion.cache.getTXMgr().internalSuspend();
        try {
            PartitionedRegion pr = (PartitionedRegion)localRegion;
            Region.Entry<?, ?> entry = pr.nonTXGetEntry(keyInfo, false, allowTombstones);
            return entry;
        }
        finally {
            localRegion.cache.getTXMgr().resume(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object findObject(KeyInfo key, LocalRegion r, boolean isCreate, boolean generateCallbacks, Object value, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones, boolean allowReadFromHDFS) {
        TXStateProxy tx = r.cache.getTXMgr().internalSuspend();
        try {
            Object object = r.findObjectInSystem(key, isCreate, tx, generateCallbacks, value, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones, allowReadFromHDFS);
            return object;
        }
        finally {
            r.cache.getTXMgr().resume(tx);
        }
    }

    @Override
    public boolean containsKey(KeyInfo keyInfo, LocalRegion localRegion) {
        PartitionedRegion pr = (PartitionedRegion)localRegion;
        return pr.nonTXContainsKey(keyInfo);
    }

    @Override
    public Object getSerializedValue(LocalRegion localRegion, KeyInfo keyInfo, boolean doNotLockEntry, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones, boolean allowReadFromHDFS) throws DataLocationException {
        PartitionedRegion pr = (PartitionedRegion)localRegion;
        return pr.getDataStore().getSerializedLocally(keyInfo, doNotLockEntry, requestingClient, clientEvent, returnTombstones, allowReadFromHDFS);
    }

    @Override
    public boolean putEntryOnRemote(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws DataLocationException {
        PartitionedRegion pr = (PartitionedRegion)event.getLocalRegion();
        return pr.getDataStore().putLocally(event.getKeyInfo().getBucketId(), event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified);
    }

    @Override
    public void destroyOnRemote(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws DataLocationException {
        PartitionedRegion pr = (PartitionedRegion)event.getLocalRegion();
        pr.getDataStore().destroyLocally(event.getKeyInfo().getBucketId(), event, expectedOldValue);
    }

    @Override
    public void invalidateOnRemote(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws DataLocationException {
        PartitionedRegion pr = (PartitionedRegion)event.getLocalRegion();
        pr.getDataStore().invalidateLocally(event.getKeyInfo().getBucketId(), event);
    }

    @Override
    public Set getBucketKeys(LocalRegion localRegion, int bucketId, boolean allowTombstones) {
        PartitionedRegion pr = (PartitionedRegion)localRegion;
        return pr.getBucketKeys(bucketId, allowTombstones);
    }

    @Override
    public Region.Entry getEntryOnRemote(KeyInfo keyInfo, LocalRegion localRegion, boolean allowTombstones) throws DataLocationException {
        PartitionedRegion pr = (PartitionedRegion)localRegion;
        return pr.getDataStore().getEntryLocally(keyInfo.getBucketId(), keyInfo.getKey(), false, allowTombstones, true);
    }

    @Override
    public Object getKeyForIterator(KeyInfo curr, LocalRegion currRgn, boolean rememberReads, boolean allowTombstones) {
        return curr.getKey();
    }

    @Override
    public Region.Entry<?, ?> getEntryForIterator(KeyInfo keyInfo, LocalRegion currRgn, boolean rememberRead, boolean allowTombstones) {
        return currRgn.nonTXGetEntry(keyInfo, false, allowTombstones);
    }
}

