/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class OrderedTombstoneMap<T> {
    private Map<VersionSource, TreeMap<VersionTag, T>> tombstoneMap = new HashMap<VersionSource, TreeMap<VersionTag, T>>();

    public void put(VersionTag tag, T entry) {
        T oldValue;
        Object member = tag.getMemberID();
        TreeMap<VersionTag, Object> memberMap = this.tombstoneMap.get(member);
        if (memberMap == null) {
            memberMap = new TreeMap(new VersionTagComparator());
            this.tombstoneMap.put((VersionSource)member, memberMap);
        }
        Assert.assertTrue((oldValue = memberMap.put(tag, entry)) == null);
    }

    public Map.Entry<VersionTag, T> take() {
        if (this.tombstoneMap.isEmpty()) {
            return null;
        }
        long lowestTimestamp = Long.MAX_VALUE;
        TreeMap<VersionTag, T> lowestMap = null;
        for (TreeMap<VersionTag, T> memberMap : this.tombstoneMap.values()) {
            VersionTag firstTag = memberMap.firstKey();
            long stamp = firstTag.getVersionTimeStamp();
            if (stamp >= lowestTimestamp) continue;
            lowestTimestamp = stamp;
            lowestMap = memberMap;
        }
        if (lowestMap == null) {
            return null;
        }
        Map.Entry result = lowestMap.firstEntry();
        lowestMap.remove(result.getKey());
        if (lowestMap.isEmpty()) {
            this.tombstoneMap.remove(((VersionTag)result.getKey()).getMemberID());
        }
        return result;
    }

    public static class VersionTagComparator
    implements Comparator<VersionTag> {
        @Override
        public int compare(VersionTag o1, VersionTag o2) {
            long result = o1.getRegionVersion() - o2.getRegionVersion();
            if (result == 0L) {
                result = o1.getVersionTimeStamp() - o2.getVersionTimeStamp();
            }
            return Long.signum(result);
        }
    }
}

