/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.DistributedCacheOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;

public class InvalidateRegionOperation
extends DistributedCacheOperation {
    public InvalidateRegionOperation(RegionEventImpl event) {
        super(event);
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        InvalidateRegionMessage msg = new InvalidateRegionMessage();
        RegionEventImpl regionEvent = (RegionEventImpl)this.event;
        msg.eventID = regionEvent.getEventId();
        return msg;
    }

    @Override
    protected Set getRecipients() {
        CacheDistributionAdvisor advisor = this.getRegion().getCacheDistributionAdvisor();
        return advisor.adviseInvalidateRegion();
    }

    @Override
    protected boolean supportsAdjunctMessaging() {
        return false;
    }

    public static final class InvalidateRegionMessage
    extends DistributedCacheOperation.CacheOperationMessage {
        protected EventID eventID;

        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            RegionEventImpl event = new RegionEventImpl(rgn, this.getOperation(), this.callbackArg, true, this.getSender());
            event.setEventID(this.eventID);
            if (this.filterRouting != null) {
                event.setLocalFilterInfo(this.filterRouting.getFilterInfo(rgn.getMyId()));
            }
            return event;
        }

        @Override
        protected boolean operateOnRegion(CacheEvent event, DistributionManager dm) throws EntryNotFoundException {
            RegionEventImpl ev = (RegionEventImpl)event;
            DistributedRegion rgn = (DistributedRegion)ev.region;
            rgn.basicInvalidateRegion(ev);
            this.appliedOperation = true;
            return true;
        }

        @Override
        public int getDSFID() {
            return -82;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.eventID = (EventID)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.eventID, out);
        }
    }
}

