/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class InvalidatePartitionedRegionMessage
extends PartitionMessage {
    private Object callbackArg;

    public InvalidatePartitionedRegionMessage() {
    }

    public InvalidatePartitionedRegionMessage(Set recipients, Object callbackArg, PartitionedRegion r, ReplyProcessor21 processor) {
        super(recipients, r.getPRId(), processor);
        this.callbackArg = callbackArg;
    }

    public static ReplyProcessor21 send(Set recipients, PartitionedRegion r, RegionEventImpl event) {
        ReplyProcessor21 response = new ReplyProcessor21(r.getSystem(), (Collection)recipients);
        InvalidatePartitionedRegionMessage msg = new InvalidatePartitionedRegionMessage(recipients, event.getCallbackArgument(), r, response);
        r.getSystem().getDistributionManager().putOutgoing(msg);
        return response;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException, QueryException, ForceReattemptException, InterruptedException {
        RegionEventImpl event = new RegionEventImpl(pr, Operation.REGION_INVALIDATE, this.callbackArg, !dm.getId().equals(this.getSender()), this.getSender());
        pr.basicInvalidateRegion(event);
        return true;
    }

    @Override
    public int getDSFID() {
        return -113;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.callbackArg = DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.callbackArg, out);
    }
}

