/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.distributed.internal.ConflationKey;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.cache.DistributedCacheOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.QueuedOperation;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.versions.ConcurrentCacheModificationException;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class InvalidateOperation
extends DistributedCacheOperation {
    private static final Logger logger = LogService.getLogger();

    public InvalidateOperation(EntryEventImpl event) {
        super(event);
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        if (this.event.hasClientOrigin()) {
            InvalidateWithContextMessage msgwithContxt = new InvalidateWithContextMessage();
            msgwithContxt.context = ((EntryEventImpl)this.event).getContext();
            return msgwithContxt;
        }
        return new InvalidateMessage();
    }

    @Override
    protected void initMessage(DistributedCacheOperation.CacheOperationMessage msg, DirectReplyProcessor processor) {
        super.initMessage(msg, processor);
        InvalidateMessage imsg = (InvalidateMessage)msg;
        EntryEventImpl eei = (EntryEventImpl)this.event;
        imsg.key = eei.getKey();
        imsg.eventId = eei.getEventId();
    }

    public static final class InvalidateWithContextMessage
    extends InvalidateMessage {
        transient ClientProxyMembershipID context;

        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            EntryEventImpl event = (EntryEventImpl)super.createEvent(rgn);
            event.setContext(this.context);
            return event;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; membershipID=");
            buff.append(this.context == null ? "" : this.context.toString());
        }

        @Override
        public int getDSFID() {
            return 140;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.context = ClientProxyMembershipID.readCanonicalized(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.context, out);
        }
    }

    public static class InvalidateMessage
    extends DistributedCacheOperation.CacheOperationMessage {
        protected Object key;
        protected EventID eventId = null;

        @Override
        protected boolean operateOnRegion(CacheEvent event, DistributionManager dm) throws EntryNotFoundException {
            EntryEventImpl ev = (EntryEventImpl)event;
            DistributedRegion rgn = (DistributedRegion)ev.region;
            try {
                if (!rgn.isCacheContentProxy()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("InvalidateMessage.operationOnRegion; key={}", new Object[]{ev.getKey()});
                    }
                    boolean forceNewEntry = rgn.dataPolicy.withReplication() && (!rgn.isInitialized() || rgn.getConcurrencyChecksEnabled());
                    boolean invokeCallbacks = rgn.isInitialized();
                    rgn.basicInvalidate(ev, invokeCallbacks, forceNewEntry);
                }
                this.appliedOperation = true;
                return true;
            }
            catch (ConcurrentCacheModificationException e) {
                this.dispatchElidedEvent(rgn, ev);
                return true;
            }
        }

        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            if (rgn.keyRequiresRegionContext()) {
                ((KeyWithRegionContext)this.key).setRegionContext(rgn);
            }
            EntryEventImpl ev = EntryEventImpl.create((LocalRegion)rgn, this.getOperation(), this.key, null, this.callbackArg, true, this.getSender());
            ev.setEventId(this.eventId);
            this.setOldValueInEvent(ev);
            ev.setVersionTag(this.versionTag);
            if (this.filterRouting != null) {
                ev.setLocalFilterInfo(this.filterRouting.getFilterInfo(rgn.getMyId()));
            }
            ev.setInhibitAllNotifications(this.inhibitAllNotifications);
            return ev;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; key=");
            buff.append(this.key);
        }

        @Override
        public int getDSFID() {
            return 101;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.eventId = (EventID)DataSerializer.readObject(in);
            this.key = DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.eventId, out);
            DataSerializer.writeObject(this.key, out);
        }

        @Override
        public EventID getEventID() {
            return this.eventId;
        }

        @Override
        public List getOperations() {
            byte deserializationPolicy = 0;
            QueuedOperation qOp = new QueuedOperation(this.getOperation(), this.key, null, null, deserializationPolicy, this.callbackArg);
            return Collections.singletonList(qOp);
        }

        @Override
        public ConflationKey getConflationKey() {
            if (!this.regionAllowsConflation || this.getProcessorId() != 0) {
                return null;
            }
            return new ConflationKey(this.key, this.regionPath, false);
        }
    }
}

