/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.ClientSession;
import com.gemstone.gemfire.cache.InterestRegistrationEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.tier.InterestType;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class InterestRegistrationEventImpl
implements InterestRegistrationEvent,
DataSerializable {
    private static final long serialVersionUID = -5791294858933070049L;
    private String regionName;
    private Set keysOfInterest;
    private int interestType;
    private boolean isRegister;
    private transient ClientSession clientSession;
    private transient Cache cache;

    public InterestRegistrationEventImpl() {
    }

    public InterestRegistrationEventImpl(CacheClientProxy clientSession, String regionName, Set keysOfInterest, int interestType2, boolean isRegister) {
        this.cache = clientSession.getCache();
        this.clientSession = clientSession;
        this.regionName = regionName;
        this.keysOfInterest = keysOfInterest;
        this.interestType = interestType2;
        this.isRegister = isRegister;
    }

    @Override
    public ClientSession getClientSession() {
        return this.clientSession;
    }

    @Override
    public String getRegionName() {
        return this.regionName;
    }

    public Region getRegion() {
        return this.cache.getRegion(this.regionName);
    }

    public Set getKeysOfInterest() {
        return this.keysOfInterest;
    }

    @Override
    public int getInterestType() {
        return this.interestType;
    }

    @Override
    public boolean isRegister() {
        return this.isRegister;
    }

    @Override
    public boolean isKey() {
        return this.interestType == 0;
    }

    @Override
    public boolean isRegularExpression() {
        return this.interestType == 1;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.regionName, out);
        DataSerializer.writeHashSet((HashSet)this.keysOfInterest, out);
        DataSerializer.writePrimitiveInt(this.interestType, out);
        DataSerializer.writePrimitiveBoolean(this.isRegister, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.regionName = DataSerializer.readString(in);
        this.keysOfInterest = DataSerializer.readHashSet(in);
        this.interestType = DataSerializer.readPrimitiveInt(in);
        this.isRegister = DataSerializer.readPrimitiveBoolean(in);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("InterestRegistrationEvent [").append("isRegister=").append(this.isRegister).append("clientSession=").append(this.clientSession).append("; isRegister=").append("; regionName=").append(this.regionName).append("; keysOfInterest=").append(this.keysOfInterest).append("; interestType=").append(InterestType.getString(this.interestType)).append("]");
        return buffer.toString();
    }
}

