/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.query.internal.CqStateImpl;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.cache.query.internal.cq.CqService;
import com.gemstone.gemfire.cache.query.internal.cq.ServerCQ;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.NullDataOutputStream;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryBits;
import com.gemstone.gemfire.internal.cache.EventStateHelper;
import com.gemstone.gemfire.internal.cache.FilterProfile;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.ImageState;
import com.gemstone.gemfire.internal.cache.InitialImageFlowControl;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionMap;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.ha.HAContainerWrapper;
import com.gemstone.gemfire.internal.cache.persistence.DiskStoreID;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.versions.DiskRegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.DiskVersionTag;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionHolder;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionStamp;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.sequencelog.EntryLogger;
import com.gemstone.gemfire.internal.util.ObjectIntProcedure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;

public class InitialImageOperation {
    private static final Logger logger = LogService.getLogger();
    public static volatile boolean abortTest = false;
    public static int CHUNK_SIZE_IN_BYTES = Integer.getInteger("GetInitialImage.chunkSize", 512000);
    public static int CHUNK_PERMITS = Integer.getInteger("gemfire.GetInitialImage.CHUNK_PERMITS", 16);
    public static int MAXIMUM_UNFINISHED_OPERATIONS = Integer.getInteger("gemfire.GetInitialImage.MAXIMUM_UNFINISHED_OPERATIONS", 10000);
    public static int MAX_PARALLEL_GIIS = Integer.getInteger("gemfire.GetInitialImage.MAX_PARALLEL_GIIS", 5);
    protected final DistributedRegion region;
    private final RegionMap entries;
    protected volatile boolean gotImage = false;
    protected RegionVersionHolder rcvd_holderToSync;
    protected Map<VersionSource, Long> gcVersions;
    protected volatile boolean isDeltaGII = false;
    public static volatile int slowImageProcessing = 0;
    public static volatile int slowImageSleeps = 0;
    public static boolean VMOTION_DURING_GII = false;
    private boolean isSynchronizing;
    private static final ThreadLocal inhibitStateFlush = new ThreadLocal(){

        protected Object initialValue() {
            return false;
        }
    };
    public static final boolean TRACE_GII = Boolean.getBoolean("gemfire.GetInitialImage.TRACE_GII");
    public static boolean FORCE_FULL_GII = Boolean.getBoolean("gemfire.GetInitialImage.FORCE_FULL_GII");
    private static GIITestHook internalBeforeGetInitialImage;
    private static GIITestHook internalBeforeRequestRVV;
    private static GIITestHook internalAfterRequestRVV;
    private static GIITestHook internalAfterCalculatedUnfinishedOps;
    private static GIITestHook internalBeforeSavedReceivedRVV;
    private static GIITestHook internalAfterSavedReceivedRVV;
    private static GIITestHook internalAfterSentRequestImage;
    private static GIITestHook internalAfterReceivedRequestImage;
    private static GIITestHook internalDuringPackingImage;
    private static GIITestHook internalAfterSentImageReply;
    private static GIITestHook internalAfterReceivedImageReply;
    private static GIITestHook internalDuringApplyDelta;
    private static GIITestHook internalBeforeCleanExpiredTombstones;
    private static GIITestHook internalAfterSavedRVVEnd;

    InitialImageOperation(DistributedRegion region, RegionMap entries) {
        this.region = region;
        this.entries = entries;
    }

    public static void setInhibitStateFlush(boolean inhibitIt) {
        inhibitStateFlush.set(inhibitIt);
    }

    private GIIStatus reportGIIStatus() {
        if (!this.gotImage) {
            return GIIStatus.NO_GII;
        }
        if (this.isDeltaGII) {
            return GIIStatus.GOTIMAGE_BY_DELTAGII;
        }
        return GIIStatus.GOTIMAGE_BY_FULLGII;
    }

    /*
     * Exception decompiling
     */
    GIIStatus getFromOne(Set recipientSet, boolean targetReinitialized, CacheDistributionAdvisor.InitialImageAdvice advice, boolean recoveredFromDisk, RegionVersionVector recoveredRVV) throws TimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void synchronizeWith(InternalDistributedMember target, VersionSource lostMemberVersionID, InternalDistributedMember lostMember) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkForUnrecordedOperations(InternalDistributedMember imageProvider) {
        ImageState state;
        boolean isTraceEnabled = logger.isTraceEnabled();
        RegionVersionVector rvv = this.region.getVersionVector();
        if (this.region.concurrencyChecksEnabled && rvv != null && (state = this.region.getImageState()).hasLeftMembers()) {
            HashSet<VersionSource> needsSync = null;
            Set<VersionSource> leftMembers = state.getLeftMembers();
            Iterator<ImageState.VersionTagEntry> tags = state.getVersionTags();
            while (tags.hasNext()) {
                ImageState.VersionTagEntry tag = tags.next();
                if (isTraceEnabled) {
                    logger.trace("checkForUnrecordedOperations: processing tag {}", new Object[]{tag});
                }
                if (!leftMembers.contains(tag.getMemberID()) || rvv.contains(tag.getMemberID(), tag.getRegionVersion())) continue;
                if (needsSync == null) {
                    needsSync = new HashSet<VersionSource>();
                }
                needsSync.add(tag.getMemberID());
                rvv.recordVersion(tag.getMemberID(), tag.getRegionVersion());
            }
            if (needsSync != null) {
                RequestSyncMessage msg = new RequestSyncMessage();
                msg.regionPath = this.region.getFullPath();
                msg.lostVersionSources = needsSync.toArray(new VersionSource[needsSync.size()]);
                Set<InternalDistributedMember> recipients = this.region.getCacheDistributionAdvisor().adviseReplicates();
                Iterator<InternalDistributedMember> it = recipients.iterator();
                while (it.hasNext()) {
                    InternalDistributedMember mbr = it.next();
                    if (mbr.getVersionObject().compareTo(Version.GFE_80) >= 0) continue;
                    it.remove();
                }
                if (!recipients.isEmpty()) {
                    msg.setRecipients(recipients);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Local versions were found that the image provider has not seen for {}", new Object[]{needsSync});
                    }
                    this.region.getDistributionManager().putOutgoing(msg);
                }
            }
        }
    }

    public static void beforeGetInitialImage(DistributedRegion region) {
        if (internalBeforeGetInitialImage != null && internalBeforeGetInitialImage.getRegionName().equals(region.getName())) {
            internalBeforeGetInitialImage.run();
        }
    }

    private boolean requestFilterInfo(InternalDistributedMember recipient) {
        DM dm = this.region.getDistributionManager();
        RequestFilterInfoMessage filterInfoMsg = new RequestFilterInfoMessage();
        filterInfoMsg.regionPath = this.region.getFullPath();
        filterInfoMsg.setRecipient(recipient);
        FilterInfoProcessor processor = new FilterInfoProcessor(this.region.getSystem(), recipient);
        filterInfoMsg.processorId = processor.getProcessorId();
        dm.putOutgoing(filterInfoMsg);
        try {
            processor.waitForRepliesUninterruptibly();
            return processor.filtersReceived;
        }
        catch (InternalGemFireException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof TimeoutException) {
                throw (TimeoutException)cause;
            }
            throw ex;
        }
        catch (ReplyException e) {
            if (!this.region.isDestroyed()) {
                e.handleAsUnexpected();
            }
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    boolean processChunk(List entries, InternalDistributedMember sender, Version remoteVersion) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected RegionVersionVector getRVVFromProvider(DistributionManager dm, InternalDistributedMember recipient, boolean targetReinitialized) {
        RegionVersionVector received_rvv;
        block5: {
            received_rvv = null;
            RequestRVVMessage rrm = new RequestRVVMessage();
            rrm.regionPath = this.region.getFullPath();
            rrm.targetReinitialized = targetReinitialized;
            rrm.setRecipient(recipient);
            RequestRVVProcessor rvv_processor = new RequestRVVProcessor(this.region.getSystem(), recipient);
            rrm.processorId = rvv_processor.getProcessorId();
            dm.putOutgoing(rrm);
            if (internalAfterRequestRVV != null && internalAfterRequestRVV.getRegionName().equals(this.region.getName())) {
                internalAfterRequestRVV.run();
            }
            try {
                rvv_processor.waitForRepliesUninterruptibly();
                received_rvv = rvv_processor.received_rvv;
            }
            catch (InternalGemFireException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof TimeoutException) {
                    throw (TimeoutException)cause;
                }
                throw ex;
            }
            catch (ReplyException e) {
                if (this.region.isDestroyed()) break block5;
                e.handleAsUnexpected();
            }
        }
        return received_rvv;
    }

    protected Set processReceivedRVV(RegionVersionVector remoteRVV, RegionVersionVector localRVV) {
        if (remoteRVV == null) {
            return null;
        }
        HashSet<Object> keys = new HashSet<Object>();
        if (this.region.getDataPolicy().withPersistence() && localRVV.isNewerThanOrCanFillExceptionsFor(remoteRVV)) {
            Iterator<RegionEntry> it = this.region.getBestIterator(false);
            int count = 0;
            VersionSource myId = this.region.getVersionMember();
            while (it.hasNext()) {
                RegionEntry mapEntry = it.next();
                VersionStamp stamp = mapEntry.getVersionStamp();
                Object id = stamp.getMemberID();
                if (id == null) {
                    id = myId;
                }
                if (remoteRVV.contains(id, stamp.getRegionVersion())) continue;
                keys.add(mapEntry.getKey());
                remoteRVV.recordVersion(id, stamp.getRegionVersion());
                if (count < 10 && logger.isTraceEnabled(LogMarker.GII)) {
                    logger.trace(LogMarker.GII, "Region:{} found unfinished operation key={},member={},region version={}", new Object[]{this.region.getFullPath(), mapEntry.getKey(), stamp.getMemberID(), stamp.getRegionVersion()});
                }
                ++count;
            }
            if (!keys.isEmpty() && logger.isTraceEnabled(LogMarker.GII)) {
                logger.trace(LogMarker.GII, "Region:{} found {} unfinished operations", new Object[]{this.region.getFullPath(), keys.size()});
            }
        }
        return keys;
    }

    protected void saveReceivedRVV(RegionVersionVector rvv) {
        assert (rvv != null);
        if (logger.isTraceEnabled(LogMarker.GII)) {
            logger.trace(LogMarker.GII, "Applying received version vector {} to {}", new Object[]{rvv.fullToString(), this.region.getName()});
        }
        this.region.getVersionVector().recordVersions(rvv);
        if (this.region.getDataPolicy().withPersistence()) {
            this.region.getDiskRegion().writeRVV(this.region, false);
            this.region.getDiskRegion().writeRVVGC(this.region);
        }
        if (logger.isTraceEnabled(LogMarker.GII)) {
            logger.trace(LogMarker.GII, "version vector is now {}", new Object[]{this.region.getVersionVector().fullToString()});
        }
    }

    protected static String arrayToString(int[] a) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < a.length; ++i) {
            buf.append(String.valueOf(a[i]));
            if (i >= a.length - 1) continue;
            buf.append(",");
        }
        buf.append("]");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static LocalRegion getGIIRegion(DistributionManager dm, String regionPath, boolean targetReinitialized) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        LocalRegion lclRgn = null;
        int initLevel = targetReinitialized ? 0 : 2;
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(initLevel);
        try {
            InternalDistributedSystem system = dm.getSystem();
            if (isDebugEnabled) {
                logger.debug("RequestImageMessage: attempting to get region reference for {}, initLevel={}", new Object[]{regionPath, initLevel});
            }
            if ((lclRgn = LocalRegion.getRegionFromPath(system, regionPath)) != null && !lclRgn.isUsedForPartitionedRegionBucket() && targetReinitialized && !lclRgn.reinitialized_new()) {
                lclRgn = null;
                if (isDebugEnabled) {
                    logger.debug("GII message process: Found region, but wasn't reinitialized, so assuming region destroyed and recreated");
                }
            }
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
        if (lclRgn == null || !lclRgn.isInitialized()) {
            if (isDebugEnabled) {
                logger.debug("{}, nothing to do", new Object[]{lclRgn == null ? "region not found" : "region not initialized yet"});
            }
            return null;
        }
        if (lclRgn.scope.isLocal()) {
            if (isDebugEnabled) {
                logger.debug("local scope region, nothing to do");
            }
            return null;
        }
        return lclRgn;
    }

    public static GIITestHook getGIITestHookForCheckingPurpose(GIITestHookType type) {
        switch (type) {
            case BeforeGetInitialImage: {
                return internalBeforeGetInitialImage;
            }
            case BeforeRequestRVV: {
                return internalBeforeRequestRVV;
            }
            case AfterRequestRVV: {
                return internalAfterRequestRVV;
            }
            case AfterCalculatedUnfinishedOps: {
                return internalAfterCalculatedUnfinishedOps;
            }
            case BeforeSavedReceivedRVV: {
                return internalBeforeSavedReceivedRVV;
            }
            case AfterSavedReceivedRVV: {
                return internalAfterSavedReceivedRVV;
            }
            case AfterSentRequestImage: {
                return internalAfterSentRequestImage;
            }
            case AfterReceivedRequestImage: {
                return internalAfterReceivedRequestImage;
            }
            case DuringPackingImage: {
                return internalDuringPackingImage;
            }
            case AfterSentImageReply: {
                return internalAfterSentImageReply;
            }
            case AfterReceivedImageReply: {
                return internalAfterReceivedImageReply;
            }
            case DuringApplyDelta: {
                return internalDuringApplyDelta;
            }
            case BeforeCleanExpiredTombstones: {
                return internalBeforeCleanExpiredTombstones;
            }
            case AfterSavedRVVEnd: {
                return internalAfterSavedRVVEnd;
            }
        }
        throw new RuntimeException("Illegal test hook type");
    }

    public static void setGIITestHook(GIITestHook callback) {
        switch (callback.type) {
            case BeforeGetInitialImage: {
                assert (internalBeforeGetInitialImage == null);
                internalBeforeGetInitialImage = callback;
                break;
            }
            case BeforeRequestRVV: {
                assert (internalBeforeRequestRVV == null);
                internalBeforeRequestRVV = callback;
                break;
            }
            case AfterRequestRVV: {
                assert (internalAfterRequestRVV == null);
                internalAfterRequestRVV = callback;
                break;
            }
            case AfterCalculatedUnfinishedOps: {
                assert (internalAfterCalculatedUnfinishedOps == null);
                internalAfterCalculatedUnfinishedOps = callback;
                break;
            }
            case BeforeSavedReceivedRVV: {
                assert (internalBeforeSavedReceivedRVV == null);
                internalBeforeSavedReceivedRVV = callback;
                break;
            }
            case AfterSavedReceivedRVV: {
                internalAfterSavedReceivedRVV = callback;
                break;
            }
            case AfterSentRequestImage: {
                internalAfterSentRequestImage = callback;
                break;
            }
            case AfterReceivedRequestImage: {
                assert (internalAfterReceivedRequestImage == null);
                internalAfterReceivedRequestImage = callback;
                break;
            }
            case DuringPackingImage: {
                assert (internalDuringPackingImage == null);
                internalDuringPackingImage = callback;
                break;
            }
            case AfterSentImageReply: {
                assert (internalAfterSentImageReply == null);
                internalAfterSentImageReply = callback;
                break;
            }
            case AfterReceivedImageReply: {
                assert (internalAfterReceivedImageReply == null);
                internalAfterReceivedImageReply = callback;
                break;
            }
            case DuringApplyDelta: {
                assert (internalDuringApplyDelta == null);
                internalDuringApplyDelta = callback;
                break;
            }
            case BeforeCleanExpiredTombstones: {
                assert (internalBeforeCleanExpiredTombstones == null);
                internalBeforeCleanExpiredTombstones = callback;
                break;
            }
            case AfterSavedRVVEnd: {
                assert (internalAfterSavedRVVEnd == null);
                internalAfterSavedRVVEnd = callback;
                break;
            }
            default: {
                throw new RuntimeException("Illegal test hook type");
            }
        }
    }

    public static void resetGIITestHook(GIITestHookType type, boolean setNull) {
        switch (type) {
            case BeforeGetInitialImage: {
                if (internalBeforeGetInitialImage == null) break;
                internalBeforeGetInitialImage.reset();
                if (!setNull) break;
                internalBeforeGetInitialImage = null;
                break;
            }
            case BeforeRequestRVV: {
                if (internalBeforeRequestRVV == null) break;
                internalBeforeRequestRVV.reset();
                if (!setNull) break;
                internalBeforeRequestRVV = null;
                break;
            }
            case AfterRequestRVV: {
                if (internalAfterRequestRVV == null) break;
                internalAfterRequestRVV.reset();
                if (!setNull) break;
                internalAfterRequestRVV = null;
                break;
            }
            case AfterCalculatedUnfinishedOps: {
                if (internalAfterCalculatedUnfinishedOps == null) break;
                internalAfterCalculatedUnfinishedOps.reset();
                if (!setNull) break;
                internalAfterCalculatedUnfinishedOps = null;
                break;
            }
            case BeforeSavedReceivedRVV: {
                if (internalBeforeSavedReceivedRVV == null) break;
                internalBeforeSavedReceivedRVV.reset();
                if (!setNull) break;
                internalBeforeSavedReceivedRVV = null;
                break;
            }
            case AfterSavedReceivedRVV: {
                if (internalAfterSavedReceivedRVV == null) break;
                internalAfterSavedReceivedRVV.reset();
                if (!setNull) break;
                internalAfterSavedReceivedRVV = null;
                break;
            }
            case AfterSentRequestImage: {
                if (internalAfterSentRequestImage == null) break;
                internalAfterSentRequestImage.reset();
                if (!setNull) break;
                internalAfterSentRequestImage = null;
                break;
            }
            case AfterReceivedRequestImage: {
                if (internalAfterReceivedRequestImage == null) break;
                internalAfterReceivedRequestImage.reset();
                if (!setNull) break;
                internalAfterReceivedRequestImage = null;
                break;
            }
            case DuringPackingImage: {
                if (internalDuringPackingImage == null) break;
                internalDuringPackingImage.reset();
                if (!setNull) break;
                internalDuringPackingImage = null;
                break;
            }
            case AfterSentImageReply: {
                if (internalAfterSentImageReply == null) break;
                internalAfterSentImageReply.reset();
                if (!setNull) break;
                internalAfterSentImageReply = null;
                break;
            }
            case AfterReceivedImageReply: {
                if (internalAfterReceivedImageReply == null) break;
                internalAfterReceivedImageReply.reset();
                if (!setNull) break;
                internalAfterReceivedImageReply = null;
                break;
            }
            case DuringApplyDelta: {
                if (internalDuringApplyDelta == null) break;
                internalDuringApplyDelta.reset();
                if (!setNull) break;
                internalDuringApplyDelta = null;
                break;
            }
            case BeforeCleanExpiredTombstones: {
                if (internalBeforeCleanExpiredTombstones == null) break;
                internalBeforeCleanExpiredTombstones.reset();
                if (!setNull) break;
                internalBeforeCleanExpiredTombstones = null;
                break;
            }
            case AfterSavedRVVEnd: {
                if (internalAfterSavedRVVEnd == null) break;
                internalAfterSavedRVVEnd.reset();
                if (!setNull) break;
                internalAfterSavedRVVEnd = null;
                break;
            }
            default: {
                throw new RuntimeException("Illegal test hook type");
            }
        }
    }

    public static void resetAllGIITestHooks() {
        internalBeforeGetInitialImage = null;
        internalBeforeRequestRVV = null;
        internalAfterRequestRVV = null;
        internalAfterCalculatedUnfinishedOps = null;
        internalBeforeSavedReceivedRVV = null;
        internalAfterSavedReceivedRVV = null;
        internalAfterSentRequestImage = null;
        internalAfterReceivedRequestImage = null;
        internalDuringPackingImage = null;
        internalAfterSentImageReply = null;
        internalAfterReceivedImageReply = null;
        internalDuringApplyDelta = null;
        internalBeforeCleanExpiredTombstones = null;
        internalAfterSavedRVVEnd = null;
    }

    static /* synthetic */ GIITestHook access$300() {
        return internalAfterReceivedImageReply;
    }

    public static enum GIITestHookType {
        BeforeGetInitialImage,
        BeforeRequestRVV,
        AfterRequestRVV,
        AfterCalculatedUnfinishedOps,
        BeforeSavedReceivedRVV,
        AfterSavedReceivedRVV,
        AfterSentRequestImage,
        AfterReceivedRequestImage,
        DuringPackingImage,
        AfterSentImageReply,
        AfterReceivedImageReply,
        DuringApplyDelta,
        BeforeCleanExpiredTombstones,
        AfterSavedRVVEnd;

    }

    public static abstract class GIITestHook
    implements Runnable {
        private final GIITestHookType type;
        private final String region_name;
        public volatile boolean isRunning;

        public GIITestHook(GIITestHookType type, String region_name) {
            this.type = type;
            this.region_name = region_name;
            this.isRunning = false;
        }

        public GIITestHookType getType() {
            return this.type;
        }

        public String getRegionName() {
            return this.region_name;
        }

        public String toString() {
            return (Object)((Object)this.type) + ":" + this.region_name + ":" + this.isRunning;
        }

        public abstract void reset();

        @Override
        public abstract void run();
    }

    public static class FilterInfoMessage
    extends ReplyMessage {
        private LocalRegion haRegion;
        private Map emptyRegionMap;
        private final InterestMaps[] interestMaps = new InterestMaps[]{new InterestMaps(), new InterestMaps()};
        static final int NON_DURABLE = 0;
        static final int DURABLE = 1;
        private Map<String, ServerCQ> cqs;

        @Override
        public boolean getInlineProcess() {
            return false;
        }

        public FilterInfoMessage() {
        }

        private FilterInfoMessage(InternalDistributedMember mbr, int processorId, LocalRegion haRegion) {
            this.setRecipient(mbr);
            this.setProcessorId(processorId);
            this.haRegion = haRegion;
        }

        public void fillInFilterInfo() {
            block13: {
                LocalRegion haReg = this.haRegion;
                if (haReg == null || haReg.getName() == null) {
                    throw new ReplyException("HARegion for the proxy is Null.");
                }
                GemFireCacheImpl cache = haReg.getCache();
                CacheClientNotifier ccn = CacheClientNotifier.getInstance();
                if (ccn == null || ccn.getHaContainer() == null) {
                    logger.info("HA Container not found during HA Region GII for {}", new Object[]{haReg});
                    return;
                }
                CacheClientProxy clientProxy = null;
                ClientProxyMembershipID clientID = ((HAContainerWrapper)ccn.getHaContainer()).getProxyID(haReg.getName());
                if (clientID == null) {
                    throw new ReplyException("Client proxy ID not found for queue " + haReg.getName());
                }
                clientProxy = ccn.getClientProxy(clientID);
                if (clientProxy == null) {
                    throw new ReplyException("Client proxy not found for queue " + haReg.getName());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Gathering interest information for {}", new Object[]{clientProxy});
                }
                this.emptyRegionMap = clientProxy.getRegionsWithEmptyDataPolicy();
                Set<String> regions = clientProxy.getInterestRegisteredRegions();
                for (String rName : regions) {
                    LocalRegion r = (LocalRegion)cache.getRegion(rName);
                    if (r == null) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Finding interest on region :{} for Client(ID) :{}", new Object[]{r.getName(), clientID});
                    }
                    FilterProfile pf = r.getFilterProfile();
                    this.getInterestMaps(pf, rName, 0, clientID);
                    if (!clientID.isDurable()) continue;
                    this.getInterestMaps(pf, rName, 1, clientID.getDurableId());
                }
                CqService cqService = cache.getCqService();
                if (cqService != null) {
                    try {
                        List<ServerCQ> cqsList = cqService.getAllClientCqs(clientID);
                        if (!cqsList.isEmpty()) {
                            this.cqs = new HashMap<String, ServerCQ>();
                            for (ServerCQ cq : cqsList) {
                                this.cqs.put(cq.getName(), cq);
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) break block13;
                        logger.debug("{}: Failed to get CQ info. {}", new Object[]{this, ex.getMessage(), ex});
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Number of filters filled : {}", new Object[]{this});
            }
        }

        private void getInterestMaps(FilterProfile pf, String rName, int mapIndex, Object interestID) {
            block18: {
                try {
                    Set keys;
                    boolean all = pf.isInterestedInAllKeys(interestID);
                    if (all) {
                        if (this.interestMaps[mapIndex].allKeys == null) {
                            this.interestMaps[mapIndex].allKeys = new HashMap<String, String>();
                        }
                        this.interestMaps[mapIndex].allKeys.put(rName, ".*");
                    }
                    if (all = pf.isInterestedInAllKeysInv(interestID)) {
                        if (this.interestMaps[mapIndex].allKeysInv == null) {
                            this.interestMaps[mapIndex].allKeysInv = new HashMap<String, String>();
                        }
                        this.interestMaps[mapIndex].allKeysInv.put(rName, ".*");
                    }
                    if ((keys = pf.getKeysOfInterest(interestID)) != null) {
                        if (this.interestMaps[mapIndex].keysOfInterest == null) {
                            this.interestMaps[mapIndex].keysOfInterest = new HashMap<String, Set>();
                        }
                        this.interestMaps[mapIndex].keysOfInterest.put(rName, keys);
                    }
                    if ((keys = pf.getKeysOfInterestInv(interestID)) != null) {
                        if (this.interestMaps[mapIndex].keysOfInterestInv == null) {
                            this.interestMaps[mapIndex].keysOfInterestInv = new HashMap<String, Set>();
                        }
                        this.interestMaps[mapIndex].keysOfInterestInv.put(rName, keys);
                    }
                    if ((keys = pf.getPatternsOfInterest(interestID)) != null) {
                        if (this.interestMaps[mapIndex].patternsOfInterest == null) {
                            this.interestMaps[mapIndex].patternsOfInterest = new HashMap<String, Set>();
                        }
                        this.interestMaps[mapIndex].patternsOfInterest.put(rName, keys);
                    }
                    if ((keys = pf.getPatternsOfInterestInv(interestID)) != null) {
                        if (this.interestMaps[mapIndex].patternsOfInterestInv == null) {
                            this.interestMaps[mapIndex].patternsOfInterestInv = new HashMap<String, Set>();
                        }
                        this.interestMaps[mapIndex].patternsOfInterestInv.put(rName, keys);
                    }
                    if ((keys = pf.getFiltersOfInterest(interestID)) != null) {
                        if (this.interestMaps[mapIndex].filtersOfInterest == null) {
                            this.interestMaps[mapIndex].filtersOfInterest = new HashMap<String, Set>();
                        }
                        this.interestMaps[mapIndex].filtersOfInterest.put(rName, keys);
                    }
                    if ((keys = pf.getFiltersOfInterestInv(interestID)) != null) {
                        if (this.interestMaps[mapIndex].filtersOfInterestInv == null) {
                            this.interestMaps[mapIndex].filtersOfInterestInv = new HashMap<String, Set>();
                        }
                        this.interestMaps[mapIndex].filtersOfInterestInv.put(rName, keys);
                    }
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block18;
                    logger.debug("{}: Failed to get Register interest info for region : {}", new Object[]{this, rName, ex});
                }
            }
        }

        public void registerFilters(LocalRegion region) {
            CacheClientProxy proxy;
            CacheClientNotifier ccn = CacheClientNotifier.getInstance();
            try {
                if (ccn == null || ccn.getHaContainer() == null) {
                    logger.info("Found null cache client notifier. Failed to register Filters during HARegion GII. Region :{}", new Object[]{region.getName()});
                    return;
                }
                proxy = ((HAContainerWrapper)ccn.getHaContainer()).getProxy(region.getName());
            }
            catch (Exception ex) {
                logger.info("Unable to obtain the client proxy. Failed to register Filters during HARegion GII. Region :{}, {}", new Object[]{region.getName(), ex.getMessage(), ex});
                return;
            }
            if (proxy == null) {
                logger.info("Found null client proxy. Failed to register Filters during HARegion GII. Region :{}, HaContainer :{}", new Object[]{region.getName(), ccn.getHaContainer()});
                return;
            }
            this.registerFilters(region, proxy, false);
            if (proxy.getProxyID().isDurable()) {
                this.registerFilters(region, proxy, true);
            }
            if (this.cqs != null && !this.cqs.isEmpty()) {
                try {
                    CqService cqService = ((DefaultQueryService)region.getCache().getQueryService()).getCqService();
                    for (Map.Entry<String, ServerCQ> e : this.cqs.entrySet()) {
                        ServerCQ cq = e.getValue();
                        try {
                            cqService.executeCq(e.getKey(), cq.getQueryString(), ((CqStateImpl)cq.getState()).getState(), proxy.getProxyID(), ccn, cq.isDurable(), true, -1, this.emptyRegionMap);
                        }
                        catch (Exception ex) {
                            logger.info("Failed to register CQ during HARegion GII. CQ: {} {}", new Object[]{e.getKey(), ex.getMessage(), ex});
                        }
                    }
                }
                catch (Exception ex) {
                    logger.info("Failed to get CqService for CQ registration during HARegion GII. {}", new Object[]{ex.getMessage(), ex});
                }
            }
        }

        private void registerFilters(LocalRegion region, CacheClientProxy proxy, boolean durable) {
            CacheClientNotifier ccn = CacheClientNotifier.getInstance();
            HashSet<String> regionsWithInterest = new HashSet<String>();
            int mapIndex = durable ? 1 : 0;
            try {
                this.registerInterestKeys(this.interestMaps[mapIndex].allKeys, true, region, ccn, proxy, durable, false, 1, regionsWithInterest);
            }
            catch (Exception ex) {
                logger.info("Failed to register interest of type keys during HARegion GII. {}", new Object[]{ex.getMessage(), ex});
            }
            try {
                this.registerInterestKeys(this.interestMaps[mapIndex].allKeysInv, true, region, ccn, proxy, durable, false, 1, regionsWithInterest);
            }
            catch (Exception ex) {
                logger.info("Failed to register interest of type keys during HARegion GII. {}", new Object[]{ex.getMessage(), ex});
            }
            try {
                this.registerInterestKeys(this.interestMaps[mapIndex].keysOfInterest, false, region, ccn, proxy, durable, false, 0, regionsWithInterest);
            }
            catch (Exception ex) {
                logger.info("Failed to register interest of type keys during HARegion GII. {}", new Object[]{ex.getMessage(), ex});
            }
            try {
                this.registerInterestKeys(this.interestMaps[mapIndex].keysOfInterestInv, false, region, ccn, proxy, durable, true, 0, regionsWithInterest);
            }
            catch (Exception ex) {
                logger.info("Failed to register interest of type keys for invalidates during HARegion GII. {}", new Object[]{ex.getMessage(), ex});
            }
            try {
                this.registerInterestKeys(this.interestMaps[mapIndex].patternsOfInterest, false, region, ccn, proxy, durable, false, 1, regionsWithInterest);
            }
            catch (Exception ex) {
                logger.info("Failed to register interest of type expression during HARegion GII. {}", new Object[]{ex.getMessage(), ex});
            }
            try {
                this.registerInterestKeys(this.interestMaps[mapIndex].patternsOfInterestInv, false, region, ccn, proxy, durable, true, 1, regionsWithInterest);
            }
            catch (Exception ex) {
                logger.info("Failed to register interest of type expression for invalidates during HARegion GII. {}", new Object[]{ex.getMessage(), ex});
            }
            try {
                this.registerInterestKeys(this.interestMaps[mapIndex].filtersOfInterest, false, region, ccn, proxy, durable, false, 2, regionsWithInterest);
            }
            catch (Exception ex) {
                logger.info("Failed to register interest of type filter during HARegion GII. {}", new Object[]{ex.getMessage(), ex});
            }
            try {
                this.registerInterestKeys(this.interestMaps[mapIndex].filtersOfInterestInv, false, region, ccn, proxy, durable, true, 2, regionsWithInterest);
            }
            catch (Exception ex) {
                logger.info("Failed to register interest of type filter for invalidates during HARegion GII. {}", new Object[]{ex.getMessage(), ex});
            }
            for (String regionName : regionsWithInterest) {
                proxy.flushForInterestRegistration(regionName, this.getSender());
            }
        }

        private void registerInterestKeys(Map regionKeys, boolean allKey, LocalRegion region, CacheClientNotifier ccn, CacheClientProxy proxy, boolean isDurable, boolean updatesAsInvalidates, int interestType2, Set<String> regionsWithInterest) throws IOException {
            boolean isDebugEnabled = logger.isDebugEnabled();
            if (regionKeys != null) {
                for (Map.Entry e : regionKeys.entrySet()) {
                    String regionName = (String)e.getKey();
                    if (region.getCache().getRegion(regionName) == null) {
                        if (!isDebugEnabled) continue;
                        logger.debug("Unable to register interests. Region not found :{}" + regionName);
                        continue;
                    }
                    boolean manageEmptyRegions = false;
                    if (this.emptyRegionMap != null) {
                        manageEmptyRegions = this.emptyRegionMap.containsKey(regionName);
                    }
                    regionsWithInterest.add(regionName);
                    if (allKey) {
                        ccn.registerClientInterest(regionName, e.getValue(), proxy.getProxyID(), interestType2, isDurable, updatesAsInvalidates, manageEmptyRegions, 0, false);
                        continue;
                    }
                    if (1 == interestType2) {
                        Iterator i = ((Set)e.getValue()).iterator();
                        while (i.hasNext()) {
                            ccn.registerClientInterest(regionName, (String)i.next(), proxy.getProxyID(), interestType2, isDurable, updatesAsInvalidates, manageEmptyRegions, 0, false);
                        }
                        continue;
                    }
                    ccn.registerClientInterest(regionName, new ArrayList((Set)e.getValue()), proxy.getProxyID(), isDurable, updatesAsInvalidates, manageEmptyRegions, interestType2, false);
                }
            }
        }

        public static void send(DM dm, InternalDistributedMember dest, int processorId, LocalRegion rgn, ReplyException ex) {
            FilterInfoMessage msg = new FilterInfoMessage(dest, processorId, rgn);
            if (ex != null) {
                msg.setException(ex);
            } else {
                try {
                    msg.fillInFilterInfo();
                }
                catch (ReplyException e) {
                    msg.setException(e);
                }
            }
            dm.putOutgoing(msg);
        }

        @Override
        public String toString() {
            String descr = super.toString();
            descr = descr + "; NON_DURABLE allKeys=" + (this.interestMaps[0].allKeys != null ? this.interestMaps[0].allKeys.size() : 0) + "; allKeysInv=" + (this.interestMaps[0].allKeysInv != null ? this.interestMaps[0].allKeysInv.size() : 0) + "; keysOfInterest=" + (this.interestMaps[0].keysOfInterest != null ? this.interestMaps[0].keysOfInterest.size() : 0) + "; keysOfInterestInv=" + (this.interestMaps[0].keysOfInterestInv != null ? this.interestMaps[0].keysOfInterestInv.size() : 0) + "; patternsOfInterest=" + (this.interestMaps[0].patternsOfInterest != null ? this.interestMaps[0].patternsOfInterest.size() : 0) + "; patternsOfInterestInv=" + (this.interestMaps[0].patternsOfInterestInv != null ? this.interestMaps[0].patternsOfInterestInv.size() : 0) + "; filtersOfInterest=" + (this.interestMaps[0].filtersOfInterest != null ? this.interestMaps[0].filtersOfInterest.size() : 0) + "; filtersOfInterestInv=" + (this.interestMaps[0].filtersOfInterestInv != null ? this.interestMaps[0].filtersOfInterestInv.size() : 0);
            descr = descr + "; DURABLE allKeys=" + (this.interestMaps[1].allKeys != null ? this.interestMaps[1].allKeys.size() : 0) + "; allKeysInv=" + (this.interestMaps[1].allKeysInv != null ? this.interestMaps[1].allKeysInv.size() : 0) + "; keysOfInterest=" + (this.interestMaps[1].keysOfInterest != null ? this.interestMaps[1].keysOfInterest.size() : 0) + "; keysOfInterestInv=" + (this.interestMaps[1].keysOfInterestInv != null ? this.interestMaps[1].keysOfInterestInv.size() : 0) + "; patternsOfInterest=" + (this.interestMaps[1].patternsOfInterest != null ? this.interestMaps[1].patternsOfInterest.size() : 0) + "; patternsOfInterestInv=" + (this.interestMaps[1].patternsOfInterestInv != null ? this.interestMaps[1].patternsOfInterestInv.size() : 0) + "; filtersOfInterest=" + (this.interestMaps[1].filtersOfInterest != null ? this.interestMaps[1].filtersOfInterest.size() : 0) + "; filtersOfInterestInv=" + (this.interestMaps[1].filtersOfInterestInv != null ? this.interestMaps[1].filtersOfInterestInv.size() : 0);
            descr = descr + "; cqs=" + (this.cqs != null ? this.cqs.size() : 0);
            return descr;
        }

        public boolean isEmpty() {
            return this.interestMaps[0].keysOfInterest == null && this.interestMaps[0].keysOfInterestInv == null && this.interestMaps[0].patternsOfInterest == null && this.interestMaps[0].patternsOfInterestInv == null && this.interestMaps[0].filtersOfInterest == null && this.interestMaps[0].filtersOfInterestInv == null && this.interestMaps[1].patternsOfInterest == null && this.interestMaps[1].patternsOfInterestInv == null && this.interestMaps[1].filtersOfInterest == null && this.interestMaps[1].filtersOfInterestInv == null && this.cqs == null;
        }

        @Override
        public void toData(DataOutput dop) throws IOException {
            super.toData(dop);
            DataSerializer.writeHashMap((HashMap)this.emptyRegionMap, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[0].allKeys, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[0].allKeysInv, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[0].keysOfInterest, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[0].keysOfInterestInv, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[0].patternsOfInterest, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[0].patternsOfInterestInv, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[0].filtersOfInterest, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[0].filtersOfInterestInv, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[1].allKeys, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[1].allKeysInv, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[1].keysOfInterest, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[1].keysOfInterestInv, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[1].patternsOfInterest, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[1].patternsOfInterestInv, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[1].filtersOfInterest, dop);
            DataSerializer.writeHashMap((HashMap)this.interestMaps[1].filtersOfInterestInv, dop);
            DataSerializer.writeHashMap((HashMap)this.cqs, dop);
        }

        @Override
        public void fromData(DataInput dip) throws IOException, ClassNotFoundException {
            super.fromData(dip);
            this.emptyRegionMap = DataSerializer.readHashMap(dip);
            this.interestMaps[0].allKeys = DataSerializer.readHashMap(dip);
            this.interestMaps[0].allKeysInv = DataSerializer.readHashMap(dip);
            this.interestMaps[0].keysOfInterest = DataSerializer.readHashMap(dip);
            this.interestMaps[0].keysOfInterestInv = DataSerializer.readHashMap(dip);
            this.interestMaps[0].patternsOfInterest = DataSerializer.readHashMap(dip);
            this.interestMaps[0].patternsOfInterestInv = DataSerializer.readHashMap(dip);
            this.interestMaps[0].filtersOfInterest = DataSerializer.readHashMap(dip);
            this.interestMaps[0].filtersOfInterestInv = DataSerializer.readHashMap(dip);
            this.interestMaps[1].allKeys = DataSerializer.readHashMap(dip);
            this.interestMaps[1].allKeysInv = DataSerializer.readHashMap(dip);
            this.interestMaps[1].keysOfInterest = DataSerializer.readHashMap(dip);
            this.interestMaps[1].keysOfInterestInv = DataSerializer.readHashMap(dip);
            this.interestMaps[1].patternsOfInterest = DataSerializer.readHashMap(dip);
            this.interestMaps[1].patternsOfInterestInv = DataSerializer.readHashMap(dip);
            this.interestMaps[1].filtersOfInterest = DataSerializer.readHashMap(dip);
            this.interestMaps[1].filtersOfInterestInv = DataSerializer.readHashMap(dip);
            this.cqs = DataSerializer.readHashMap(dip);
        }

        @Override
        public int getDSFID() {
            return 1076;
        }

        static class InterestMaps {
            Map<String, String> allKeys;
            Map<String, String> allKeysInv;
            Map<String, Set> keysOfInterest;
            Map<String, Set> keysOfInterestInv;
            Map<String, Set> patternsOfInterest;
            Map<String, Set> patternsOfInterestInv;
            Map<String, Set> filtersOfInterest;
            Map<String, Set> filtersOfInterestInv;

            InterestMaps() {
            }
        }
    }

    public static class RegionStateMessage
    extends ReplyMessage {
        Map eventState;
        private boolean isHARegion;
        RegionVersionVector versionVector;

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public RegionStateMessage() {
        }

        private RegionStateMessage(InternalDistributedMember mbr, int processorId, Map eventState, boolean isHARegion) {
            this.setRecipient(mbr);
            this.setProcessorId(processorId);
            this.eventState = eventState;
            this.isHARegion = isHARegion;
        }

        private RegionStateMessage(InternalDistributedMember mbr, int processorId, RegionVersionVector rvv, boolean isHARegion) {
            this.setRecipient(mbr);
            this.setProcessorId(processorId);
            this.versionVector = rvv;
            this.isHARegion = isHARegion;
        }

        public static void send(DM dm, InternalDistributedMember dest, int processorId, Map<? extends DataSerializable, ? extends DataSerializable> eventState, boolean isHARegion) {
            RegionStateMessage msg = new RegionStateMessage(dest, processorId, eventState, isHARegion);
            dm.putOutgoing(msg);
        }

        public static void send(DM dm, InternalDistributedMember dest, int processorId, RegionVersionVector rvv, boolean isHARegion) {
            RegionStateMessage msg = new RegionStateMessage(dest, processorId, rvv, isHARegion);
            dm.putOutgoing(msg);
        }

        @Override
        public void toData(DataOutput dop) throws IOException {
            super.toData(dop);
            dop.writeBoolean(this.isHARegion);
            if (this.eventState != null) {
                dop.writeBoolean(true);
                EventStateHelper.toData(dop, this.eventState, this.isHARegion);
            } else {
                dop.writeBoolean(false);
            }
            if (this.versionVector != null) {
                dop.writeBoolean(true);
                dop.writeBoolean(this.versionVector instanceof DiskRegionVersionVector);
                InternalDataSerializer.invokeToData(this.versionVector, dop);
            } else {
                dop.writeBoolean(false);
            }
        }

        @Override
        public String toString() {
            String descr = super.toString();
            if (this.eventState != null) {
                descr = descr + "; eventCount=" + this.eventState.size();
            }
            if (this.versionVector != null) {
                descr = descr + "; versionVector=" + (RegionVersionVector.DEBUG ? this.versionVector.fullToString() : this.versionVector);
            }
            return descr;
        }

        @Override
        public void fromData(DataInput dip) throws IOException, ClassNotFoundException {
            super.fromData(dip);
            this.isHARegion = dip.readBoolean();
            boolean has = dip.readBoolean();
            if (has) {
                this.eventState = EventStateHelper.fromData(dip, this.isHARegion);
            }
            if (has = dip.readBoolean()) {
                boolean persistent = dip.readBoolean();
                this.versionVector = RegionVersionVector.create(persistent, dip);
            }
        }

        @Override
        public int getDSFID() {
            return 10;
        }
    }

    public static class InitialImageVersionedEntryList
    extends ArrayList<Entry>
    implements DataSerializableFixedID,
    Externalizable {
        List<VersionTag> versionTags;
        boolean isRegionVersioned = false;
        static final byte FLAG_NULL_TAG = 0;
        static final byte FLAG_FULL_TAG = 1;
        static final byte FLAG_TAG_WITH_NEW_ID = 2;
        static final byte FLAG_TAG_WITH_NUMBER_ID = 3;

        public InitialImageVersionedEntryList() {
            this.versionTags = new ArrayList<VersionTag>();
        }

        public InitialImageVersionedEntryList(boolean isRegionVersioned, int size) {
            super(size);
            this.isRegionVersioned = isRegionVersioned;
            this.versionTags = isRegionVersioned ? new ArrayList<VersionTag>(size) : Collections.EMPTY_LIST;
        }

        public static InitialImageVersionedEntryList create(DataInput in) throws IOException, ClassNotFoundException {
            InitialImageVersionedEntryList newList = new InitialImageVersionedEntryList();
            InternalDataSerializer.invokeFromData(newList, in);
            return newList;
        }

        @Override
        public boolean add(Entry entry) {
            VersionTag tag = entry.getVersionTag();
            entry.setVersionTag(null);
            return this.addEntryAndVersion(entry, tag);
        }

        private boolean addEntryAndVersion(Entry entry, VersionTag versionTag) {
            if (this.isRegionVersioned && versionTag != null) {
                int tagsSize = this.versionTags.size();
                if (tagsSize != super.size()) {
                    throw new InternalGemFireException();
                }
                this.versionTags.add(versionTag);
            }
            return super.add(entry);
        }

        @Override
        public Entry get(int index) {
            Entry entry = (Entry)super.get(index);
            VersionTag<VersionSource> tag = this.getVersionTag(index);
            entry.setVersionTag(tag);
            return entry;
        }

        private VersionTag<VersionSource> getVersionTag(int index) {
            VersionTag tag = null;
            if (this.isRegionVersioned && this.versionTags != null) {
                tag = this.versionTags.get(index);
            }
            return tag;
        }

        @Override
        public int size() {
            if (this.isRegionVersioned && super.size() != this.versionTags.size()) {
                throw new InternalGemFireException();
            }
            return super.size();
        }

        @Override
        public void clear() {
            super.clear();
            this.versionTags.clear();
        }

        public boolean isRegionVersioned() {
            return this.isRegionVersioned;
        }

        public void replaceNullIDs(DistributedMember sender) {
            for (VersionTag versionTag : this.versionTags) {
                if (versionTag == null) continue;
                versionTag.replaceNullIDs((InternalDistributedMember)sender);
            }
        }

        @Override
        public int getDSFID() {
            return 4;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            int flags = 0;
            boolean hasEntries = false;
            boolean hasTags = false;
            if (!super.isEmpty()) {
                flags |= 2;
                hasEntries = true;
            }
            if (this.versionTags.size() > 0) {
                flags |= 4;
                hasTags = true;
                for (VersionTag tag : this.versionTags) {
                    if (tag == null) continue;
                    if (!(tag instanceof DiskVersionTag)) break;
                    flags |= 0x20;
                    break;
                }
            }
            if (this.isRegionVersioned) {
                flags |= 8;
            }
            if (logger.isTraceEnabled(LogMarker.GII_VERSIONED_ENTRY)) {
                logger.trace(LogMarker.GII_VERSIONED_ENTRY, "serializing {} with flags 0x{}", new Object[]{this, Integer.toHexString(flags)});
            }
            out.writeByte(flags);
            if (hasEntries) {
                InternalDataSerializer.writeUnsignedVL(super.size(), out);
                for (int i = 0; i < super.size(); ++i) {
                    DataSerializer.writeObject(super.get(i), out);
                }
            }
            if (hasTags) {
                InternalDataSerializer.writeUnsignedVL(this.versionTags.size(), out);
                HashMap ids = new HashMap(this.versionTags.size());
                int idCount = 0;
                for (VersionTag tag : this.versionTags) {
                    if (tag == null) {
                        out.writeByte(0);
                        continue;
                    }
                    Object id = tag.getMemberID();
                    if (id == null) {
                        out.writeByte(1);
                        InternalDataSerializer.invokeToData(tag, out);
                        continue;
                    }
                    Integer idNumber = (Integer)ids.get(id);
                    if (idNumber == null) {
                        out.writeByte(2);
                        idNumber = idCount++;
                        ids.put(id, idNumber);
                        InternalDataSerializer.invokeToData(tag, out);
                        continue;
                    }
                    out.writeByte(3);
                    tag.toData(out, false);
                    tag.setMemberID(id);
                    InternalDataSerializer.writeUnsignedVL(idNumber.intValue(), out);
                }
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            int size;
            boolean persistent;
            boolean isGiiVersionEntryDebugEnabled = logger.isTraceEnabled(LogMarker.GII_VERSIONED_ENTRY);
            byte flags = in.readByte();
            boolean hasEntries = (flags & 2) == 2;
            boolean hasTags = (flags & 4) == 4;
            this.isRegionVersioned = (flags & 8) == 8;
            boolean bl = persistent = (flags & 0x20) == 32;
            if (isGiiVersionEntryDebugEnabled) {
                logger.trace(LogMarker.GII_VERSIONED_ENTRY, "deserializing a InitialImageVersionedObjectList with flags 0x{}", new Object[]{Integer.toHexString(flags)});
            }
            if (hasEntries) {
                size = (int)InternalDataSerializer.readUnsignedVL(in);
                if (isGiiVersionEntryDebugEnabled) {
                    logger.trace(LogMarker.GII_VERSIONED_ENTRY, "reading {} keys", new Object[]{size});
                }
                for (int i = 0; i < size; ++i) {
                    super.add((Entry)DataSerializer.readObject(in));
                }
            }
            if (hasTags) {
                size = (int)InternalDataSerializer.readUnsignedVL(in);
                if (isGiiVersionEntryDebugEnabled) {
                    logger.trace(LogMarker.GII_VERSIONED_ENTRY, "reading {} version tags", new Object[]{size});
                }
                this.versionTags = new ArrayList<VersionTag>(size);
                ArrayList ids = new ArrayList(size);
                block7: for (int i = 0; i < size; ++i) {
                    byte entryType = in.readByte();
                    switch (entryType) {
                        case 0: {
                            this.versionTags.add(null);
                            continue block7;
                        }
                        case 1: {
                            this.versionTags.add(VersionTag.create(persistent, in));
                            continue block7;
                        }
                        case 2: {
                            VersionTag tag = VersionTag.create(persistent, in);
                            ids.add(tag.getMemberID());
                            this.versionTags.add(tag);
                            continue block7;
                        }
                        case 3: {
                            VersionTag tag = VersionTag.create(persistent, in);
                            int idNumber = (int)InternalDataSerializer.readUnsignedVL(in);
                            tag.setMemberID((VersionSource)ids.get(idNumber));
                            this.versionTags.add(tag);
                        }
                    }
                }
            } else {
                this.versionTags = new ArrayList<VersionTag>();
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            this.toData(out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        @Override
        public Version[] getSerializationVersions() {
            return null;
        }
    }

    public static final class Entry
    implements DataSerializableFixedID {
        Object key;
        Object value = null;
        private byte entryBits = 0;
        private long lastModified;
        private VersionTag versionTag;
        static final byte HAS_VERSION = 1;
        static final byte PERSISTENT_VERSION = 2;

        void setLastModified(DM dm, long localMillis) {
            this.lastModified = localMillis;
        }

        public long getLastModified(DM dm) {
            return this.lastModified;
        }

        public boolean isSerialized() {
            return EntryBits.isSerialized(this.entryBits);
        }

        void setSerialized(boolean isSerialized) {
            this.entryBits = EntryBits.setSerialized(this.entryBits, isSerialized);
        }

        public boolean isEagerDeserialize() {
            return EntryBits.isEagerDeserialize(this.entryBits);
        }

        void setEagerDeserialize() {
            this.entryBits = EntryBits.setEagerDeserialize(this.entryBits);
        }

        void clearEagerDeserialize() {
            this.entryBits = EntryBits.clearEagerDeserialize(this.entryBits);
        }

        public boolean isInvalid() {
            return this.value == null && !EntryBits.isLocalInvalid(this.entryBits);
        }

        void setInvalid() {
            this.entryBits = EntryBits.setLocalInvalid(this.entryBits, false);
            this.value = null;
        }

        public boolean isLocalInvalid() {
            return EntryBits.isLocalInvalid(this.entryBits);
        }

        void setLocalInvalid() {
            this.entryBits = EntryBits.setLocalInvalid(this.entryBits, true);
            this.value = null;
        }

        void setTombstone() {
            this.entryBits = EntryBits.setTombstone(this.entryBits, true);
        }

        public VersionTag getVersionTag() {
            return this.versionTag;
        }

        public void setVersionTag(VersionTag tag) {
            this.versionTag = tag;
        }

        @Override
        public int getDSFID() {
            return 90;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            out.writeByte(this.entryBits);
            int flags = this.versionTag != null ? 1 : 0;
            flags = (byte)(flags | (this.versionTag instanceof DiskVersionTag ? 2 : 0));
            out.writeByte(flags);
            DataSerializer.writeObject(this.key, out);
            if (!EntryBits.isTombstone(this.entryBits)) {
                if (!this.isEagerDeserialize()) {
                    DataSerializer.writeObjectAsByteArray(this.value, out);
                } else {
                    DataSerializer.writeArrayOfByteArrays((byte[][])this.value, out);
                }
            }
            out.writeLong(this.lastModified);
            if (this.versionTag != null) {
                InternalDataSerializer.invokeToData(this.versionTag, out);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.entryBits = in.readByte();
            byte flags = in.readByte();
            this.key = DataSerializer.readObject(in);
            this.value = EntryBits.isTombstone(this.entryBits) ? Token.TOMBSTONE : (!this.isEagerDeserialize() ? (Object)DataSerializer.readByteArray(in) : (Object)DataSerializer.readArrayOfByteArrays(in));
            this.lastModified = in.readLong();
            if ((flags & 1) != 0) {
                this.versionTag = VersionTag.create((flags & 2) != 0, in);
            }
        }

        public int calcSerializedSize() {
            NullDataOutputStream dos = new NullDataOutputStream();
            try {
                this.toData(dos);
                return dos.size();
            }
            catch (IOException ex) {
                IllegalArgumentException ex2 = new IllegalArgumentException(LocalizedStrings.InitialImageOperation_COULD_NOT_CALCULATE_SIZE_OF_OBJECT.toLocalizedString());
                ex2.initCause(ex);
                throw ex2;
            }
        }

        public String toString() {
            return "GIIEntry[key=" + this.key + "]";
        }

        @Override
        public Version[] getSerializationVersions() {
            return null;
        }
    }

    public static final class ImageReplyMessage
    extends ReplyMessage {
        protected List entries;
        protected int numSeries;
        protected int seriesNum;
        protected int msgNum;
        protected boolean lastInSeries;
        private int flowControlId;
        private boolean isDeltaGII;
        private boolean hasHolderToSend;
        private RegionVersionHolder holderToSend;
        private Map<VersionSource, Long> gcVersions;
        private transient Version remoteVersion;
        private static final Version[] dsfidVersions = null;

        @Override
        public boolean getInlineProcess() {
            return false;
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplyException exception, DistributionManager dm, List entries, int seriesNum, int msgNum, int numSeries, boolean lastInSeries, int flowControlId, boolean isDeltaGII, RegionVersionHolder holderToSend, Map<VersionSource, Long> gcVersions) {
            ImageReplyMessage m = new ImageReplyMessage();
            m.processorId = processorId;
            if (exception != null) {
                m.setException(exception);
                if (logger.isDebugEnabled()) {
                    logger.debug("Replying with exception: {}", new Object[]{m, exception});
                }
            }
            m.setRecipient(recipient);
            m.entries = entries;
            m.seriesNum = seriesNum;
            m.msgNum = msgNum;
            m.numSeries = numSeries;
            m.lastInSeries = lastInSeries;
            m.flowControlId = flowControlId;
            m.isDeltaGII = isDeltaGII;
            m.holderToSend = holderToSend;
            m.hasHolderToSend = holderToSend != null;
            m.gcVersions = gcVersions;
            dm.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            try {
                super.process(dm, processor);
            }
            finally {
                if (this.flowControlId != 0) {
                    InitialImageFlowControl.FlowControlPermitMessage.send(dm, this.getSender(), this.flowControlId);
                }
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        @Override
        public int getDSFID() {
            return 89;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            int gcVersionsLength;
            super.fromData(in);
            ArrayList list = DataSerializer.readArrayList(in);
            Object listData = null;
            if (list != null && list.size() > 0) {
                listData = list.get(0);
            }
            this.entries = listData instanceof InitialImageVersionedEntryList ? (List)listData : list;
            this.seriesNum = in.readInt();
            this.msgNum = in.readInt();
            this.numSeries = in.readInt();
            this.lastInSeries = in.readBoolean();
            this.flowControlId = in.readInt();
            this.remoteVersion = InternalDataSerializer.getVersionForDataStreamOrNull(in);
            this.isDeltaGII = in.readBoolean();
            this.hasHolderToSend = in.readBoolean();
            if (this.hasHolderToSend) {
                this.holderToSend = new RegionVersionHolder(in);
            }
            if ((gcVersionsLength = in.readShort()) >= 0) {
                this.gcVersions = new HashMap<VersionSource, Long>(gcVersionsLength);
            }
            for (int i = 0; i < gcVersionsLength; ++i) {
                VersionSource key = (VersionSource)InternalDataSerializer.readObject(in);
                long value = InternalDataSerializer.readUnsignedVL(in);
                this.gcVersions.put(key, value);
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            if (this.entries instanceof InitialImageVersionedEntryList) {
                ArrayList<List> list = new ArrayList<List>(1);
                list.add(this.entries);
                DataSerializer.writeArrayList(list, out);
            } else {
                DataSerializer.writeArrayList((ArrayList)this.entries, out);
            }
            out.writeInt(this.seriesNum);
            out.writeInt(this.msgNum);
            out.writeInt(this.numSeries);
            out.writeBoolean(this.lastInSeries);
            out.writeInt(this.flowControlId);
            out.writeBoolean(this.isDeltaGII);
            out.writeBoolean(this.hasHolderToSend);
            if (this.hasHolderToSend) {
                InternalDataSerializer.invokeToData(this.holderToSend, out);
            }
            out.writeShort(this.gcVersions == null ? -1 : this.gcVersions.size());
            if (this.gcVersions != null) {
                for (Map.Entry<VersionSource, Long> entry : this.gcVersions.entrySet()) {
                    InternalDataSerializer.writeObject(entry.getKey(), out);
                    InternalDataSerializer.writeUnsignedVL(entry.getValue(), out);
                }
            }
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            String cname = this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1);
            buff.append(cname);
            buff.append("(processorId=");
            buff.append(this.processorId);
            buff.append(" from ");
            buff.append(this.getSender());
            ReplyException ex = this.getException();
            if (ex != null) {
                buff.append(" with exception ");
                buff.append(ex);
            }
            if (this.entries == null) {
                buff.append("; with no data - abort");
            } else {
                buff.append("; entryCount=");
                buff.append(this.entries.size());
                buff.append("; msgNum=");
                buff.append(this.msgNum);
                buff.append("; Series=");
                buff.append(this.seriesNum);
                buff.append("/");
                buff.append(this.numSeries);
                buff.append("; lastInSeries=");
                buff.append(this.lastInSeries);
                buff.append("; flowControlId=");
                buff.append(this.flowControlId);
                buff.append("; isDeltaGII=");
                buff.append(this.isDeltaGII);
            }
            if (this.remoteVersion != null) {
                buff.append("; remoteVersion=").append(this.remoteVersion);
            }
            if (this.holderToSend != null) {
                buff.append("; holderToSend=").append(this.holderToSend);
            }
            buff.append(")");
            return buff.toString();
        }

        @Override
        public Version[] getSerializationVersions() {
            return dsfidVersions;
        }

        static /* synthetic */ Version access$400(ImageReplyMessage x0) {
            return x0.remoteVersion;
        }

        static /* synthetic */ boolean access$500(ImageReplyMessage x0) {
            return x0.isDeltaGII;
        }

        static /* synthetic */ RegionVersionHolder access$600(ImageReplyMessage x0) {
            return x0.holderToSend;
        }

        static /* synthetic */ Map access$700(ImageReplyMessage x0) {
            return x0.gcVersions;
        }
    }

    public static final class RequestSyncMessage
    extends HighPriorityDistributionMessage {
        protected String regionPath;
        protected VersionSource[] lostVersionSources;

        @Override
        protected void process(DistributionManager dm) {
            Object lclRgn = null;
            try {
                Assert.assertTrue(this.regionPath != null, "Region path is null.");
                DistributedRegion rgn = (DistributedRegion)InitialImageOperation.getGIIRegion(dm, this.regionPath, false);
                if (rgn != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("synchronizing region with {}", new Object[]{Arrays.toString(this.lostVersionSources)});
                    }
                    for (VersionSource lostSource : this.lostVersionSources) {
                        InternalDistributedMember mbr = null;
                        if (lostSource instanceof InternalDistributedMember) {
                            mbr = (InternalDistributedMember)lostSource;
                        }
                        InitialImageOperation op = new InitialImageOperation(rgn, rgn.entries);
                        op.synchronizeWith(this.getSender(), lostSource, mbr);
                    }
                }
            }
            catch (RegionDestroyedException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}; Region destroyed, nothing to do.", new Object[]{this});
                }
            }
            catch (CancelException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}; Cache Closed, nothing to do.", new Object[]{this});
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
            }
        }

        @Override
        public int getDSFID() {
            return 1206;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.regionPath, out);
            out.writeBoolean(this.lostVersionSources[0] instanceof DiskStoreID);
            out.writeInt(this.lostVersionSources.length);
            for (VersionSource id : this.lostVersionSources) {
                id.writeEssentialData(out);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.regionPath = DataSerializer.readString(in);
            boolean persistentIDs = in.readBoolean();
            int len = in.readInt();
            this.lostVersionSources = new VersionSource[len];
            for (int i = 0; i < len; ++i) {
                this.lostVersionSources[i] = persistentIDs ? DiskStoreID.readEssentialData(in) : InternalDistributedMember.readEssentialData(in);
            }
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            String cname = this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1);
            buff.append(cname);
            buff.append("(region path='");
            buff.append(this.regionPath);
            buff.append("'; sender=");
            buff.append(this.getSender());
            buff.append("; sources=").append(Arrays.toString(this.lostVersionSources));
            buff.append(")");
            return buff.toString();
        }
    }

    public static final class RequestRVVMessage
    extends DistributionMessage
    implements MessageWithReply {
        protected String regionPath;
        protected int processorId;
        protected boolean targetReinitialized;

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        @Override
        public final int getProcessorType() {
            return this.targetReinitialized ? 77 : 75;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(DistributionManager dm) {
            Throwable thr = null;
            boolean sendFailureMessage = true;
            Object lclRgn = null;
            ReplyException rex = null;
            try {
                Assert.assertTrue(this.regionPath != null, "Region path is null.");
                DistributedRegion rgn = (DistributedRegion)InitialImageOperation.getGIIRegion(dm, this.regionPath, this.targetReinitialized);
                if (rgn == null) {
                    return;
                }
                if (!rgn.getGenerateVersionTag()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} non-persistent proxy region, nothing to do. Just reply", new Object[]{this});
                    }
                    RVVReplyMessage.send(dm, this.getSender(), this.processorId, null, null);
                    sendFailureMessage = false;
                    return;
                }
                RegionVersionVector rvv = rgn.getVersionVector().getCloneForTransmission();
                RVVReplyMessage.send(dm, this.getSender(), this.processorId, rvv, null);
                sendFailureMessage = false;
            }
            catch (RegionDestroyedException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}; Region destroyed: Request RVV aborting.", new Object[]{this});
                }
            }
            catch (CancelException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}; Cache Closed: Request RVV aborting.", new Object[]{this});
                }
            }
            catch (VirtualMachineError err) {
                sendFailureMessage = false;
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                thr = t;
            }
            finally {
                if (sendFailureMessage) {
                    if (thr != null) {
                        rex = new ReplyException(thr);
                    }
                    RVVReplyMessage.send(dm, this.getSender(), this.processorId, null, rex);
                }
            }
        }

        @Override
        public int getDSFID() {
            return 1078;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.regionPath = DataSerializer.readString(in);
            this.processorId = in.readInt();
            this.targetReinitialized = in.readBoolean();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.regionPath, out);
            out.writeInt(this.processorId);
            out.writeBoolean(this.targetReinitialized);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            String cname = this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1);
            buff.append(cname);
            buff.append("(region path='");
            buff.append(this.regionPath);
            buff.append("'; sender=");
            buff.append(this.getSender());
            buff.append("; processorId=");
            buff.append(this.processorId);
            buff.append("; targetReinitalized=");
            buff.append(this.targetReinitialized);
            buff.append(")");
            return buff.toString();
        }
    }

    public static class RVVReplyMessage
    extends ReplyMessage {
        RegionVersionVector versionVector;

        @Override
        public boolean getInlineProcess() {
            return false;
        }

        public RVVReplyMessage() {
        }

        private RVVReplyMessage(InternalDistributedMember mbr, int processorId, RegionVersionVector rvv) {
            this.setRecipient(mbr);
            this.setProcessorId(processorId);
            this.versionVector = rvv;
        }

        public static void send(DM dm, InternalDistributedMember dest, int processorId, RegionVersionVector rvv, ReplyException ex) {
            RVVReplyMessage msg = new RVVReplyMessage(dest, processorId, rvv);
            if (ex != null) {
                msg.setException(ex);
            }
            dm.putOutgoing(msg);
        }

        @Override
        public void toData(DataOutput dop) throws IOException {
            super.toData(dop);
            if (this.versionVector != null) {
                dop.writeBoolean(true);
                dop.writeBoolean(this.versionVector instanceof DiskRegionVersionVector);
                this.versionVector.toData(dop);
            } else {
                dop.writeBoolean(false);
            }
        }

        @Override
        public String toString() {
            String descr = super.toString();
            if (this.versionVector != null) {
                descr = descr + "; versionVector=" + (RegionVersionVector.DEBUG ? this.versionVector.fullToString() : this.versionVector);
            }
            return descr;
        }

        @Override
        public void fromData(DataInput dip) throws IOException, ClassNotFoundException {
            super.fromData(dip);
            boolean has = dip.readBoolean();
            if (has) {
                boolean persistent = dip.readBoolean();
                this.versionVector = RegionVersionVector.create(persistent, dip);
            }
        }

        @Override
        public int getDSFID() {
            return 1079;
        }
    }

    class RequestRVVProcessor
    extends ReplyProcessor21 {
        RegionVersionVector received_rvv;

        public RequestRVVProcessor(InternalDistributedSystem system, InternalDistributedMember member) {
            super(system, member);
        }

        public RequestRVVProcessor(InternalDistributedSystem system, Set members) {
            super(system, (Collection)members);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void process(DistributionMessage msg) {
            block12: {
                ReplyMessage reply;
                boolean isGiiDebugEnabled;
                block10: {
                    block11: {
                        block8: {
                            block9: {
                                isGiiDebugEnabled = logger.isTraceEnabled(LogMarker.GII);
                                reply = (ReplyMessage)msg;
                                try {
                                    if (reply != null) break block8;
                                    if (isGiiDebugEnabled) {
                                        logger.trace(LogMarker.GII, "Did not received RVVReply from {}. Remote member might be down.", new Object[]{Arrays.toString(this.getMembers())});
                                    }
                                    if (this.received_rvv != null || !isGiiDebugEnabled) break block9;
                                }
                                catch (Throwable throwable) {
                                    if (this.received_rvv == null && isGiiDebugEnabled) {
                                        logger.trace(LogMarker.GII, "{} did not send back rvv. Maybe it's non-persistent proxy region or remote region {} not found or not initialized. Nothing to do.", new Object[]{reply.getSender(), InitialImageOperation.this.region.getFullPath()});
                                    }
                                    super.process(msg);
                                    throw throwable;
                                }
                                logger.trace(LogMarker.GII, "{} did not send back rvv. Maybe it's non-persistent proxy region or remote region {} not found or not initialized. Nothing to do.", new Object[]{reply.getSender(), InitialImageOperation.this.region.getFullPath()});
                            }
                            super.process(msg);
                            return;
                        }
                        if (reply.getException() == null) break block10;
                        if (isGiiDebugEnabled) {
                            logger.trace(LogMarker.GII, "Failed to get RVV from {} due to {}", new Object[]{reply.getSender(), reply.getException()});
                        }
                        if (this.received_rvv != null || !isGiiDebugEnabled) break block11;
                        logger.trace(LogMarker.GII, "{} did not send back rvv. Maybe it's non-persistent proxy region or remote region {} not found or not initialized. Nothing to do.", new Object[]{reply.getSender(), InitialImageOperation.this.region.getFullPath()});
                    }
                    super.process(msg);
                    return;
                }
                if (reply instanceof RVVReplyMessage) {
                    RVVReplyMessage rvv_reply = (RVVReplyMessage)reply;
                    this.received_rvv = rvv_reply.versionVector;
                }
                if (this.received_rvv != null || !isGiiDebugEnabled) break block12;
                logger.trace(LogMarker.GII, "{} did not send back rvv. Maybe it's non-persistent proxy region or remote region {} not found or not initialized. Nothing to do.", new Object[]{reply.getSender(), InitialImageOperation.this.region.getFullPath()});
            }
            super.process(msg);
        }

        @Override
        public String toString() {
            String cname = this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1);
            StringBuffer sb = new StringBuffer();
            sb.append("<" + cname + " " + this.getProcessorId());
            sb.append(" ,from " + this.membersToString() + ">");
            return sb.toString();
        }

        @Override
        protected boolean logMultipleExceptions() {
            return false;
        }
    }

    public static final class RequestFilterInfoMessage
    extends DistributionMessage
    implements MessageWithReply {
        protected String regionPath;
        protected int processorId;

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        @Override
        public final int getProcessorType() {
            return 75;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(DistributionManager dm) {
            Throwable thr = null;
            boolean sendFailureMessage = true;
            LocalRegion lclRgn = null;
            ReplyException rex = null;
            try {
                Assert.assertTrue(this.regionPath != null, "Region path is null.");
                InternalDistributedSystem system = dm.getSystem();
                lclRgn = LocalRegion.getRegionFromPath(system, this.regionPath);
                if (lclRgn == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}; Failed to process filter info request. Region not found.", new Object[]{this});
                    }
                    return;
                }
                if (!lclRgn.isInitialized()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}; Failed to process filter info request. Region not yet initialized.", new Object[]{this});
                    }
                    return;
                }
                DistributedRegion rgn = (DistributedRegion)lclRgn;
                FilterInfoMessage.send(dm, this.getSender(), this.processorId, rgn, null);
                sendFailureMessage = false;
            }
            catch (CancelException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}; Cache Closed: aborting filter info request.", new Object[]{this});
                }
                rex = new ReplyException("Cache Closed: filter info request aborted.");
            }
            catch (VirtualMachineError err) {
                sendFailureMessage = false;
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                thr = t;
            }
            finally {
                if (sendFailureMessage) {
                    if (thr != null) {
                        rex = new ReplyException(thr);
                    }
                    if (rex == null) {
                        rex = new ReplyException("Failed to process filter info request.");
                    }
                    FilterInfoMessage.send(dm, this.getSender(), this.processorId, lclRgn, rex);
                }
            }
        }

        @Override
        public int getDSFID() {
            return 1077;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.regionPath = DataSerializer.readString(in);
            this.processorId = in.readInt();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.regionPath, out);
            out.writeInt(this.processorId);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            String cname = this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1);
            buff.append(cname);
            buff.append("(region path='");
            buff.append(this.regionPath);
            buff.append("'; sender=");
            buff.append(this.getSender());
            buff.append("; processorId=");
            buff.append(this.processorId);
            buff.append(")");
            return buff.toString();
        }
    }

    class FilterInfoProcessor
    extends ReplyProcessor21 {
        boolean filtersReceived;

        public FilterInfoProcessor(InternalDistributedSystem system, InternalDistributedMember member) {
            super(system, member);
        }

        public FilterInfoProcessor(InternalDistributedSystem system, Set members) {
            super(system, (Collection)members);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            if (!this.waitingOnMember(msg.getSender())) {
                return;
            }
            try {
                if (!(msg instanceof FilterInfoMessage)) {
                    return;
                }
                FilterInfoMessage m = (FilterInfoMessage)msg;
                if (m.getException() != null) {
                    return;
                }
                if (logger.isDebugEnabled()) {
                    try {
                        CacheClientNotifier ccn = CacheClientNotifier.getInstance();
                        if (ccn != null && ccn.getHaContainer() != null) {
                            CacheClientProxy proxy = ((HAContainerWrapper)ccn.getHaContainer()).getProxy(InitialImageOperation.this.region.getName());
                            logger.debug("Processing FilterInfo for proxy: {} : {}", new Object[]{proxy, msg});
                        }
                    }
                    catch (Exception ccn) {
                        // empty catch block
                    }
                }
                try {
                    m.registerFilters(InitialImageOperation.this.region);
                }
                catch (Exception ex) {
                    logger.info("Exception while registering filters during GII: {}", new Object[]{ex.getMessage(), ex});
                }
                this.filtersReceived = true;
            }
            finally {
                super.process(msg);
            }
        }

        @Override
        public String toString() {
            String cname = this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1);
            return "<" + cname + " " + this.getProcessorId() + " replies" + (this.exception == null ? "" : " exception: " + this.exception) + " from " + this.membersToString() + ">";
        }

        @Override
        protected boolean logMultipleExceptions() {
            return false;
        }
    }

    public static final class RequestImageMessage
    extends DistributionMessage
    implements MessageWithReply {
        public RegionVersionVector versionVector;
        public VersionSource lostMemberVersionID;
        public InternalDistributedMember lostMemberID;
        public String regionPath;
        protected int processorId;
        protected boolean keysOnly;
        protected boolean checkTombstoneVersions;
        protected boolean targetReinitialized;
        protected transient boolean severeAlertEnabled;
        protected Set unfinishedKeys;
        private static final Version[] dsfidVersions = null;

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        @Override
        public final int getProcessorType() {
            return this.targetReinitialized ? 77 : 75;
        }

        public boolean goWithFullGII(DistributedRegion rgn, RegionVersionVector requesterRVV) {
            if (this.getSender().getVersionObject().compareTo(Version.GFE_80) < 0) {
                return true;
            }
            if (!rgn.getDataPolicy().withPersistence()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Region {} is not a persistent region, do full GII", new Object[]{rgn.getFullPath()});
                }
                return true;
            }
            if (!rgn.getVersionVector().isRVVGCDominatedBy(requesterRVV)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Region {}'s local RVVGC is not dominated by remote RVV={}, do full GII", new Object[]{rgn.getFullPath(), requesterRVV});
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(final DistributionManager dm) {
            boolean isGiiDebugEnabled = logger.isTraceEnabled(LogMarker.GII);
            Throwable thr = null;
            final boolean lclAbortTest = abortTest;
            if (lclAbortTest) {
                abortTest = false;
            }
            boolean sendFailureMessage = true;
            try {
                Assert.assertTrue(this.regionPath != null, "Region path is null.");
                final DistributedRegion rgn = (DistributedRegion)InitialImageOperation.getGIIRegion(dm, this.regionPath, this.targetReinitialized);
                if (rgn == null) {
                    return;
                }
                if (internalAfterReceivedRequestImage != null && internalAfterReceivedRequestImage.getRegionName().equals(rgn.getName())) {
                    internalAfterReceivedRequestImage.run();
                }
                if (this.versionVector != null) {
                    if (this.versionVector.isForSynchronization() && !rgn.getConcurrencyChecksEnabled()) {
                        if (isGiiDebugEnabled) {
                            logger.trace(LogMarker.GII, "ignoring synchronization request as this region has no version vector");
                        }
                        this.replyNoData(dm, true, Collections.EMPTY_MAP);
                        sendFailureMessage = false;
                        return;
                    }
                    if (isGiiDebugEnabled) {
                        logger.debug("checking version vector against region's ({})", new Object[]{rgn.getVersionVector().fullToString()});
                    }
                    if (!rgn.getVersionVector().isNewerThanOrCanFillExceptionsFor(this.versionVector)) {
                        if (this.unfinishedKeys == null || this.unfinishedKeys.isEmpty()) {
                            if (isGiiDebugEnabled) {
                                logger.trace(LogMarker.GII, "version vector reports that I have nothing that the requester hasn't already seen");
                            }
                            this.replyNoData(dm, true, rgn.getVersionVector().getMemberToGCVersion());
                            sendFailureMessage = false;
                            return;
                        }
                    } else if (isGiiDebugEnabled) {
                        logger.trace(LogMarker.GII, "version vector reports that I have updates the requester hasn't seen, remote rvv is {}", new Object[]{this.versionVector});
                    }
                }
                boolean numSeries = true;
                boolean seriesNum = false;
                if (isGiiDebugEnabled) {
                    logger.trace(LogMarker.GII, "RequestImageMessage: Starting chunkEntries for {}", new Object[]{rgn.getFullPath()});
                }
                final InitialImageFlowControl flowControl = InitialImageFlowControl.register(dm, this.getSender());
                if (rgn instanceof HARegion) {
                    ((HARegion)rgn).startServingGIIRequest();
                }
                boolean markedOngoingGII = false;
                try {
                    Object rvv;
                    Object holderToSync;
                    boolean recoveringForLostMember;
                    block63: {
                        recoveringForLostMember = this.lostMemberVersionID != null;
                        holderToSync = null;
                        if (recoveringForLostMember && this.lostMemberID != null) {
                            try {
                                RegionVersionHolder<VersionSource> holderOfRequest;
                                dm.getMembershipManager().waitForDeparture(this.lostMemberID);
                                RegionVersionHolder<VersionSource> rvh = rgn.getVersionVector().getHolderForMember(this.lostMemberVersionID);
                                if (rvh != null) {
                                    holderToSync = rvh.clone();
                                }
                                if (isGiiDebugEnabled && ((RegionVersionHolder)holderToSync).isNewerThanOrCanFillExceptionsFor(holderOfRequest = this.versionVector.getHolderForMember(this.lostMemberVersionID))) {
                                    logger.trace(LogMarker.GII, "synchronizeWith detected mismatch region version holder for lost member {}. Old is {}, new is {}", new Object[]{this.lostMemberVersionID, holderOfRequest, holderToSync});
                                }
                            }
                            catch (java.util.concurrent.TimeoutException e) {
                                if (!isGiiDebugEnabled) break block63;
                                logger.trace(LogMarker.GII, "timed out waiting for the departure of {} before processing delta GII request", new Object[]{this.lostMemberID});
                            }
                        }
                    }
                    if (rgn instanceof HARegion) {
                        Map<? extends DataSerializable, ? extends DataSerializable> eventState = rgn.getEventState();
                        if (eventState != null && eventState.size() > 0) {
                            RegionStateMessage.send((DM)dm, this.getSender(), this.processorId, eventState, true);
                        }
                    } else if (this.getSender().getVersionObject().compareTo(Version.GFE_80) < 0 && rgn.concurrencyChecksEnabled && this.versionVector == null && !recoveringForLostMember) {
                        rvv = rgn.getVersionVector().getCloneForTransmission();
                        RegionStateMessage.send((DM)dm, this.getSender(), this.processorId, (RegionVersionVector)rvv, false);
                    }
                    if (this.checkTombstoneVersions && this.versionVector != null && rgn.concurrencyChecksEnabled) {
                        rvv = rgn.getCache().getTombstoneService().blockGCLock;
                        synchronized (rvv) {
                            if (this.goWithFullGII(rgn, this.versionVector)) {
                                if (isGiiDebugEnabled) {
                                    logger.trace(LogMarker.GII, "have to do fullGII");
                                }
                                this.versionVector = null;
                            } else {
                                int count = rgn.getCache().getTombstoneService().incrementGCBlockCount();
                                markedOngoingGII = true;
                                if (isGiiDebugEnabled) {
                                    logger.trace(LogMarker.GII, "There're {} Delta GII on going", new Object[]{count});
                                }
                            }
                        }
                    }
                    Object holderToSend = holderToSync;
                    boolean finished = this.chunkEntries(rgn, CHUNK_SIZE_IN_BYTES, !this.keysOnly, this.versionVector, (HashSet)this.unfinishedKeys, flowControl, new ObjectIntProcedure((RegionVersionHolder)holderToSend){
                        int msgNum = 0;
                        boolean last = false;
                        final /* synthetic */ RegionVersionHolder val$holderToSend;
                        {
                            this.val$holderToSend = regionVersionHolder;
                        }

                        @Override
                        public boolean executeWith(Object entList, int b) {
                            if (rgn.getCache().isClosed()) {
                                return false;
                            }
                            if (this.last) {
                                throw new InternalGemFireError(LocalizedStrings.InitialImageOperation_ALREADY_PROCESSED_LAST_CHUNK.toLocalizedString());
                            }
                            List entries = (List)entList;
                            this.last = b > 0 && !lclAbortTest;
                            try {
                                boolean abort = rgn.isDestroyed();
                                if (!abort) {
                                    int fid = flowControl.getId();
                                    Map<VersionSource, Long> gcVersions = null;
                                    if (this.last && rgn.getVersionVector() != null) {
                                        gcVersions = rgn.getVersionVector().getMemberToGCVersion();
                                    }
                                    this.replyWithData(dm, entries, 0, this.msgNum++, 1, this.last, fid, versionVector != null, this.val$holderToSend, gcVersions);
                                }
                                return !abort;
                            }
                            catch (CancelException e) {
                                return false;
                            }
                        }
                    });
                    if (isGiiDebugEnabled) {
                        logger.trace(LogMarker.GII, "RequestImageMessage: ended chunkEntries for {}; finished = {}", new Object[]{rgn.getFullPath(), finished});
                    }
                    if (finished && !lclAbortTest) {
                        sendFailureMessage = false;
                        return;
                    }
                    rgn.checkReadiness();
                }
                finally {
                    if (markedOngoingGII) {
                        int count = rgn.getCache().getTombstoneService().decrementGCBlockCount();
                        assert (count >= 0);
                        if (count == 0) {
                            markedOngoingGII = false;
                            if (isGiiDebugEnabled) {
                                logger.trace(LogMarker.GII, "Delta GII count is reset");
                            }
                        }
                    }
                    if (rgn instanceof HARegion) {
                        ((HARegion)rgn).endServingGIIRequest();
                    }
                    flowControl.unregister();
                }
                Assert.assertTrue(lclAbortTest, this + ": Did not finish sending image, but region, cache, and DS are alive.");
                this.initiateLocalAbortForTest(dm);
            }
            catch (RegionDestroyedException e) {
                if (isGiiDebugEnabled) {
                    logger.trace(LogMarker.GII, "{}; Region destroyed: aborting image provision", new Object[]{this});
                }
            }
            catch (IllegalStateException e) {
                logger.trace(LogMarker.GII, "{}; disk region deleted? aborting image provision", new Object[]{this, e});
            }
            catch (CancelException e) {
                if (isGiiDebugEnabled) {
                    logger.trace(LogMarker.GII, "{}; Cache Closed: aborting image provision", new Object[]{this});
                }
            }
            catch (VirtualMachineError err) {
                sendFailureMessage = false;
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                thr = t;
            }
            finally {
                if (sendFailureMessage) {
                    ReplyException rex = null;
                    if (thr != null) {
                        rex = new ReplyException(thr);
                    }
                    ImageReplyMessage.send(this.getSender(), this.processorId, rex, dm, null, 0, 0, 1, true, 0, false, null, null);
                }
                if (internalAfterSentImageReply != null && this.regionPath.endsWith(internalAfterSentImageReply.getRegionName())) {
                    internalAfterSentImageReply.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean chunkEntries(DistributedRegion rgn, int chunkSizeInBytes, boolean includeValues, RegionVersionVector versionVector, HashSet unfinishedKeys, InitialImageFlowControl flowControl, ObjectIntProcedure proc) throws IOException {
            boolean keepGoing = true;
            boolean sentLastChunk = false;
            int MAX_ENTRIES_PER_CHUNK = chunkSizeInBytes / 100;
            if (MAX_ENTRIES_PER_CHUNK < 1000) {
                MAX_ENTRIES_PER_CHUNK = 1000;
            }
            ByteArrayDataInput in = null;
            DistributionManager dm = (DistributionManager)rgn.getDistributionManager();
            InitialImageVersionedEntryList chunkEntries = null;
            chunkEntries = new InitialImageVersionedEntryList(rgn.concurrencyChecksEnabled, MAX_ENTRIES_PER_CHUNK);
            boolean keyRequiresRegionContext = rgn.keyRequiresRegionContext();
            DiskRegion dr = rgn.getDiskRegion();
            if (dr != null) {
                dr.setClearCountReference();
                in = new ByteArrayDataInput();
            }
            VersionSource myId = rgn.getVersionMember();
            HashSet foundIds = new HashSet();
            if (internalDuringPackingImage != null && this.regionPath.endsWith(internalDuringPackingImage.getRegionName())) {
                internalDuringPackingImage.run();
            }
            try {
                RegionVersionVector vv;
                Iterator<RegionEntry> it = null;
                it = versionVector != null ? rgn.entries.regionEntries().iterator() : rgn.getBestIterator(includeValues);
                do {
                    flowControl.acquirePermit();
                    int currentChunkSize = 0;
                    while (chunkEntries.size() < MAX_ENTRIES_PER_CHUNK && currentChunkSize < chunkSizeInBytes && it.hasNext()) {
                        Object v;
                        RegionEntry mapEntry = it.next();
                        Object key = mapEntry.getKey();
                        if (rgn.checkEntryNotValid(mapEntry)) continue;
                        if (logger.isDebugEnabled() && (v = mapEntry.getValueInVM(rgn)) instanceof Conflatable && ((Conflatable)v).getEventId() == null) {
                            logger.debug("bug 44959: chunkEntries found conflatable with no eventID: {}", new Object[]{v});
                        }
                        Entry entry = null;
                        if (includeValues) {
                            boolean fillRes;
                            block26: {
                                fillRes = false;
                                try {
                                    VersionStamp stamp = mapEntry.getVersionStamp();
                                    if (stamp != null) {
                                        RegionEntry regionEntry = mapEntry;
                                        synchronized (regionEntry) {
                                            Object id = stamp.getMemberID();
                                            if (id == null) {
                                                id = myId;
                                            }
                                            foundIds.add(id);
                                            if ((unfinishedKeys == null || !unfinishedKeys.contains(key)) && versionVector != null && versionVector.contains(id, stamp.getRegionVersion())) {
                                                continue;
                                            }
                                            entry = new Entry();
                                            entry.key = key;
                                            entry.setVersionTag(stamp.asVersionTag());
                                            if (keyRequiresRegionContext) {
                                                entry.setEagerDeserialize();
                                            }
                                            fillRes = mapEntry.fillInValue(rgn, entry, in, rgn.getDistributionManager());
                                            if (versionVector != null && logger.isTraceEnabled(LogMarker.GII)) {
                                                logger.trace(LogMarker.GII, "chunkEntries:entry={},stamp={}", new Object[]{entry, stamp});
                                            }
                                            break block26;
                                        }
                                    }
                                    entry = new Entry();
                                    entry.key = key;
                                    if (keyRequiresRegionContext) {
                                        entry.setEagerDeserialize();
                                    }
                                    fillRes = mapEntry.fillInValue(rgn, entry, in, rgn.getDistributionManager());
                                }
                                catch (DiskAccessException dae) {
                                    rgn.handleDiskAccessException(dae);
                                    throw dae;
                                }
                            }
                            if (!fillRes) {
                                continue;
                            }
                        } else {
                            entry = new Entry();
                            entry.key = key;
                            entry.setLocalInvalid();
                            entry.setLastModified(rgn.getDistributionManager(), mapEntry.getLastModified());
                        }
                        if (keyRequiresRegionContext) {
                            entry.key = ((KeyWithRegionContext)key).beforeSerializationWithValue(entry.isInvalid() || entry.isLocalInvalid());
                        }
                        chunkEntries.add(entry);
                        currentChunkSize += entry.calcSerializedSize();
                    }
                    int lastMsg = it.hasNext() ? 0 : 1;
                    keepGoing = proc.executeWith(chunkEntries, lastMsg);
                    sentLastChunk = lastMsg == 1 && keepGoing;
                    chunkEntries.clear();
                } while (keepGoing && it.hasNext());
                if (foundIds.size() > 0 && (vv = rgn.getVersionVector()) != null) {
                    vv.removeOldMembers(foundIds);
                }
                boolean bl = sentLastChunk;
                return bl;
            }
            finally {
                if (dr != null) {
                    dr.removeClearCountReference();
                }
            }
        }

        private void replyNoData(DistributionManager dm, boolean isDeltaGII, Map<VersionSource, Long> gcVersions) {
            ImageReplyMessage.send(this.getSender(), this.processorId, null, dm, null, 0, 0, 1, true, 0, isDeltaGII, null, gcVersions);
        }

        protected void replyWithData(DistributionManager dm, List entries, int seriesNum, int msgNum, int numSeries, boolean lastInSeries, int flowControlId, boolean isDeltaGII, RegionVersionHolder holderToSend, Map<VersionSource, Long> gcVersions) {
            ImageReplyMessage.send(this.getSender(), this.processorId, null, dm, entries, seriesNum, msgNum, numSeries, lastInSeries, flowControlId, isDeltaGII, holderToSend, gcVersions);
        }

        private void initiateLocalAbortForTest(final DM dm) {
            if (!dm.getSystem().isDisconnecting()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("abortTest: Disconnecting from distributed system and sending null chunk to abort");
                }
                LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("InitialImageOperation abortTest Threads", logger);
                Thread disconnectThread = new Thread(group, "InitialImageOperation abortTest Thread"){

                    @Override
                    public void run() {
                        dm.getSystem().disconnect();
                    }
                };
                disconnectThread.setDaemon(true);
                disconnectThread.start();
            }
        }

        @Override
        public int getDSFID() {
            return 88;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.regionPath = DataSerializer.readString(in);
            this.processorId = in.readInt();
            this.keysOnly = in.readBoolean();
            this.targetReinitialized = in.readBoolean();
            this.checkTombstoneVersions = in.readBoolean();
            this.lostMemberVersionID = (VersionSource)DataSerializer.readObject(in);
            this.versionVector = (RegionVersionVector)DataSerializer.readObject(in);
            this.lostMemberID = (InternalDistributedMember)DataSerializer.readObject(in);
            this.unfinishedKeys = (Set)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.regionPath, out);
            out.writeInt(this.processorId);
            out.writeBoolean(this.keysOnly);
            out.writeBoolean(this.targetReinitialized);
            out.writeBoolean(this.checkTombstoneVersions);
            DataSerializer.writeObject(this.lostMemberVersionID, out);
            DataSerializer.writeObject(this.versionVector, out);
            DataSerializer.writeObject(this.lostMemberID, out);
            DataSerializer.writeObject(this.unfinishedKeys, out);
        }

        @Override
        public Version[] getSerializationVersions() {
            return dsfidVersions;
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            String cname = this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1);
            buff.append(cname);
            buff.append("(region path='");
            buff.append(this.regionPath);
            buff.append("'; sender=");
            buff.append(this.getSender());
            buff.append("; keysOnly=");
            buff.append(this.keysOnly);
            buff.append("; processorId=");
            buff.append(this.processorId);
            buff.append("; waitForInit=");
            buff.append(this.targetReinitialized);
            buff.append("; checkTombstoneVersions=");
            buff.append(this.checkTombstoneVersions);
            if (this.lostMemberVersionID != null) {
                buff.append("; lostMember=").append(this.lostMemberVersionID);
            }
            buff.append("; versionVector=").append(this.versionVector);
            buff.append("; unfinished keys=").append(this.unfinishedKeys);
            buff.append(")");
            return buff.toString();
        }

        @Override
        public boolean isSevereAlertCompatible() {
            return this.severeAlertEnabled;
        }
    }

    class ImageProcessor
    extends ReplyProcessor21 {
        private volatile boolean abort;
        private volatile boolean recievedChunk;
        private final Map statusMap;
        private final AtomicInteger msgsBeingProcessed;
        private volatile boolean finishedWaiting;

        @Override
        public boolean isSevereAlertProcessingEnabled() {
            return ImageProcessor.isSevereAlertProcessingForced();
        }

        void processRegionStateMessage(RegionStateMessage msg) {
            if (msg.eventState != null) {
                logger.debug("Applying event state to region {} from {}", new Object[]{InitialImageOperation.this.region.getName(), msg.getSender()});
                InitialImageOperation.this.region.recordEventState(msg.getSender(), msg.eventState);
            }
            if (msg.versionVector != null && msg.getSender().getVersionObject().compareTo(Version.GFE_80) < 0 && InitialImageOperation.this.region.getConcurrencyChecksEnabled()) {
                logger.debug("Applying version vector to {}: {}", new Object[]{InitialImageOperation.this.region.getName(), msg.versionVector});
                if (internalBeforeSavedReceivedRVV != null && internalBeforeSavedReceivedRVV.getRegionName().equals(InitialImageOperation.this.region.getName())) {
                    internalBeforeSavedReceivedRVV.run();
                }
                InitialImageOperation.this.saveReceivedRVV(msg.versionVector);
                if (internalAfterSavedReceivedRVV != null && internalAfterSavedReceivedRVV.getRegionName().equals(InitialImageOperation.this.region.getName())) {
                    internalAfterSavedReceivedRVV.run();
                }
            }
        }

        public ImageProcessor(InternalDistributedSystem system, InternalDistributedMember member) {
            super(system, member);
            this.abort = false;
            this.recievedChunk = false;
            this.statusMap = new HashMap();
            this.msgsBeingProcessed = new AtomicInteger();
            this.finishedWaiting = false;
        }

        public ImageProcessor(InternalDistributedSystem system, Set members) {
            super(system, (Collection)members);
            this.abort = false;
            this.recievedChunk = false;
            this.statusMap = new HashMap();
            this.msgsBeingProcessed = new AtomicInteger();
            this.finishedWaiting = false;
        }

        @Override
        protected boolean processTimeout() {
            boolean ret = this.recievedChunk;
            this.recievedChunk = false;
            return !ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void process(DistributionMessage msg) {
            if (!this.waitingOnMember(msg.getSender())) {
                return;
            }
            status = this.getStatus(msg.getSender());
            this.msgsBeingProcessed.incrementAndGet();
            EntryLogger.setSource(msg.getSender(), "gii");
            try {
                if (msg instanceof RegionStateMessage) {
                    isDone = false;
                    status.eventStateReceived = true;
                    this.processRegionStateMessage((RegionStateMessage)msg);
                } else {
                    isDone = true;
                    m = (ImageReplyMessage)msg;
                    isLast = true;
                    if (m.entries != null) {
                        try {
                            if (InitialImageOperation.access$300() != null && InitialImageOperation.access$300().getRegionName().equals(InitialImageOperation.this.region.getName())) {
                                InitialImageOperation.access$300().run();
                            }
                            if (!(isAborted = this.abort)) {
                                v0 = isAborted = InitialImageOperation.this.processChunk(m.entries, m.getSender(), ImageReplyMessage.access$400(m)) == false;
                                if (isAborted) {
                                    this.abort = true;
                                } else {
                                    this.recievedChunk = true;
                                }
                            }
                            isLast = this.trackMessage(m);
                            v1 = isDone = isAborted != false || isLast != false;
                            if (!isDone) ** GOTO lbl54
                            if (this.abort) {
                                InitialImageOperation.this.gotImage = false;
                                InitialImageOperation.access$000().debug("processChunk is aborted for region {}, rvv is {}. Do full gii next time.", new Object[]{InitialImageOperation.this.region.getFullPath(), InitialImageOperation.this.region.getVersionVector()});
                            } else {
                                InitialImageOperation.this.gotImage = true;
                            }
                            if (!ImageReplyMessage.access$500(m)) ** GOTO lbl54
                            InitialImageOperation.this.isDeltaGII = true;
                        }
                        catch (DiskAccessException dae) {
                            ex = new ReplyException("while processing entries", dae);
                            ex.setSenderIfNull(InitialImageOperation.this.region.getCache().getMyId());
                            this.processException(ex);
                        }
                        catch (VirtualMachineError err) {
                            SystemFailure.initiateFailure(err);
                            throw err;
                        }
                        catch (Throwable t) {
                            SystemFailure.checkFailure();
                            ex = new ReplyException("while processing entries", t);
                            ex.setSenderIfNull(InitialImageOperation.this.region.getCache().getMyId());
                            this.processException(ex);
                        }
                    } else if (isDone && ImageReplyMessage.access$500(m)) {
                        InitialImageOperation.this.gotImage = true;
                        InitialImageOperation.this.isDeltaGII = true;
                    }
lbl54:
                    // 8 sources

                    if (ImageReplyMessage.access$600(m) != null) {
                        InitialImageOperation.this.rcvd_holderToSync = ImageReplyMessage.access$600(m);
                    }
                    if (ImageReplyMessage.access$700(m) != null) {
                        InitialImageOperation.this.gcVersions = ImageReplyMessage.access$700(m);
                    }
                }
                if (isDone) {
                    super.process(msg, false);
                }
            }
            catch (RegionDestroyedException e) {
                InitialImageOperation.this.region.getCancelCriterion().checkCancelInProgress(e);
            }
            finally {
                this.msgsBeingProcessed.decrementAndGet();
                this.checkIfDone();
                EntryLogger.clearSource();
            }
        }

        @Override
        protected boolean stillWaiting() {
            if (this.finishedWaiting) {
                return false;
            }
            if (this.msgsBeingProcessed.get() > 0) {
                return true;
            }
            if (this.abort || !super.stillWaiting()) {
                this.finishedWaiting = true;
                return false;
            }
            return true;
        }

        @Override
        public String toString() {
            String msgsBeingProcessedStr = this.msgsBeingProcessed == null ? "nullRef" : String.valueOf(this.msgsBeingProcessed.get());
            String regionStr = InitialImageOperation.this.region == null ? "nullRef" : InitialImageOperation.this.region.getFullPath();
            String numMembersStr = this.members == null ? "nullRef" : String.valueOf(this.numMembers());
            return "<" + this.getClass().getName() + " " + this.getProcessorId() + " waiting for " + numMembersStr + " replies" + (this.exception == null ? "" : " exception: " + this.exception) + " from " + this.membersToString() + "; waiting for " + msgsBeingProcessedStr + " messages in-flight; " + "region=" + regionStr + "; abort=" + this.abort + ">";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Status getStatus(InternalDistributedMember sender) {
            Status status;
            ImageProcessor imageProcessor = this;
            synchronized (imageProcessor) {
                status = (Status)this.statusMap.get(sender);
                if (status == null) {
                    status = new Status();
                    this.statusMap.put(sender, status);
                }
            }
            return status;
        }

        private boolean trackMessage(ImageReplyMessage m) {
            return this.getStatus(m.getSender()).trackMessage(m);
        }

        class Status {
            int[] msgsProcessed = null;
            int[] numInSeries = null;
            boolean eventStateReceived;
            boolean allChunksReceived;

            Status() {
            }

            protected synchronized boolean trackMessage(ImageReplyMessage m) {
                if (this.msgsProcessed == null) {
                    this.msgsProcessed = new int[m.numSeries];
                }
                if (this.numInSeries == null) {
                    this.numInSeries = new int[m.numSeries];
                }
                int n = m.seriesNum;
                this.msgsProcessed[n] = this.msgsProcessed[n] + 1;
                if (m.lastInSeries) {
                    this.numInSeries[m.seriesNum] = m.msgNum + 1;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("InitialImage Message Tracking Status: Processor id: {}; Sender: {}; Messages Processed: {}; NumInSeries:{}", new Object[]{ImageProcessor.this.getProcessorId(), m.getSender(), InitialImageOperation.arrayToString(this.msgsProcessed), InitialImageOperation.arrayToString(this.numInSeries)});
                }
                this.allChunksReceived = Arrays.equals(this.msgsProcessed, this.numInSeries);
                return this.allChunksReceived;
            }
        }
    }

    public static enum GIIStatus {
        NO_GII,
        GOTIMAGE_BY_FULLGII,
        GOTIMAGE_BY_DELTAGII;


        public static boolean didGII(GIIStatus giiStatus) {
            return giiStatus == GOTIMAGE_BY_FULLGII || giiStatus == GOTIMAGE_BY_DELTAGII;
        }

        public static boolean didDeltaGII(GIIStatus giiStatus) {
            return giiStatus == GOTIMAGE_BY_DELTAGII;
        }

        public static boolean didFullGII(GIIStatus giiStatus) {
            return giiStatus == GOTIMAGE_BY_FULLGII;
        }
    }
}

