/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.AbstractLRURegionMap;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.HDFSRegionMap;
import com.gemstone.gemfire.internal.cache.HDFSRegionMapDelegate;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionMap;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.cache.lru.NewLRUClockHand;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.Collection;
import org.apache.logging.log4j.Logger;

public class HDFSLRURegionMap
extends AbstractLRURegionMap
implements HDFSRegionMap {
    private static final Logger logger = LogService.getLogger();
    private final HDFSRegionMapDelegate delegate;
    private EnableLRU ccHelper;
    private NewLRUClockHand lruList;
    private static final boolean DEBUG = Boolean.getBoolean("hdfsRegionMap.DEBUG");

    public HDFSLRURegionMap(LocalRegion owner, RegionMap.Attributes attrs, InternalRegionArguments internalRegionArgs) {
        super(internalRegionArgs);
        assert (owner instanceof BucketRegion);
        this.initialize(owner, attrs, internalRegionArgs);
        this.delegate = new HDFSRegionMapDelegate(owner, attrs, internalRegionArgs, this);
    }

    @Override
    public RegionEntry getEntry(Object key) {
        return this.delegate.getEntry(key, null);
    }

    @Override
    protected RegionEntry getEntry(EntryEventImpl event) {
        return this.delegate.getEntry(event);
    }

    @Override
    public Collection<RegionEntry> regionEntries() {
        return this.delegate.regionEntries();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    protected void _setCCHelper(EnableLRU ccHelper) {
        this.ccHelper = ccHelper;
    }

    @Override
    protected EnableLRU _getCCHelper() {
        return this.ccHelper;
    }

    @Override
    protected void _setLruList(NewLRUClockHand lruList) {
        this.lruList = lruList;
    }

    @Override
    protected NewLRUClockHand _getLruList() {
        return this.lruList;
    }

    @Override
    public HDFSRegionMapDelegate getDelegate() {
        return this.delegate;
    }
}

