/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.internal.cache.FixedPartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.PartitionRegionConfig;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;

class FixedPartitionAttributesListener
extends CacheListenerAdapter {
    private static final Logger logger = LogService.getLogger();

    FixedPartitionAttributesListener() {
    }

    @Override
    public void afterCreate(EntryEvent event) {
        PartitionRegionConfig prConfig = (PartitionRegionConfig)event.getNewValue();
        if (!prConfig.getElderFPAs().isEmpty()) {
            this.updatePartitionMap(prConfig);
        }
    }

    @Override
    public void afterUpdate(EntryEvent event) {
        PartitionRegionConfig prConfig = (PartitionRegionConfig)event.getNewValue();
        if (!prConfig.getElderFPAs().isEmpty()) {
            this.updatePartitionMap(prConfig);
        }
    }

    private void updatePartitionMap(PartitionRegionConfig prConfig) {
        int prId = prConfig.getPRId();
        PartitionedRegion pr = null;
        try {
            pr = PartitionedRegion.getPRFromId(prId);
            if (pr != null) {
                ConcurrentMap<String, Integer[]> partitionMap = pr.getPartitionsMap();
                for (FixedPartitionAttributesImpl fxPrAttr : prConfig.getElderFPAs()) {
                    partitionMap.put(fxPrAttr.getPartitionName(), new Integer[]{fxPrAttr.getStartingBucketID(), fxPrAttr.getNumBuckets()});
                }
            }
        }
        catch (PRLocallyDestroyedException e) {
            logger.debug("PRLocallyDestroyedException : Region ={} is locally destroyed on this node", new Object[]{prConfig.getPRId(), e});
        }
    }
}

