/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.TXCommitMessage;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class FindRemoteTXMessage
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private TXId txId;
    private int processorId;

    public FindRemoteTXMessage() {
    }

    public FindRemoteTXMessage(TXId txid, int processorId, Set recipients) {
        this.setRecipients(recipients);
        this.txId = txid;
        this.processorId = processorId;
    }

    public static FindRemoteTXMessageReplyProcessor send(Cache cache, TXId txId) {
        InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
        DM dm = system.getDistributionManager();
        Set recipients = dm.getOtherDistributionManagerIds();
        FindRemoteTXMessageReplyProcessor processor = new FindRemoteTXMessageReplyProcessor(dm, (Collection)recipients, txId);
        FindRemoteTXMessage msg = new FindRemoteTXMessage(txId, processor.getProcessorId(), recipients);
        dm.putOutgoing(msg);
        return processor;
    }

    @Override
    public int getDSFID() {
        return -40;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        boolean sendReply = true;
        Throwable thr = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("processing {}", new Object[]{this});
            }
            FindRemoteTXMessageReply reply = new FindRemoteTXMessageReply();
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache != null) {
                TXManagerImpl mgr = (TXManagerImpl)cache.getCacheTransactionManager();
                mgr.waitForCompletingTransaction(this.txId);
                boolean bl = reply.isHostingTx = mgr.isHostedTxInProgress(this.txId) || mgr.isHostedTxRecentlyCompleted(this.txId);
                if (!reply.isHostingTx) {
                    TXCommitMessage partialMessage = TXCommitMessage.getTracker().getTXCommitMessage(this.txId);
                    if (partialMessage != null) {
                        reply.txCommitMessage = partialMessage;
                        reply.isPartialCommitMessage = true;
                    }
                    mgr.removeHostedTXState(this.txId);
                }
            }
            reply.setRecipient(this.getSender());
            reply.setProcessorId(this.processorId);
            this.getReplySender(dm).putOutgoing(reply);
            sendReply = false;
            if (logger.isDebugEnabled()) {
                logger.debug("TX: FoundRemoteTXMessage: isHostingTx for txid:{}? {} isPartialCommit? {}", new Object[]{this.txId, reply.isHostingTx, reply.isPartialCommitMessage});
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (sendReply) {
                thr = t;
            }
        }
        finally {
            ReplySender rs = this.getReplySender(dm);
            if (sendReply && (this.processorId != 0 || rs != dm)) {
                ReplyException rex = null;
                if (thr != null) {
                    rex = new ReplyException(thr);
                }
                ReplyMessage.send(this.getSender(), this.processorId, rex, this.getReplySender(dm));
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        String className = this.getClass().getName();
        buff.append(className.substring(className.indexOf(".cache.") + ".cache.".length()));
        buff.append("(txId=").append(this.txId).append("; sender=").append(this.getSender()).append("; processorId=").append(this.processorId);
        buff.append(")");
        return buff.toString();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.txId, out);
        out.writeInt(this.processorId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.txId = (TXId)DataSerializer.readObject(in);
        this.processorId = in.readInt();
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    public static class FindRemoteTXMessageReply
    extends ReplyMessage {
        protected boolean isHostingTx;
        protected boolean isPartialCommitMessage;
        protected TXCommitMessage txCommitMessage;

        @Override
        public int getDSFID() {
            return -41;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.isHostingTx);
            boolean sendTXCommitMessage = this.txCommitMessage != null;
            out.writeBoolean(sendTXCommitMessage);
            if (sendTXCommitMessage) {
                out.writeBoolean(this.isPartialCommitMessage);
                this.txCommitMessage.setClientVersion(null);
                InternalDataSerializer.writeDSFID(this.txCommitMessage, out);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.isHostingTx = in.readBoolean();
            if (in.readBoolean()) {
                this.isPartialCommitMessage = in.readBoolean();
                this.txCommitMessage = (TXCommitMessage)InternalDataSerializer.readDSFID(in);
            }
        }
    }

    public static class FindRemoteTXMessageReplyProcessor
    extends ReplyProcessor21 {
        private InternalDistributedMember hostingMember;
        private TXCommitMessage txCommit;
        private TXId txId;
        private Set<TXCommitMessage> partialCommitMessages = new HashSet<TXCommitMessage>();

        public FindRemoteTXMessageReplyProcessor(DM dm, Collection initMembers, TXId txId) {
            super(dm, initMembers);
            this.txId = txId;
        }

        @Override
        public void process(DistributionMessage msg) {
            if (msg instanceof FindRemoteTXMessageReply) {
                FindRemoteTXMessageReply reply = (FindRemoteTXMessageReply)msg;
                if (reply.isHostingTx) {
                    this.hostingMember = msg.getSender();
                } else if (reply.isPartialCommitMessage) {
                    this.partialCommitMessages.add(reply.txCommitMessage);
                }
            }
            super.process(msg);
        }

        public InternalDistributedMember getHostingMember() {
            return this.hostingMember;
        }

        @Override
        public boolean stillWaiting() {
            return this.hostingMember == null && super.stillWaiting();
        }

        public TXCommitMessage getTxCommitMessage() {
            if (this.txCommit != null) {
                return this.txCommit;
            }
            if (!this.partialCommitMessages.isEmpty()) {
                TXCommitMessage localTXMessage = TXCommitMessage.getTracker().getTXCommitMessage(this.txId);
                if (localTXMessage != null) {
                    this.partialCommitMessages.add(localTXMessage);
                }
                this.txCommit = TXCommitMessage.combine(this.partialCommitMessages);
            }
            return this.txCommit;
        }
    }
}

