/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.PooledExecutorWithDMStats;
import com.gemstone.gemfire.internal.SystemTimer;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.tcp.ConnectionTable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class ExpiryTask
extends SystemTimer.SystemTimerTask {
    private static final Logger logger = LogService.getLogger();
    private LocalRegion region;
    private static final ThreadPoolExecutor executor;
    private static boolean expirationSuspended;
    private static final Object suspendLock;
    private static final ThreadLocal<Long> now;
    public static ExpiryTaskListener expiryTaskListener;

    protected ExpiryTask(LocalRegion region) {
        this.region = region;
    }

    protected abstract ExpirationAttributes getIdleAttributes();

    protected abstract ExpirationAttributes getTTLAttributes();

    public long getExpirationTime() throws EntryNotFoundException {
        long ttl = this.getTTLExpirationTime();
        long idle = this.getIdleExpirationTime();
        if (ttl == 0L) {
            return idle;
        }
        if (idle == 0L) {
            return ttl;
        }
        return Math.min(ttl, idle);
    }

    public final long getTTLExpirationTime() throws EntryNotFoundException {
        long ttl = this.getTTLAttributes().getTimeout();
        long tilt = 0L;
        if (ttl > 0L) {
            if (this.getLocalRegion() != null && !this.getLocalRegion().EXPIRY_UNITS_MS) {
                ttl *= 1000L;
            }
            tilt = this.getLastModifiedTime() + ttl;
        }
        return tilt;
    }

    public final long getIdleExpirationTime() throws EntryNotFoundException {
        long idle = this.getIdleAttributes().getTimeout();
        long tilt = 0L;
        if (idle > 0L) {
            if (this.getLocalRegion() != null && !this.getLocalRegion().EXPIRY_UNITS_MS) {
                idle *= 1000L;
            }
            tilt = this.getLastAccessedTime() + idle;
        }
        return tilt;
    }

    final long getExpiryMillis() throws EntryNotFoundException {
        long extm = this.getExpirationTime() - ExpiryTask.getNow();
        if (extm < 0L) {
            return 0L;
        }
        return extm;
    }

    protected boolean isExpirationPossible() throws EntryNotFoundException {
        long expTime = this.getExpirationTime();
        return expTime > 0L && ExpiryTask.getNow() >= expTime;
    }

    protected boolean isExpirationAllowed() {
        return this.getLocalRegion().isExpirationAllowed(this);
    }

    protected void performTimeout() throws CacheException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}.performTimeout(): getExpirationTime() returns {}", new Object[]{this.toString(), this.getExpirationTime()});
        }
        this.getLocalRegion().performExpiryTimeout(this);
    }

    protected abstract void basicPerformTimeout(boolean var1) throws CacheException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void suspendExpiration() {
        Object object = suspendLock;
        synchronized (object) {
            expirationSuspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void permitExpiration() {
        Object object = suspendLock;
        synchronized (object) {
            expirationSuspended = false;
            suspendLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitOnExpirationSuspension() {
        while (true) {
            this.getLocalRegion().getCancelCriterion().checkCancelInProgress(null);
            Object object = suspendLock;
            synchronized (object) {
                boolean interrupted = Thread.interrupted();
                try {
                    while (expirationSuspended) {
                        suspendLock.wait();
                    }
                    break;
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    this.getLocalRegion().getCancelCriterion().checkCancelInProgress(null);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    protected final boolean expire(boolean isPending) throws CacheException {
        ExpirationAction action = this.getAction();
        if (action == null) {
            return false;
        }
        boolean result = this.expire(action, isPending);
        if (result && expiryTaskListener != null) {
            expiryTaskListener.afterExpire(this);
        }
        return result;
    }

    protected ExpirationAction getAction() {
        long ttl = this.getTTLExpirationTime();
        long idle = this.getIdleExpirationTime();
        if (ttl == 0L) {
            if (idle == 0L) {
                return null;
            }
            return this.getIdleAttributes().getAction();
        }
        if (idle == 0L) {
            return this.getTTLAttributes().getAction();
        }
        if (idle < ttl) {
            return this.getIdleAttributes().getAction();
        }
        return this.getTTLAttributes().getAction();
    }

    protected boolean isDistributedAction() {
        ExpirationAction action = this.getAction();
        return action != null && (action.isInvalidate() || action.isDestroy());
    }

    final LocalRegion getLocalRegion() {
        return this.region;
    }

    protected final boolean expire(ExpirationAction action, boolean isPending) throws CacheException {
        if (action.isInvalidate()) {
            return this.invalidate();
        }
        if (action.isDestroy()) {
            return this.destroy(isPending);
        }
        if (action.isLocalInvalidate()) {
            return this.localInvalidate();
        }
        if (action.isLocalDestroy()) {
            return this.localDestroy();
        }
        throw new InternalGemFireError(LocalizedStrings.ExpiryTask_UNRECOGNIZED_EXPIRATION_ACTION_0.toLocalizedString(action));
    }

    @Override
    public boolean cancel() {
        boolean superCancel = super.cancel();
        LocalRegion lr = this.getLocalRegion();
        if (lr != null && superCancel) {
            this.region = null;
        }
        return superCancel;
    }

    @Override
    public final void run2() {
        try {
            if (executor != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ExpiryTask.this.runInThreadPool();
                    }
                });
            } else {
                this.runInThreadPool();
            }
        }
        catch (RejectedExecutionException ex) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Rejected execution in expiration task", (Throwable)ex);
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                t.printStackTrace();
            }
        }
        catch (CancelException e) {
            return;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.ExpiryTask_EXCEPTION_IN_EXPIRATION_TASK), ex);
        }
    }

    protected void runInThreadPool() {
        try {
            if (this.isCacheClosing() || this.getLocalRegion().isClosed() || this.getLocalRegion().isDestroyed()) {
                return;
            }
            this.waitOnExpirationSuspension();
            if (logger.isTraceEnabled()) {
                logger.trace("{} is fired", new Object[]{this});
            }
            this.performTimeout();
        }
        catch (RegionDestroyedException regionDestroyedException) {
        }
        catch (EntryNotFoundException entryNotFoundException) {
        }
        catch (CancelException cancelException) {
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.ExpiryTask_EXCEPTION_IN_EXPIRATION_TASK), ex);
        }
        finally {
            if (expiryTaskListener != null) {
                expiryTaskListener.afterTaskRan(this);
            }
        }
    }

    protected boolean isCacheClosing() {
        return this.getLocalRegion().getCache().isClosed();
    }

    protected abstract void reschedule() throws CacheException;

    public String toString() {
        String expTtl = "<unavailable>";
        String expIdle = "<unavailable>";
        try {
            if (this.getTTLAttributes() != null) {
                expTtl = String.valueOf(this.getTTLExpirationTime());
            }
            if (this.getIdleAttributes() != null) {
                expIdle = String.valueOf(this.getIdleExpirationTime());
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
        }
        return super.toString() + " for " + this.getLocalRegion() + ", ttl expiration time: " + expTtl + ", idle expiration time: " + expIdle + "[now:" + ExpiryTask.calculateNow() + "]";
    }

    protected abstract long getLastModifiedTime() throws EntryNotFoundException;

    protected abstract long getLastAccessedTime() throws EntryNotFoundException;

    protected abstract boolean invalidate() throws CacheException;

    protected abstract boolean destroy(boolean var1) throws CacheException;

    protected abstract boolean localInvalidate() throws EntryNotFoundException;

    protected abstract boolean localDestroy() throws CacheException;

    protected abstract void addExpiryTask() throws EntryNotFoundException;

    public abstract boolean isPending();

    public abstract Object getKey();

    public static void setNow() {
        now.set(ExpiryTask.calculateNow());
    }

    private static long calculateNow() {
        InternalDistributedSystem ids;
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && (ids = cache.getDistributedSystem()) != null) {
            return ids.getClock().cacheTimeMillis();
        }
        return 0L;
    }

    public static void clearNow() {
        now.remove();
    }

    public static long getNow() {
        Long tl = now.get();
        long result = tl != null ? tl : ExpiryTask.calculateNow();
        return result;
    }

    static {
        int nThreads = Integer.getInteger("gemfire.EXPIRY_THREADS", 0);
        if (nThreads > 0) {
            ThreadFactory tf = new ThreadFactory(){
                private int nextId = 0;

                @Override
                public Thread newThread(final Runnable command) {
                    String name = "Expiration threads";
                    LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup(name);
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ConnectionTable.threadWantsSharedResources();
                            try {
                                command.run();
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, "Expiry " + this.nextId++);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            SynchronousQueue<Runnable> q = new SynchronousQueue<Runnable>();
            executor = new PooledExecutorWithDMStats(q, nThreads, tf);
        } else {
            executor = null;
        }
        expirationSuspended = false;
        suspendLock = new Object();
        now = new ThreadLocal();
    }

    public static interface ExpiryTaskListener {
        public void afterTaskRan(ExpiryTask var1);

        public void afterReschedule(ExpiryTask var1);

        public void afterExpire(ExpiryTask var1);
    }
}

