/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.cache.CacheStatistics;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.StatisticsDisabledException;
import com.gemstone.gemfire.internal.cache.CacheStatisticsImpl;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.NonLocalRegionEntry;
import com.gemstone.gemfire.internal.cache.NonLocalRegionEntryWithStats;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.versions.VersionStamp;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;

public class EntrySnapshot
implements Region.Entry,
DataSerializable {
    private static final long serialVersionUID = -2139749921655693280L;
    private boolean startedLocal;
    private boolean entryDestroyed;
    public transient LocalRegion region = null;
    public transient NonLocalRegionEntry regionEntry;

    public EntrySnapshot(RegionEntry regionEntry, LocalRegion dataRegion, LocalRegion region, boolean allowTombstones) {
        this.region = region;
        if (regionEntry instanceof NonLocalRegionEntry) {
            this.regionEntry = (NonLocalRegionEntry)regionEntry;
            this.startedLocal = false;
        } else {
            this.startedLocal = true;
            this.regionEntry = regionEntry.hasStats() ? new NonLocalRegionEntryWithStats(regionEntry, dataRegion, allowTombstones) : new NonLocalRegionEntry(regionEntry, dataRegion, allowTombstones);
        }
    }

    public boolean wasInitiallyLocal() {
        return this.startedLocal;
    }

    @Override
    public Object getKey() {
        this.checkEntryDestroyed();
        return this.regionEntry.getKey();
    }

    public VersionTag getVersionTag() {
        VersionStamp stamp = this.regionEntry.getVersionStamp();
        if (stamp != null) {
            return stamp.asVersionTag();
        }
        return null;
    }

    public Object getRawValue() {
        Object v = this.regionEntry.getValue(null);
        if (v == null) {
            return null;
        }
        if (v instanceof CachedDeserializable) {
            v = this.region.isCopyOnRead() ? ((CachedDeserializable)v).getDeserializedWritableCopy(null, null) : ((CachedDeserializable)v).getDeserializedValue(null, null);
            if (v == Token.INVALID || v == Token.LOCAL_INVALID) {
                v = null;
            }
        } else {
            v = v == Token.INVALID || v == Token.LOCAL_INVALID ? null : this.conditionalCopy(v);
        }
        return v;
    }

    @Override
    public Object getValue() {
        this.checkEntryDestroyed();
        return this.getRawValue();
    }

    private Object conditionalCopy(Object o) {
        return o;
    }

    @Override
    public Object getUserAttribute() {
        this.checkEntryDestroyed();
        Map userAttr = this.region.entryUserAttributes;
        if (userAttr == null) {
            return null;
        }
        return userAttr.get(this.regionEntry.getKey());
    }

    @Override
    public Object setUserAttribute(Object value) {
        this.checkEntryDestroyed();
        if (this.region.entryUserAttributes == null) {
            this.region.entryUserAttributes = new Hashtable();
        }
        return this.region.entryUserAttributes.put(this.regionEntry.getKey(), value);
    }

    @Override
    public boolean isDestroyed() {
        if (this.entryDestroyed) {
            return true;
        }
        if (this.region.isDestroyed()) {
            this.entryDestroyed = true;
        } else if (this.regionEntry.isRemoved()) {
            this.entryDestroyed = true;
        }
        return this.entryDestroyed;
    }

    public Region getRegion() {
        this.checkEntryDestroyed();
        return this.region;
    }

    @Override
    public CacheStatistics getStatistics() throws StatisticsDisabledException {
        this.checkEntryDestroyed();
        if (!this.regionEntry.hasStats() || !this.region.statisticsEnabled) {
            throw new StatisticsDisabledException(LocalizedStrings.PartitionedRegion_STATISTICS_DISABLED_FOR_REGION_0.toLocalizedString(this.region.getFullPath()));
        }
        return new CacheStatisticsImpl(this.regionEntry, this.region);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof EntrySnapshot)) {
            return false;
        }
        EntrySnapshot ent = (EntrySnapshot)obj;
        return this.regionEntry.getKey().equals(ent.getKey());
    }

    @Override
    public int hashCode() {
        return this.regionEntry.getKey().hashCode();
    }

    @Override
    public Object setValue(Object arg) {
        Object returnValue = this.region.put(this.getKey(), arg);
        this.regionEntry.setCachedValue(arg);
        return returnValue;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    public String toString() {
        if (this.isDestroyed()) {
            return "EntrySnapshot(#destroyed#" + this.regionEntry.getKey() + "; version=" + this.getVersionTag() + ")";
        }
        return "EntrySnapshot(" + this.regionEntry + ")";
    }

    public RegionEntry getRegionEntry() {
        return this.regionEntry;
    }

    private void checkEntryDestroyed() throws EntryDestroyedException {
        if (this.isDestroyed()) {
            throw new EntryDestroyedException(LocalizedStrings.PartitionedRegion_ENTRY_DESTROYED.toLocalizedString());
        }
    }

    public EntrySnapshot() {
    }

    public EntrySnapshot(DataInput in, LocalRegion region) throws IOException, ClassNotFoundException {
        this.fromData(in);
        this.region = region;
    }

    public void setRegion(LocalRegion r) {
        this.region = r;
    }

    public void setRegionEntry(NonLocalRegionEntry re) {
        this.regionEntry = re;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeBoolean(this.regionEntry instanceof NonLocalRegionEntryWithStats);
        this.regionEntry.toData(out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.startedLocal = false;
        boolean hasStats = in.readBoolean();
        this.regionEntry = hasStats ? new NonLocalRegionEntryWithStats() : new NonLocalRegionEntry();
        this.regionEntry.fromData(in);
    }
}

