/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

public abstract class EntryBits {
    private static final byte SERIALIZED = 1;
    private static final byte INVALID = 2;
    private static final byte LOCAL_INVALID = 4;
    private static final byte RECOVERED_FROM_DISK = 8;
    private static final byte PENDING_ASYNC = 16;
    private static final byte TOMBSTONE = 64;
    private static final byte WITH_VERSIONS = -128;
    private static final byte EAGER_DESERIALIZE = 32;

    public static boolean isSerialized(byte b) {
        return (b & 1) != 0;
    }

    public static boolean isInvalid(byte b) {
        return (b & 2) != 0;
    }

    public static boolean isLocalInvalid(byte b) {
        return (b & 4) != 0;
    }

    public static boolean isTombstone(byte b) {
        return (b & 0x40) != 0;
    }

    public static boolean isWithVersions(byte b) {
        return (b & 0xFFFFFF80) != 0;
    }

    public static boolean isRecoveredFromDisk(byte b) {
        return (b & 8) != 0;
    }

    public static boolean isPendingAsync(byte b) {
        return (b & 0x10) != 0;
    }

    public static boolean isAnyInvalid(byte b) {
        return (b & 6) != 0;
    }

    public static boolean isNeedsValue(byte b) {
        return (b & 0x46) == 0;
    }

    public static boolean isEagerDeserialize(byte b) {
        return (b & 0x20) != 0;
    }

    public static byte setSerialized(byte b, boolean isSerialized) {
        return isSerialized ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE);
    }

    public static byte setInvalid(byte b, boolean isInvalid) {
        return isInvalid ? (byte)(b | 2) : (byte)(b & 0xFFFFFFFD);
    }

    public static byte setLocalInvalid(byte b, boolean isLocalInvalid) {
        return isLocalInvalid ? (byte)(b | 4) : (byte)(b & 0xFFFFFFFB);
    }

    public static byte setTombstone(byte b, boolean isTombstone) {
        return isTombstone ? (byte)(b | 0x40) : (byte)(b & 0xFFFFFFBF);
    }

    public static byte setWithVersions(byte b, boolean isWithVersions) {
        return isWithVersions ? (byte)(b | 0xFFFFFF80) : (byte)(b & 0x7F);
    }

    public static byte setRecoveredFromDisk(byte b, boolean isRecoveredFromDisk) {
        return isRecoveredFromDisk ? (byte)(b | 8) : (byte)(b & 0xFFFFFFF7);
    }

    public static byte setPendingAsync(byte b, boolean isPendingAsync) {
        return isPendingAsync ? (byte)(b | 0x10) : (byte)(b & 0xFFFFFFEF);
    }

    public static byte getPersistentBits(byte b) {
        return (byte)(b & 0xFFFFFFC7);
    }

    public static byte setEagerDeserialize(byte b) {
        return (byte)(b | 0x20);
    }

    public static byte clearEagerDeserialize(byte b) {
        return (byte)(b & 0xFFFFFFDF);
    }
}

