/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.query.internal.cq.CqService;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.SerialDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.CopyOnWriteHashSet;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.DestroyRegionOperation;
import com.gemstone.gemfire.internal.cache.DirectReplyMessage;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.DistributedRemoveAllOperation;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.FilterProfile;
import com.gemstone.gemfire.internal.cache.FilterRoutingInfo;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.QueuedOperation;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.cache.ReliableDistributionData;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessage;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.UpdateOperation;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.cache.versions.DiskVersionTag;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.offheap.StoredObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class DistributedCacheOperation {
    private static final Logger logger = LogService.getLogger();
    public static double LOSS_SIMULATION_RATIO = 0.0;
    public static Random LOSS_SIMULATION_GENERATOR;
    public static long SLOW_DISTRIBUTION_MS;
    public static final byte DESERIALIZATION_POLICY_NONE = 0;
    public static final byte DESERIALIZATION_POLICY_EAGER = 1;
    public static final byte DESERIALIZATION_POLICY_LAZY = 2;
    public static final byte VALUE_IS_BYTES = 0;
    public static final byte VALUE_IS_SERIALIZED_OBJECT = 1;
    public static final byte VALUE_IS_OBJECT = 2;
    public static final byte DESERIALIZATION_POLICY_NUMBITS;
    public static final short DESERIALIZATION_POLICY_END;
    public static final short DESERIALIZATION_POLICY_MASK;
    public static boolean testSendingOldValues;
    protected InternalCacheEvent event;
    protected CacheOperationReplyProcessor processor = null;
    protected Set departedMembers;
    protected Set originalRecipients;
    static Runnable internalBeforePutOutgoing;

    public static void writeValue(byte deserializationPolicy, Object vObj, byte[] vBytes, DataOutput out) throws IOException {
        if (vObj != null) {
            if (deserializationPolicy == 1) {
                DataSerializer.writeObject(vObj, out);
            } else if (deserializationPolicy == 0) {
                StoredObject so = (StoredObject)vObj;
                assert (!so.isSerialized());
                so.sendAsByteArray(out);
            } else {
                DataSerializer.writeObjectAsByteArray(vObj, out);
            }
        } else if (deserializationPolicy == 1) {
            out.write(vBytes);
        } else {
            DataSerializer.writeByteArray(vBytes, out);
        }
    }

    public static byte valueIsToDeserializationPolicy(boolean oldValueIsSerialized) {
        if (!oldValueIsSerialized) {
            return 0;
        }
        if (CachedDeserializableFactory.preferObject()) {
            return 1;
        }
        return 2;
    }

    public static String deserializationPolicyToString(byte policy) {
        switch (policy) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "EAGER";
            }
            case 2: {
                return "LAZY";
            }
        }
        throw new AssertionError((Object)"unknown deserialization policy");
    }

    public DistributedCacheOperation(CacheEvent event) {
        this.event = (InternalCacheEvent)event;
    }

    boolean isOperationReliable() {
        Operation op = this.event.getOperation();
        if (!op.isRegionDestroy()) {
            return true;
        }
        return op.isDistributed();
    }

    public boolean supportsDirectAck() {
        return true;
    }

    public boolean supportsMulticast() {
        return true;
    }

    public boolean canBeSentDuringShutdown() {
        return this.getRegion().isUsedForPartitionedRegionAdmin();
    }

    protected boolean supportsAdjunctMessaging() {
        return true;
    }

    protected boolean supportsDeltaPropagation() {
        return false;
    }

    public boolean containsRegionContentChange() {
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void distribute() {
        long viewVersion;
        DistributedRegion region;
        block82: {
            boolean reliableOp;
            region = this.getRegion();
            DM mgr = region.getDistributionManager();
            boolean bl = reliableOp = this.isOperationReliable() && region.requiresReliabilityCheck();
            if (SLOW_DISTRIBUTION_MS > 0L) {
                try {
                    Thread.sleep(SLOW_DISTRIBUTION_MS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                SLOW_DISTRIBUTION_MS = 0L;
            }
            boolean isPutAll = this instanceof DistributedPutAllOperation;
            boolean isRemoveAll = this instanceof DistributedRemoveAllOperation;
            viewVersion = -1L;
            if (this.containsRegionContentChange()) {
                viewVersion = region.getDistributionAdvisor().startOperation();
            }
            if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP)) {
                logger.trace(LogMarker.STATE_FLUSH_OP, "dispatching operation in view version {}", new Object[]{viewVersion});
            }
            try {
                Set newFailures;
                RemoteOperationMessage rmsg;
                EntryEventImpl entryEvent;
                Set recipients = this.getRecipients();
                Map<InternalDistributedMember, PersistentMemberID> persistentIds = null;
                if (region.getDataPolicy().withPersistence()) {
                    persistentIds = region.getDistributionAdvisor().adviseInitializedPersistentMembers();
                }
                Set needsOldValueInCacheOp = Collections.EMPTY_SET;
                boolean routingComputed = false;
                FilterRoutingInfo filterRouting = null;
                Set twoMessages = Collections.EMPTY_SET;
                if (region.isUsedForPartitionedRegionBucket()) {
                    twoMessages = ((BucketRegion)region).getBucketAdvisor().adviseRequiresTwoMessages();
                    routingComputed = true;
                    filterRouting = this.getRecipientFilterRouting(recipients);
                    if (filterRouting != null && logger.isDebugEnabled()) {
                        logger.debug("Computed this filter routing: {}", new Object[]{filterRouting});
                    }
                }
                Set adjunctRecipients = Collections.EMPTY_SET;
                if (this.supportsAdjunctMessaging() && region.isUsedForPartitionedRegionBucket()) {
                    BucketRegion br = (BucketRegion)region;
                    adjunctRecipients = this.getAdjunctReceivers(br, recipients, twoMessages, filterRouting);
                }
                EntryEventImpl entryEventImpl = entryEvent = this.event.getOperation().isEntry() ? this.getEvent() : null;
                if (entryEvent != null && entryEvent.hasOldValue()) {
                    needsOldValueInCacheOp = testSendingOldValues ? new HashSet(recipients) : region.getCacheDistributionAdvisor().adviseRequiresOldValueInCacheOp();
                    recipients.removeAll(needsOldValueInCacheOp);
                }
                Set cachelessNodes = Collections.EMPTY_SET;
                Set adviseCacheServers = Collections.EMPTY_SET;
                HashSet cachelessNodesWithNoCacheServer = new HashSet();
                if (region.getDistributionConfig().getDeltaPropagation() && this.supportsDeltaPropagation()) {
                    cachelessNodes = region.getCacheDistributionAdvisor().adviseEmptys();
                    if (!cachelessNodes.isEmpty()) {
                        ArrayList list = new ArrayList(cachelessNodes);
                        for (Object member : cachelessNodes) {
                            if (!recipients.contains(member)) {
                                list.remove(member);
                                continue;
                            }
                            if (!adjunctRecipients.contains(member)) continue;
                            list.remove(member);
                        }
                        cachelessNodes.clear();
                        recipients.removeAll(list);
                        cachelessNodes.addAll(list);
                    }
                    cachelessNodesWithNoCacheServer.addAll(cachelessNodes);
                    adviseCacheServers = region.getCacheDistributionAdvisor().adviseCacheServers();
                    cachelessNodesWithNoCacheServer.removeAll(adviseCacheServers);
                }
                if (recipients.isEmpty() && adjunctRecipients.isEmpty() && needsOldValueInCacheOp.isEmpty() && cachelessNodes.isEmpty()) {
                    if (mgr.getNormalDistributionManagerIds().size() > 1) {
                        if (region.isInternalRegion()) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("<No Recipients> {}", new Object[]{this});
                            }
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("<No Recipients> {}", new Object[]{this});
                        }
                    }
                    if (reliableOp && !region.isNoDistributionOk()) {
                        CacheOperationMessage msg = this.createMessage();
                        this.initMessage(msg, null);
                        msg.setRecipients(recipients);
                        region.handleReliableDistribution(msg, Collections.EMPTY_SET);
                    }
                    if (region.isUsedForPartitionedRegionBucket()) {
                        FilterRoutingInfo.FilterInfo filterInfo = this.getLocalFilterRouting(filterRouting);
                        this.event.setLocalFilterInfo(filterInfo);
                    }
                    break block82;
                }
                boolean directAck = false;
                boolean useMulticast = region.getMulticastEnabled() && region.getSystem().getConfig().getMcastPort() != 0 && this.supportsMulticast();
                boolean shouldAck = this.shouldAck();
                if (shouldAck && this.supportsDirectAck() && adjunctRecipients.isEmpty() && region.getSystem().threadOwnsResources()) {
                    directAck = true;
                }
                if (entryEvent != null && (rmsg = entryEvent.getRemoteOperationMessage()) != null) {
                    recipients.remove(rmsg.getSender());
                    useMulticast = false;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("recipients for {}: {} with adjunct messages to: {}", new Object[]{this, recipients, adjunctRecipients});
                }
                if (shouldAck) {
                    AbstractCollection waitForMembers = null;
                    if (recipients.size() > 0 && adjunctRecipients.size() == 0 && cachelessNodes.isEmpty()) {
                        waitForMembers = recipients;
                    } else if (!cachelessNodes.isEmpty()) {
                        waitForMembers = new HashSet(recipients);
                        waitForMembers.addAll(cachelessNodes);
                    } else {
                        waitForMembers = new Vector(recipients);
                        waitForMembers.addAll(adjunctRecipients);
                        waitForMembers.addAll(needsOldValueInCacheOp);
                        waitForMembers.addAll(cachelessNodes);
                    }
                    if (LOSS_SIMULATION_RATIO != 0.0) {
                        if (LOSS_SIMULATION_GENERATOR == null) {
                            LOSS_SIMULATION_GENERATOR = new Random(this.hashCode());
                        }
                        if ((double)LOSS_SIMULATION_GENERATOR.nextInt(100) * 1.0 / 100.0 < LOSS_SIMULATION_RATIO) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("loss simulation is inhibiting message transmission to {}", new Object[]{recipients});
                            }
                            waitForMembers.removeAll(recipients);
                            recipients = Collections.EMPTY_SET;
                        }
                    }
                    if (reliableOp) {
                        this.departedMembers = new HashSet();
                        this.processor = new ReliableCacheReplyProcessor(region.getSystem(), (Collection)waitForMembers, this.departedMembers);
                    } else {
                        this.processor = new CacheOperationReplyProcessor(region.getSystem(), (Collection)waitForMembers);
                    }
                }
                Set failures = null;
                CacheOperationMessage msg = this.createMessage();
                this.initMessage(msg, this.processor);
                if (internalBeforePutOutgoing != null) {
                    internalBeforePutOutgoing.run();
                }
                if (this.processor != null && msg.isSevereAlertCompatible()) {
                    PartitionMessage pm;
                    this.processor.enableSevereAlertProcessing();
                    DistributedRegion r = this.getRegion();
                    if (r.isUsedForPartitionedRegionBucket() && this.event.getOperation().isEntry() && (pm = ((EntryEventImpl)this.event).getPartitionMessage()) != null && pm.getSender() != null && !pm.getSender().equals(r.getDistributionManager().getDistributionManagerId())) {
                        ReplyProcessor21.setShortSevereAlertProcessing(true);
                    }
                }
                msg.setMulticast(useMulticast);
                msg.directAck = directAck;
                if (region.isUsedForPartitionedRegionBucket()) {
                    if (!isPutAll && !isRemoveAll && filterRouting != null && filterRouting.hasMemberWithFilterInfo()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Setting filter information for message to {}", new Object[]{filterRouting});
                        }
                        msg.filterRouting = filterRouting;
                    }
                } else if (!routingComputed) {
                    msg.needsRouting = true;
                }
                this.initProcessor(this.processor, msg);
                if (region.cache.isClosed() && !this.canBeSentDuringShutdown()) {
                    throw region.cache.getCacheClosedException(LocalizedStrings.DistributedCacheOperation_THE_CACHE_HAS_BEEN_CLOSED.toLocalizedString(), null);
                }
                msg.setRecipients(recipients);
                failures = mgr.putOutgoing(msg);
                if (needsOldValueInCacheOp.size() > 0) {
                    msg.appendOldValueToMessage((EntryEventImpl)this.event);
                    msg.resetRecipients();
                    msg.setRecipients(needsOldValueInCacheOp);
                    newFailures = mgr.putOutgoing(msg);
                    if (newFailures != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Failed sending ({}) to {}", new Object[]{msg, newFailures});
                        }
                        if (failures != null && failures.size() > 0) {
                            failures.addAll(newFailures);
                        } else {
                            failures = newFailures;
                        }
                    }
                }
                if (cachelessNodes.size() > 0) {
                    cachelessNodes.removeAll(cachelessNodesWithNoCacheServer);
                    if (cachelessNodes.size() > 0) {
                        msg.resetRecipients();
                        msg.setRecipients(cachelessNodes);
                        msg.setSendDelta(false);
                        newFailures = mgr.putOutgoing(msg);
                        if (newFailures != null) {
                            if (failures != null && failures.size() > 0) {
                                failures.addAll(newFailures);
                            } else {
                                failures = newFailures;
                            }
                        }
                    }
                    if (cachelessNodesWithNoCacheServer.size() > 0) {
                        msg.resetRecipients();
                        msg.setRecipients(cachelessNodesWithNoCacheServer);
                        msg.setSendDelta(false);
                        ((UpdateOperation.UpdateMessage)msg).setSendDeltaWithFullValue(false);
                        newFailures = mgr.putOutgoing(msg);
                        if (newFailures != null) {
                            if (failures != null && failures.size() > 0) {
                                failures.addAll(newFailures);
                            } else {
                                failures = newFailures;
                            }
                        }
                    }
                    cachelessNodes.addAll(cachelessNodesWithNoCacheServer);
                }
                if (failures != null && !failures.isEmpty() && logger.isDebugEnabled()) {
                    logger.debug("Failed sending ({}) to {} while processing event:{}", new Object[]{msg, failures, this.event});
                }
                HashSet adjunctRecipientsWithNoCacheServer = new HashSet();
                if (!adjunctRecipients.isEmpty()) {
                    if (cachelessNodes.size() > 0) {
                        if (recipients.isEmpty()) {
                            recipients = cachelessNodes;
                        } else {
                            recipients.addAll(cachelessNodes);
                        }
                    }
                    adjunctRecipientsWithNoCacheServer.addAll(adjunctRecipients);
                    adviseCacheServers = ((BucketRegion)region).getPartitionedRegion().getCacheDistributionAdvisor().adviseCacheServers();
                    adjunctRecipientsWithNoCacheServer.removeAll(adviseCacheServers);
                    if (isPutAll) {
                        ((BucketRegion)region).performPutAllAdjunctMessaging((DistributedPutAllOperation)this, recipients, adjunctRecipients, filterRouting, this.processor);
                    } else if (isRemoveAll) {
                        ((BucketRegion)region).performRemoveAllAdjunctMessaging((DistributedRemoveAllOperation)this, recipients, adjunctRecipients, filterRouting, this.processor);
                    } else {
                        boolean calculateDelta = adjunctRecipientsWithNoCacheServer.size() < adjunctRecipients.size();
                        adjunctRecipients.removeAll(adjunctRecipientsWithNoCacheServer);
                        if (!adjunctRecipients.isEmpty()) {
                            ((BucketRegion)region).performAdjunctMessaging(this.getEvent(), recipients, adjunctRecipients, filterRouting, this.processor, calculateDelta, true);
                        }
                        if (!adjunctRecipientsWithNoCacheServer.isEmpty()) {
                            ((BucketRegion)region).performAdjunctMessaging(this.getEvent(), recipients, adjunctRecipientsWithNoCacheServer, filterRouting, this.processor, calculateDelta, false);
                        }
                    }
                }
                if (viewVersion > 0L) {
                    region.getDistributionAdvisor().endOperation(viewVersion);
                    viewVersion = -1L;
                }
                if (region.isUsedForPartitionedRegionBucket()) {
                    FilterRoutingInfo.FilterInfo filterInfo = this.getLocalFilterRouting(filterRouting);
                    this.event.setLocalFilterInfo(filterInfo);
                }
                this.waitForAckIfNeeded(msg, persistentIds);
                if (reliableOp) {
                    HashSet successfulRecips = new HashSet(recipients);
                    successfulRecips.addAll(cachelessNodes);
                    successfulRecips.addAll(needsOldValueInCacheOp);
                    if (failures != null && !failures.isEmpty()) {
                        successfulRecips.removeAll(failures);
                    }
                    if (this.departedMembers != null) {
                        successfulRecips.removeAll(this.departedMembers);
                    }
                    region.handleReliableDistribution(msg, successfulRecips);
                }
            }
            catch (CancelException e) {
                try {
                    if (!logger.isDebugEnabled()) throw e;
                    logger.debug("distribution of message aborted by shutdown: {}", new Object[]{this});
                    throw e;
                    catch (RuntimeException e2) {
                        logger.info((Message)LocalizedMessage.create(LocalizedStrings.DistributedCacheOperation_EXCEPTION_OCCURRED_WHILE_PROCESSING__0, this), (Throwable)e2);
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    ReplyProcessor21.setShortSevereAlertProcessing(false);
                    if (viewVersion == -1L) throw throwable;
                    if (logger.isDebugEnabled()) {
                        logger.trace(LogMarker.STATE_FLUSH_OP, "done dispatching operation in view version {}", new Object[]{viewVersion});
                    }
                    region.getDistributionAdvisor().endOperation(viewVersion);
                    throw throwable;
                }
            }
        }
        ReplyProcessor21.setShortSevereAlertProcessing(false);
        if (viewVersion == -1L) return;
        if (logger.isDebugEnabled()) {
            logger.trace(LogMarker.STATE_FLUSH_OP, "done dispatching operation in view version {}", new Object[]{viewVersion});
        }
        region.getDistributionAdvisor().endOperation(viewVersion);
    }

    Set getAdjunctReceivers(BucketRegion br, Set cacheOpReceivers, Set twoMessages, FilterRoutingInfo routing) {
        return br.getAdjunctReceivers(this.getEvent(), cacheOpReceivers, twoMessages, routing);
    }

    protected void initProcessor(CacheOperationReplyProcessor p, CacheOperationMessage msg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void waitForAckIfNeeded(CacheOperationMessage msg, Map<InternalDistributedMember, PersistentMemberID> persistentIds) {
        if (this.processor == null) {
            return;
        }
        try {
            try {
                this.processor.waitForRepliesUninterruptibly();
                Set<InternalDistributedMember> closedMembers = this.processor.closedMembers.getSnapshot();
                this.handleClosedMembers(closedMembers, persistentIds);
            }
            catch (ReplyException e) {
                if (this instanceof DestroyRegionOperation) {
                    logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.DistributedCacheOperation_WAITFORACKIFNEEDED_EXCEPTION), (Throwable)e);
                }
                e.handleAsUnexpected();
            }
        }
        finally {
            this.processor = null;
        }
    }

    private void handleClosedMembers(Set<InternalDistributedMember> closedMembers, Map<InternalDistributedMember, PersistentMemberID> persistentIds) {
        if (persistentIds == null) {
            return;
        }
        for (InternalDistributedMember member : closedMembers) {
            PersistentMemberID persistentId = persistentIds.get(member);
            if (persistentId == null) continue;
            this.getRegion().getCancelCriterion().checkCancelInProgress(null);
            this.getRegion().getPersistenceAdvisor().markMemberOffline(member, persistentId);
        }
    }

    protected boolean shouldAck() {
        return this.getRegion().scope.isAck();
    }

    protected final DistributedRegion getRegion() {
        return (DistributedRegion)this.event.getRegion();
    }

    protected final EntryEventImpl getEvent() {
        return (EntryEventImpl)this.event;
    }

    protected Set getRecipients() {
        CacheDistributionAdvisor advisor = this.getRegion().getCacheDistributionAdvisor();
        this.originalRecipients = advisor.adviseCacheOp();
        return this.originalRecipients;
    }

    protected FilterRoutingInfo getRecipientFilterRouting(Set cacheOpRecipients) {
        DistributedRegion region = this.getRegion();
        if (!region.isUsedForPartitionedRegionBucket()) {
            return null;
        }
        CacheDistributionAdvisor advisor = ((BucketRegion)region).getPartitionedRegion().getCacheDistributionAdvisor();
        return advisor.adviseFilterRouting(this.event, cacheOpRecipients);
    }

    protected FilterRoutingInfo.FilterInfo getLocalFilterRouting(FilterRoutingInfo frInfo) {
        FilterProfile fp = this.getRegion().getFilterProfile();
        if (fp == null) {
            return null;
        }
        FilterRoutingInfo fri = fp.getFilterRoutingInfoPart2(frInfo, this.event);
        if (fri == null) {
            return null;
        }
        return fri.getLocalFilterInfo();
    }

    protected abstract CacheOperationMessage createMessage();

    protected void initMessage(CacheOperationMessage msg, DirectReplyProcessor p) {
        msg.regionPath = this.getRegion().getFullPath();
        msg.processorId = p == null ? 0 : p.getProcessorId();
        msg.processor = p;
        if (this.event.getOperation().isEntry()) {
            EntryEventImpl entryEvent = this.getEvent();
            msg.callbackArg = entryEvent.getRawCallbackArgument();
            msg.possibleDuplicate = entryEvent.isPossibleDuplicate();
            VersionTag tag = entryEvent.getVersionTag();
            msg.setInhibitNotificationsBit(entryEvent.inhibitAllNotifications());
            if (tag != null && tag.hasValidVersion()) {
                msg.setVersionTag(tag);
            }
        } else {
            msg.callbackArg = ((RegionEventImpl)this.event).getRawCallbackArgument();
        }
        msg.op = this.event.getOperation();
        msg.owner = this;
        msg.regionAllowsConflation = this.getRegion().getEnableAsyncConflation();
    }

    public String toString() {
        String cname = this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1);
        return cname + "(" + this.event + ")";
    }

    public static void setBeforePutOutgoing(Runnable beforePutOutgoing) {
        internalBeforePutOutgoing = beforePutOutgoing;
    }

    static {
        SLOW_DISTRIBUTION_MS = 0L;
        DESERIALIZATION_POLICY_NUMBITS = DistributionMessage.getNumBits(2);
        DESERIALIZATION_POLICY_END = (short)(1 << DESERIALIZATION_POLICY_NUMBITS);
        DESERIALIZATION_POLICY_MASK = (short)(DESERIALIZATION_POLICY_END - 1);
    }

    static class CacheOperationReplyProcessor
    extends DirectReplyProcessor {
        public CacheOperationMessage msg;
        public CopyOnWriteHashSet<InternalDistributedMember> closedMembers = new CopyOnWriteHashSet();

        public CacheOperationReplyProcessor(InternalDistributedSystem system, Collection initMembers) {
            super(system, initMembers);
        }

        @Override
        protected void process(DistributionMessage dmsg, boolean warn) {
            if (dmsg instanceof ReplyMessage) {
                ReplyMessage replyMessage = (ReplyMessage)dmsg;
                if (this.msg != null) {
                    boolean discard;
                    boolean bl = discard = !this.msg.processReply(replyMessage, this);
                    if (discard) {
                        return;
                    }
                }
                if (replyMessage.getClosed()) {
                    this.closedMembers.add(replyMessage.getSender());
                }
            }
            super.process(dmsg, warn);
        }
    }

    private static class ReliableCacheReplyProcessor
    extends CacheOperationReplyProcessor {
        private final Set failedMembers;
        private final DM dm;

        public ReliableCacheReplyProcessor(InternalDistributedSystem system, Collection initMembers, Set departedMembers) {
            super(system, initMembers);
            this.dm = system.getDistributionManager();
            this.failedMembers = departedMembers;
        }

        @Override
        protected synchronized void processException(DistributionMessage dmsg, ReplyException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof CancelException || cause instanceof RegionDestroyedException) {
                this.failedMembers.add(dmsg.getSender());
            } else {
                this.failedMembers.add(dmsg.getSender());
                super.processException(dmsg, ex);
            }
        }

        @Override
        protected void process(DistributionMessage dmsg, boolean warn) {
            if (dmsg instanceof ReplyMessage && ((ReplyMessage)dmsg).getIgnored()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} replied with ignored true", new Object[]{dmsg.getSender()});
                }
                this.failedMembers.add(dmsg.getSender());
            }
            super.process(dmsg, warn);
        }
    }

    public static abstract class CacheOperationMessage
    extends SerialDistributionMessage
    implements MessageWithReply,
    DirectReplyMessage,
    ReliableDistributionData,
    EntryEventImpl.OldValueImporter {
        protected static final short POSSIBLE_DUPLICATE_MASK = 8;
        protected static final short OLD_VALUE_MASK = 64;
        protected static final short DIRECT_ACK_MASK = 128;
        protected static final short FILTER_INFO_MASK = 256;
        protected static final short CALLBACK_ARG_MASK = 512;
        protected static final short DELTA_MASK = 1024;
        protected static final short NEEDS_ROUTING_MASK = 2048;
        protected static final short VERSION_TAG_MASK = 4096;
        protected static final short PERSISTENT_TAG_MASK = 8192;
        protected static final short UNRESERVED_FLAGS_START = 16384;
        private static final int INHIBIT_NOTIFICATIONS_MASK = 1024;
        protected static final short FETCH_FROM_HDFS = 512;
        protected static final short IS_PUT_DML = 256;
        public boolean needsRouting;
        protected String regionPath;
        protected int processorId;
        public DirectReplyProcessor processor;
        protected Object callbackArg;
        protected Operation op;
        public transient boolean directAck = false;
        protected transient DistributedCacheOperation owner;
        protected transient boolean appliedOperation = false;
        protected transient boolean closed = false;
        protected boolean hasOldValue;
        protected boolean oldValueIsSerialized;
        protected Object oldValue;
        protected boolean hasDelta = false;
        protected FilterRoutingInfo filterRouting;
        protected transient boolean sendDelta = true;
        protected VersionTag versionTag;
        protected transient short flags;
        protected boolean inhibitAllNotifications;
        protected transient boolean regionAllowsConflation;
        public boolean possibleDuplicate;

        public Operation getOperation() {
            return this.op;
        }

        public void setVersionTag(VersionTag tag) {
            this.versionTag = tag;
        }

        public VersionTag getVersionTag() {
            return this.versionTag;
        }

        @Override
        public boolean isSevereAlertCompatible() {
            return true;
        }

        @Override
        public DirectReplyProcessor getDirectReplyProcessor() {
            return this.processor;
        }

        @Override
        public void registerProcessor() {
            if (this.processor != null) {
                this.processorId = this.processor.register();
            }
            this.directAck = false;
        }

        public void setFilterInfo(FilterRoutingInfo fInfo) {
            this.filterRouting = fInfo;
        }

        public void setInhibitNotificationsBit(boolean inhibit) {
            this.inhibitAllNotifications = inhibit;
        }

        boolean processReply(ReplyMessage reply, CacheOperationReplyProcessor processor) {
            return true;
        }

        public void appendOldValueToMessage(EntryEventImpl event) {
            Object val = event.getRawOldValue();
            if (val == null || val == Token.NOT_AVAILABLE || val == Token.REMOVED_PHASE1 || val == Token.REMOVED_PHASE2 || val == Token.DESTROYED || val == Token.TOMBSTONE) {
                return;
            }
            event.exportOldValue(this);
        }

        public void setOldValueInEvent(EntryEventImpl event) {
            CqService cqService = event.getRegion().getCache().getCqService();
            if (cqService.isRunning()) {
                event.setOldValueForQueryProcessing();
                if (!event.hasOldValue() && this.hasOldValue) {
                    if (this.oldValueIsSerialized) {
                        event.setSerializedOldValue((byte[])this.oldValue);
                    } else {
                        event.setOldValue(this.oldValue);
                    }
                }
            }
        }

        protected void setHasDelta(boolean flag) {
            this.hasDelta = flag;
        }

        protected boolean hasDelta() {
            return this.hasDelta;
        }

        public FilterRoutingInfo getFilterInfo() {
            return this.filterRouting;
        }

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        @Override
        public boolean containsRegionContentChange() {
            return true;
        }

        protected LocalRegion getLocalRegionForProcessing(DistributionManager dm) {
            Assert.assertTrue(this.regionPath != null, "regionPath was null");
            GemFireCacheImpl gfc = (GemFireCacheImpl)CacheFactory.getInstance(dm.getSystem());
            return gfc.getRegionByPathForProcessing(this.regionPath);
        }

        /*
         * Exception decompiling
         */
        @Override
        protected final void process(DistributionManager dm) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void basicProcess(DistributionManager dm, LocalRegion lclRgn) {
            Throwable thr = null;
            boolean sendReply = true;
            InternalCacheEvent event = null;
            if (logger.isTraceEnabled()) {
                logger.trace("DistributedCacheOperation.basicProcess: {}", new Object[]{this});
            }
            try {
                if (lclRgn == null) {
                    this.closed = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} region not found, nothing to do", new Object[]{this});
                    }
                    return;
                }
                lclRgn.waitOnInitialization();
                if (lclRgn.scope.isLocal()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} local scope region, nothing to do", new Object[]{this});
                    }
                    return;
                }
                DistributedRegion rgn = (DistributedRegion)lclRgn;
                if (rgn.getImageState().getInRecovery()) {
                    return;
                }
                event = this.createEvent(rgn);
                try {
                    boolean isEntry = event.getOperation().isEntry();
                    if (isEntry && this.possibleDuplicate) {
                        ((EntryEventImpl)event).setPossibleDuplicate(true);
                        if (!rgn.isEventTrackerInitialized() && (rgn.getDataPolicy().withReplication() || rgn.getDataPolicy().withPreloaded())) {
                            if (logger.isDebugEnabled()) {
                                logger.trace(LogMarker.DM_BRIDGE_SERVER, "Ignoring possible duplicate event");
                            }
                            return;
                        }
                    }
                    sendReply = this.operateOnRegion(event, dm) && sendReply;
                }
                finally {
                    if (event instanceof EntryEventImpl) {
                        ((EntryEventImpl)event).release();
                    }
                }
            }
            catch (RegionDestroyedException e) {
                this.closed = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("{} Region destroyed: nothing to do", new Object[]{this});
                }
            }
            catch (CancelException e) {
                this.closed = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("{} Cancelled: nothing to do", new Object[]{this});
                }
            }
            catch (DiskAccessException e) {
                this.closed = true;
                if (!lclRgn.isDestroyed()) {
                    logger.error("Got disk access exception, expected region to be destroyed", (Throwable)e);
                }
            }
            catch (EntryNotFoundException e) {
                this.appliedOperation = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("{} Entry not found, nothing to do", new Object[]{this});
                }
            }
            catch (InvalidDeltaException ide) {
                ReplyException re = new ReplyException(ide);
                sendReply = false;
                this.sendReply(this.getSender(), this.processorId, re, this.getReplySender(dm));
                lclRgn.getCachePerfStats().incDeltaFullValuesRequested();
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                thr = t;
            }
            finally {
                this.checkVersionIsRecorded(this.versionTag, lclRgn);
                if (sendReply) {
                    ReplyException rex = null;
                    if (thr != null) {
                        rex = new ReplyException(thr);
                    }
                    this.sendReply(this.getSender(), this.processorId, rex, this.getReplySender(dm));
                } else if (thr != null) {
                    logger.error((Message)LocalizedMessage.create(LocalizedStrings.DistributedCacheOperation_EXCEPTION_OCCURRED_WHILE_PROCESSING__0, this), thr);
                }
            }
        }

        public void sendReply(InternalDistributedMember recipient, int pId, ReplyException rex, ReplySender dm) {
            if (pId != 0 || !(dm instanceof DM) || this.directAck) {
                ReplyException exception = rex;
                ReplyMessage.send(recipient, pId, exception, dm, !this.appliedOperation, this.closed, false, this.isInternal());
            }
        }

        public void checkVersionIsRecorded(VersionTag tag, LocalRegion r) {
            RegionVersionVector v;
            if (tag != null && !tag.isRecorded() && r != null && (v = r.getVersionVector()) != null) {
                Object mbr = tag.getMemberID();
                if (mbr == null) {
                    mbr = this.getSender();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("recording version tag in RVV in basicProcess since it wasn't done earlier");
                }
                v.recordVersion(mbr, tag);
            }
        }

        protected void dispatchElidedEvent(LocalRegion rgn, EntryEventImpl ev) {
            if (logger.isDebugEnabled()) {
                logger.debug("dispatching elided event: {}", new Object[]{ev});
            }
            ev.isConcurrencyConflict(true);
            rgn.generateLocalFilterRouting(ev);
            rgn.notifyBridgeClients(ev);
        }

        protected abstract InternalCacheEvent createEvent(DistributedRegion var1) throws EntryNotFoundException;

        protected abstract boolean operateOnRegion(CacheEvent var1, DistributionManager var2) throws EntryNotFoundException;

        @Override
        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append(this.getShortClassName());
            buff.append("(region path='");
            buff.append(this.regionPath);
            buff.append("'");
            this.appendFields(buff);
            buff.append(")");
            return buff.toString();
        }

        protected void appendFields(StringBuilder buff) {
            buff.append("; sender=");
            buff.append(this.getSender());
            buff.append("; callbackArg=");
            buff.append(this.callbackArg);
            buff.append("; processorId=");
            buff.append(this.processorId);
            buff.append("; op=");
            buff.append(this.op);
            buff.append("; applied=");
            buff.append(this.appliedOperation);
            buff.append("; directAck=");
            buff.append(this.directAck);
            buff.append("; posdup=");
            buff.append(this.possibleDuplicate);
            buff.append("; hasDelta=");
            buff.append(this.hasDelta);
            buff.append("; hasOldValue=");
            buff.append(this.hasOldValue);
            if (this.versionTag != null) {
                buff.append("; version=");
                buff.append(this.versionTag);
            }
            if (this.filterRouting != null) {
                buff.append(" ");
                buff.append(this.filterRouting.toString());
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            short bits = in.readShort();
            short extBits = in.readShort();
            this.flags = bits;
            this.setFlags(bits, in);
            this.regionPath = DataSerializer.readString(in);
            this.op = Operation.fromOrdinal(in.readByte());
            this.directAck = (bits & 0x80) != 0;
            boolean bl = this.possibleDuplicate = (bits & 8) != 0;
            if ((bits & 0x200) != 0) {
                this.callbackArg = DataSerializer.readObject(in);
            }
            this.hasDelta = (bits & 0x400) != 0;
            boolean bl2 = this.hasOldValue = (bits & 0x40) != 0;
            if (this.hasOldValue) {
                byte b = in.readByte();
                if (b == 0) {
                    this.oldValueIsSerialized = false;
                } else if (b == 1) {
                    this.oldValueIsSerialized = true;
                } else {
                    throw new IllegalStateException("expected 0 or 1");
                }
                this.oldValue = DataSerializer.readByteArray(in);
            }
            boolean hasFilterInfo = (bits & 0x100) != 0;
            boolean bl3 = this.needsRouting = (bits & 0x800) != 0;
            if (hasFilterInfo) {
                this.filterRouting = new FilterRoutingInfo();
                InternalDataSerializer.invokeFromData(this.filterRouting, in);
            }
            if ((bits & 0x1000) != 0) {
                boolean persistentTag = (bits & 0x2000) != 0;
                this.versionTag = VersionTag.create(persistentTag, in);
            }
            if ((extBits & 0x400) != 0) {
                this.inhibitAllNotifications = true;
                if (this instanceof DistributedPutAllOperation.PutAllMessage) {
                    ((DistributedPutAllOperation.PutAllMessage)this).setFetchFromHDFS((extBits & 0x200) != 0);
                    ((DistributedPutAllOperation.PutAllMessage)this).setPutDML((extBits & 0x100) != 0);
                }
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            short bits = 0;
            short extendedBits = 0;
            bits = this.computeCompressedShort(bits);
            extendedBits = this.computeCompressedExtBits(extendedBits);
            out.writeShort(bits);
            out.writeShort(extendedBits);
            if (this.processorId > 0) {
                out.writeInt(this.processorId);
            }
            DataSerializer.writeString(this.regionPath, out);
            out.writeByte(this.op.ordinal);
            if (this.callbackArg != null) {
                DataSerializer.writeObject(this.callbackArg, out);
            }
            if (this.hasOldValue) {
                byte[] vBytes;
                Object vObj;
                out.writeByte(this.oldValueIsSerialized ? 1 : 0);
                byte policy = DistributedCacheOperation.valueIsToDeserializationPolicy(this.oldValueIsSerialized);
                if (!this.oldValueIsSerialized && this.oldValue instanceof byte[]) {
                    vObj = null;
                    vBytes = (byte[])this.oldValue;
                } else {
                    vObj = this.oldValue;
                    vBytes = null;
                }
                DistributedCacheOperation.writeValue(policy, vObj, vBytes, out);
            }
            if (this.filterRouting != null) {
                InternalDataSerializer.invokeToData(this.filterRouting, out);
            }
            if (this.versionTag != null) {
                InternalDataSerializer.invokeToData(this.versionTag, out);
            }
        }

        protected short computeCompressedShort(short bits) {
            if (this.hasOldValue) {
                bits = (short)(bits | 0x40);
            }
            if (this.directAck) {
                bits = (short)(bits | 0x80);
            }
            if (this.possibleDuplicate) {
                bits = (short)(bits | 8);
            }
            if (this.processorId != 0) {
                bits = (short)(bits | 1);
            }
            if (this.callbackArg != null) {
                bits = (short)(bits | 0x200);
            }
            if (this.hasDelta) {
                bits = (short)(bits | 0x400);
            }
            if (this.filterRouting != null) {
                bits = (short)(bits | 0x100);
            }
            if (this.needsRouting) {
                bits = (short)(bits | 0x800);
            }
            if (this.versionTag != null) {
                bits = (short)(bits | 0x1000);
            }
            if (this.versionTag instanceof DiskVersionTag) {
                bits = (short)(bits | 0x2000);
            }
            if (this.inhibitAllNotifications) {
                bits = (short)(bits | 0x400);
            }
            return bits;
        }

        protected short computeCompressedExtBits(short bits) {
            if (this.inhibitAllNotifications) {
                bits = (short)(bits | 0x400);
            }
            return bits;
        }

        protected void setFlags(short bits, DataInput in) throws IOException, ClassNotFoundException {
            if ((bits & 1) != 0) {
                this.processorId = in.readInt();
                ReplyProcessor21.setMessageRPId(this.processorId);
            }
        }

        @Override
        public final boolean supportsDirectAck() {
            return this.directAck;
        }

        @Override
        public int getOperationCount() {
            return 1;
        }

        @Override
        public List getOperations() {
            byte noDeserialize = 0;
            QueuedOperation qOp = new QueuedOperation(this.getOperation(), null, null, null, noDeserialize, this.callbackArg);
            return Collections.singletonList(qOp);
        }

        public void setSendDelta(boolean sendDelta) {
            this.sendDelta = sendDelta;
        }

        @Override
        public boolean prefersOldSerialized() {
            return true;
        }

        @Override
        public boolean isUnretainedOldReferenceOk() {
            return true;
        }

        @Override
        public boolean isCachedDeserializableValueOk() {
            return false;
        }

        @Override
        public void importOldObject(Object ov, boolean isSerialized) {
            this.oldValueIsSerialized = isSerialized;
            this.oldValue = ov;
            this.hasOldValue = true;
        }

        @Override
        public void importOldBytes(byte[] ov, boolean isSerialized) {
            this.oldValueIsSerialized = isSerialized;
            this.oldValue = ov;
            this.hasOldValue = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final boolean _mayAddToMultipleSerialGateways(DistributionManager dm) {
            int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
            try {
                LocalRegion lr = this.getLocalRegionForProcessing(dm);
                if (lr == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = lr.notifiesMultipleSerialGateways();
                return bl;
            }
            catch (RuntimeException ignore) {
                boolean bl = false;
                return bl;
            }
            finally {
                LocalRegion.setThreadInitLevelRequirement(oldLevel);
            }
        }
    }
}

