/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.UnsupportedOperationInTransactionException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.DistTXPrecommitMessage;
import com.gemstone.gemfire.internal.cache.DistTXState;
import com.gemstone.gemfire.internal.cache.DistTXStateProxyImpl;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.ArrayList;
import java.util.TreeMap;

public class DistTXStateProxyImplOnDatanode
extends DistTXStateProxyImpl {
    private DistTXPrecommitMessage preCommitMessage = null;
    private boolean preCommitResponse = false;

    public DistTXStateProxyImplOnDatanode(TXManagerImpl managerImpl, TXId id, InternalDistributedMember clientMember) {
        super(managerImpl, id, clientMember);
    }

    public DistTXStateProxyImplOnDatanode(TXManagerImpl managerImpl, TXId id, boolean isjta) {
        super(managerImpl, id, isjta);
    }

    @Override
    public TXStateInterface getRealDeal(KeyInfo key, LocalRegion r) {
        if (this.realDeal == null) {
            this.realDeal = new DistTXState(this, false);
            if (r != null) {
                r.waitOnInitialization(r.initializationLatchBeforeGetInitialImage);
                this.target = r.getOwnerForKey(key);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Built a new DistTXState: {} me:{}", new Object[]{this.realDeal, this.txMgr.getDM().getId()});
            }
        }
        return this.realDeal;
    }

    @Override
    public TXStateInterface getRealDeal(DistributedMember t) {
        assert (t != null);
        if (this.realDeal == null) {
            this.target = t;
            this.realDeal = new DistTXState(this, false);
            if (logger.isDebugEnabled()) {
                logger.debug("Built a new DistTXState: {} me:{}", new Object[]{this.realDeal, this.txMgr.getDM().getId()});
            }
        }
        return this.realDeal;
    }

    private DistTXState getRealDeal() throws UnsupportedOperationInTransactionException {
        if (this.realDeal == null || !this.realDeal.isDistTx() || !this.realDeal.isTxState() || this.realDeal.isCreatedOnDistTxCoordinator()) {
            throw new UnsupportedOperationInTransactionException(LocalizedStrings.DISTTX_TX_EXPECTED.toLocalizedString("DistTXStateOnDatanode", this.realDeal != null ? this.realDeal.getClass().getSimpleName() : "null"));
        }
        return (DistTXState)this.realDeal;
    }

    @Override
    public void precommit() throws CommitConflictException, UnsupportedOperationInTransactionException {
        try {
            DistTXState txState = this.getRealDeal();
            boolean retVal = txState.applyOpsOnRedundantCopy(this.preCommitMessage.getSender(), this.preCommitMessage.getSecondaryTransactionalOperations());
            if (retVal) {
                this.setCommitOnBehalfOfRemoteStub(true);
                txState.precommit();
            }
            this.preCommitResponse = retVal;
        }
        catch (UnsupportedOperationInTransactionException e) {
            throw e;
        }
        finally {
            this.inProgress = true;
        }
    }

    public void setPreCommitMessage(DistTXPrecommitMessage preCommitMessage) {
        this.preCommitMessage = preCommitMessage;
    }

    public boolean getPreCommitResponse() {
        return this.preCommitResponse;
    }

    public boolean populateDistTxEntryStateList(TreeMap<String, ArrayList<TXEntryState.DistTxThinEntryState>> entryStateSortedMap) {
        return this.getRealDeal().populateDistTxEntryStateList(entryStateSortedMap);
    }

    public void populateDistTxEntryStates(ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> entryEventList) {
        this.getRealDeal().setDistTxEntryStates(entryEventList);
    }
}

