/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.DiskWriteAttributes;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public final class DiskWriteAttributesImpl
implements DiskWriteAttributes {
    private static final long serialVersionUID = -4269181954992768424L;
    private final boolean isSynchronous;
    private final long timeInterval;
    private final long bytesThreshold;
    private final boolean compactOplogs;
    private final long maxOplogSize;
    private static final long DEFAULT_MAX_OPLOG_SIZE = Long.getLong("gemfire.DEFAULT_MAX_OPLOG_SIZE", 1024L) * 0x100000L;
    private static final long DEFAULT_MAX_OPLOG_SIZE_LIMIT = 0x7FFFFFFF00000L;
    private static final boolean DEFAULT_ROLL_OPLOGS = true;
    private static final boolean DEFAULT_ALLOW_FORCE_COMPACTION = false;
    private static final boolean DEFAULT_IS_SYNCHRONOUS = false;
    static final long DEFAULT_TIME_INTERVAL = 1000L;
    private static final int DEFAULT_COMPACTION_THRESHOLD = 50;
    public static final String SYNCHRONOUS_PROPERTY = "synchronous";
    public static final String SYS_PERSISTENT_DIR = "sys-disk-dir";
    public static final String SYS_PERSISTENT_DIR_PROP = "sqlfabric.sys-disk-dir";
    public static final int DEFAULT_DISK_DIR_SIZE = Integer.MAX_VALUE;
    private static final DiskWriteAttributes DEFAULT_ASYNC_DWA;
    private static final DiskWriteAttributes DEFAULT_SYNC_DWA;

    public DiskWriteAttributesImpl(Properties properties) {
        String isSynchronousString = properties.getProperty(SYNCHRONOUS_PROPERTY);
        if (isSynchronousString == null) {
            this.isSynchronous = false;
        } else {
            this.verifyBooleanString(isSynchronousString, SYNCHRONOUS_PROPERTY);
            this.isSynchronous = Boolean.valueOf(isSynchronousString);
        }
        String compactOplogsString = properties.getProperty("roll-oplogs");
        if (compactOplogsString == null) {
            this.compactOplogs = true;
        } else {
            this.verifyBooleanString(compactOplogsString, "roll-oplogs");
            this.compactOplogs = Boolean.valueOf(compactOplogsString);
        }
        String bytesThresholdString = properties.getProperty("bytes-threshold");
        if (bytesThresholdString != null) {
            if (this.isSynchronous) {
                // empty if block
            }
            this.bytesThreshold = this.verifyLongInString(bytesThresholdString, "bytes-threshold");
        } else {
            this.bytesThreshold = 0L;
        }
        String timeIntervalString = properties.getProperty("time-interval");
        if (timeIntervalString != null) {
            if (this.isSynchronous) {
                // empty if block
            }
            this.timeInterval = this.verifyLongInString(timeIntervalString, "time-interval");
        } else {
            this.timeInterval = !this.isSynchronous && this.bytesThreshold == 0L ? 1000L : 0L;
        }
        String maxOplogSizeString = properties.getProperty("max-oplog-size");
        if (maxOplogSizeString != null) {
            long opSize = this.verifyLongInString(maxOplogSizeString, "max-oplog-size");
            if (opSize == 0L && this.compactOplogs) {
                throw new IllegalStateException(LocalizedStrings.DiskWriteAttributesImpl_COMPACTION_CANNOT_BE_SET_TO_TRUE_IF_MAXOPLOGSIZE_IS_SET_TO_INFINITE_INFINITE_IS_REPRESENTED_BY_SIZE_ZERO_0.toLocalizedString());
            }
            if (opSize == 0L || opSize == 0x7FFFFFFF00000L) {
                if (this.compactOplogs) {
                    throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesImpl_CANNOT_SET_MAXOPLOGS_SIZE_TO_INFINITY_0_IF_COMPACTION_IS_SET_TO_TRUE.toLocalizedString());
                }
                this.maxOplogSize = 0x7FFFFFFF00000L;
            } else {
                this.maxOplogSize = opSize;
            }
        } else {
            this.maxOplogSize = DEFAULT_MAX_OPLOG_SIZE;
        }
    }

    private void verifyBooleanString(String propertyString, String property) {
        if (!propertyString.equalsIgnoreCase("true") && !propertyString.equalsIgnoreCase("false")) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesImpl_0_PROPERTY_HAS_TO_BE_TRUE_OR_FALSE_OR_NULL_AND_CANNOT_BE_1.toLocalizedString(property, propertyString));
        }
    }

    private long verifyLongInString(String propertyString, String property) {
        long returnValue;
        try {
            returnValue = Long.valueOf(propertyString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesImpl_0_HAS_TO_BE_A_VALID_NUMBER_AND_NOT_1.toLocalizedString(property, propertyString));
        }
        if (returnValue < 0L) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesImpl_0_HAS_TO_BE_POSITIVE_NUMBER_AND_THE_VALUE_GIVEN_1_IS_NOT_ACCEPTABLE.toLocalizedString(property, returnValue));
        }
        return returnValue;
    }

    private int verifyPercentInString(String propertyString, String property) {
        int returnValue;
        try {
            returnValue = Integer.valueOf(propertyString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesImpl_0_HAS_TO_BE_A_VALID_NUMBER_AND_NOT_1.toLocalizedString(property, propertyString));
        }
        if (returnValue < 0) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesImpl_0_HAS_TO_BE_POSITIVE_NUMBER_AND_THE_VALUE_GIVEN_1_IS_NOT_ACCEPTABLE.toLocalizedString(property, returnValue));
        }
        if (returnValue > 100) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesImpl_0_HAS_TO_BE_LESS_THAN_2_BUT_WAS_1.toLocalizedString(property, returnValue, 100));
        }
        return returnValue;
    }

    @Override
    public boolean isSynchronous() {
        return this.isSynchronous;
    }

    @Override
    public boolean isRollOplogs() {
        return this.compactOplogs;
    }

    @Override
    public int getMaxOplogSize() {
        return (int)(this.maxOplogSize / 0x100000L);
    }

    long getMaxOplogSizeInBytes() {
        return this.maxOplogSize;
    }

    @Override
    public long getTimeInterval() {
        return this.timeInterval;
    }

    @Override
    public long getBytesThreshold() {
        return this.bytesThreshold;
    }

    @Override
    public boolean equals(Object o) {
        boolean result;
        if (!(o instanceof DiskWriteAttributesImpl)) {
            return false;
        }
        DiskWriteAttributesImpl other = (DiskWriteAttributesImpl)o;
        if (other.isSynchronous() != this.isSynchronous()) {
            return false;
        }
        boolean bl = result = other.isRollOplogs() == this.isRollOplogs() && other.getMaxOplogSize() == this.getMaxOplogSize();
        if (!this.isSynchronous()) {
            result = result && other.getTimeInterval() == this.getTimeInterval() && other.getBytesThreshold() == this.getBytesThreshold();
        }
        return result;
    }

    public int hashCode() {
        int result = 0;
        if (this.isSynchronous()) {
            if (this.isRollOplogs()) {
                result += 2;
            }
        } else {
            ++result;
            result = (int)((long)result + this.getTimeInterval());
            result = (int)((long)result + this.getBytesThreshold());
        }
        return result += this.getMaxOplogSize();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isSynchronous()) {
            sb.append("Synchronous writes to disk");
        } else {
            sb.append("Asynchronous writes to disk after a threshold of ");
            sb.append(this.getTimeInterval());
            sb.append("ms or ");
            sb.append(this.getBytesThreshold());
            sb.append(" bytes");
        }
        sb.append(". MaxOplog size is        : " + this.maxOplogSize);
        sb.append(". RollOplogs is          : " + this.compactOplogs);
        return sb.toString();
    }

    public static int getDefaultMaxOplogSizeLimit() {
        return Integer.MAX_VALUE;
    }

    public static boolean getDefaultRollOplogsValue() {
        return true;
    }

    public static int getDefaultMaxOplogSize() {
        return (int)(DEFAULT_MAX_OPLOG_SIZE / 0x100000L);
    }

    public static DiskWriteAttributes getDefaultAsyncInstance() {
        return DEFAULT_ASYNC_DWA;
    }

    public static DiskWriteAttributes getDefaultSyncInstance() {
        return DEFAULT_SYNC_DWA;
    }

    public static String generateOverFlowDirName(String dirName) {
        dirName = DiskWriteAttributesImpl.generatePersistentDirName(dirName);
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            throw new CacheClosedException("DiskWriteAttributesImpl::generateOverFlowDirName: no cache found.");
        }
        return dirName;
    }

    public static String generatePersistentDirName(String dirPath) {
        String baseDir = System.getProperty(SYS_PERSISTENT_DIR_PROP);
        if (baseDir == null) {
            baseDir = ".";
        }
        if (dirPath != null) {
            String driveName;
            File dirProvided = new File(dirPath);
            boolean isAbsolute = dirProvided.isAbsolute();
            if (!(isAbsolute || dirPath.charAt(0) != '/' && dirPath.charAt(0) != '\\' || (driveName = DiskWriteAttributesImpl.getCurrentDriveName()) == null)) {
                isAbsolute = true;
                dirPath = driveName + dirPath;
            }
            if (!isAbsolute) {
                dirPath = new File(baseDir, dirPath).getAbsolutePath();
            }
        } else {
            dirPath = baseDir;
        }
        return dirPath;
    }

    public static String getCurrentDriveName() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            try {
                return new File(".").getCanonicalPath().substring(0, 2);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Failed in setting the overflow directory", ex);
            }
        }
        return null;
    }

    static {
        Properties props = new Properties();
        props.setProperty(SYNCHRONOUS_PROPERTY, "false");
        DEFAULT_ASYNC_DWA = new DiskWriteAttributesImpl(props);
        props = new Properties();
        props.setProperty(SYNCHRONOUS_PROPERTY, "true");
        DEFAULT_SYNC_DWA = new DiskWriteAttributesImpl(props);
    }
}

