/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;

public class DiskStoreStats {
    private static final StatisticsType type;
    private static final int writesId;
    private static final int writeTimeId;
    private static final int bytesWrittenId;
    private static final int flushesId;
    private static final int flushTimeId;
    private static final int bytesFlushedId;
    private static final int readsId;
    private static final int readTimeId;
    private static final int recoveriesInProgressId;
    private static final int recoveryTimeId;
    private static final int recoveredBytesId;
    private static final int recoveredEntryCreatesId;
    private static final int recoveredEntryUpdatesId;
    private static final int recoveredEntryDestroysId;
    private static final int recoveredValuesSkippedDueToLRUId;
    private static final int recoveryRecordsSkippedId;
    private static final int compactsInProgressId;
    private static final int writesInProgressId;
    private static final int flushesInProgressId;
    private static final int compactTimeId;
    private static final int compactsId;
    private static final int oplogRecoveriesId;
    private static final int oplogRecoveryTimeId;
    private static final int oplogRecoveredBytesId;
    private static final int bytesReadId;
    private static final int removesId;
    private static final int removeTimeId;
    private static final int queueSizeId;
    private static final int compactInsertsId;
    private static final int compactInsertTimeId;
    private static final int compactUpdatesId;
    private static final int compactUpdateTimeId;
    private static final int compactDeletesId;
    private static final int compactDeleteTimeId;
    private static final int openOplogsId;
    private static final int inactiveOplogsId;
    private static final int compactableOplogsId;
    private static final int oplogReadsId;
    private static final int oplogSeeksId;
    private static final int uncreatedRecoveredRegionsId;
    private static final int backupsInProgress;
    private static final int backupsCompleted;
    private final Statistics stats;

    public DiskStoreStats(StatisticsFactory f, String name) {
        this.stats = f.createAtomicStatistics(type, name);
    }

    public void close() {
        this.stats.close();
    }

    public long getWrites() {
        return this.stats.getLong(writesId);
    }

    public long getWriteTime() {
        return this.stats.getLong(writeTimeId);
    }

    public long getBytesWritten() {
        return this.stats.getLong(bytesWrittenId);
    }

    public long getReads() {
        return this.stats.getLong(readsId);
    }

    public long getReadTime() {
        return this.stats.getLong(readTimeId);
    }

    public long getBytesRead() {
        return this.stats.getLong(bytesReadId);
    }

    public long getRemoves() {
        return this.stats.getLong(removesId);
    }

    public long getRemoveTime() {
        return this.stats.getLong(removeTimeId);
    }

    public long getQueueSize() {
        return this.stats.getInt(queueSizeId);
    }

    public void setQueueSize(int value) {
        this.stats.setInt(queueSizeId, value);
    }

    public void incQueueSize(int delta) {
        this.stats.incInt(queueSizeId, delta);
    }

    public void incUncreatedRecoveredRegions(int delta) {
        this.stats.incInt(uncreatedRecoveredRegionsId, delta);
    }

    public long startWrite() {
        this.stats.incInt(writesInProgressId, 1);
        return DistributionStats.getStatTime();
    }

    public long startFlush() {
        this.stats.incInt(flushesInProgressId, 1);
        return DistributionStats.getStatTime();
    }

    public void incWrittenBytes(long bytesWritten, boolean async) {
        this.stats.incLong(async ? bytesFlushedId : bytesWrittenId, bytesWritten);
    }

    public long endWrite(long start) {
        this.stats.incInt(writesInProgressId, -1);
        long end = DistributionStats.getStatTime();
        this.stats.incLong(writesId, 1L);
        this.stats.incLong(writeTimeId, end - start);
        return end;
    }

    public void endFlush(long start) {
        this.stats.incInt(flushesInProgressId, -1);
        long end = DistributionStats.getStatTime();
        this.stats.incLong(flushesId, 1L);
        this.stats.incLong(flushTimeId, end - start);
    }

    public long getFlushes() {
        return this.stats.getLong(flushesId);
    }

    public long startRead() {
        return DistributionStats.getStatTime();
    }

    public long endRead(long start, long bytesRead) {
        long end = DistributionStats.getStatTime();
        this.stats.incLong(readsId, 1L);
        this.stats.incLong(readTimeId, end - start);
        this.stats.incLong(bytesReadId, bytesRead);
        return end;
    }

    public long startRecovery() {
        this.stats.incInt(recoveriesInProgressId, 1);
        return DistributionStats.getStatTime();
    }

    public long startCompaction() {
        this.stats.incInt(compactsInProgressId, 1);
        return DistributionStats.getStatTime();
    }

    public long startOplogRead() {
        return DistributionStats.getStatTime();
    }

    public void endRecovery(long start, long bytesRead) {
        this.stats.incInt(recoveriesInProgressId, -1);
        long end = DistributionStats.getStatTime();
        this.stats.incLong(recoveryTimeId, end - start);
        this.stats.incLong(recoveredBytesId, bytesRead);
    }

    public void endCompaction(long start) {
        this.stats.incInt(compactsInProgressId, -1);
        long end = DistributionStats.getStatTime();
        this.stats.incInt(compactsId, 1);
        this.stats.incLong(compactTimeId, end - start);
    }

    public void endOplogRead(long start, long bytesRead) {
        long end = DistributionStats.getStatTime();
        this.stats.incInt(oplogRecoveriesId, 1);
        this.stats.incLong(oplogRecoveryTimeId, end - start);
        this.stats.incLong(oplogRecoveredBytesId, bytesRead);
    }

    public void incRecoveredEntryCreates() {
        this.stats.incLong(recoveredEntryCreatesId, 1L);
    }

    public void incRecoveredEntryUpdates() {
        this.stats.incLong(recoveredEntryUpdatesId, 1L);
    }

    public void incRecoveredEntryDestroys() {
        this.stats.incLong(recoveredEntryDestroysId, 1L);
    }

    public void incRecoveryRecordsSkipped() {
        this.stats.incLong(recoveryRecordsSkippedId, 1L);
    }

    public void incRecoveredValuesSkippedDueToLRU() {
        this.stats.incLong(recoveredValuesSkippedDueToLRUId, 1L);
    }

    public long startRemove() {
        return DistributionStats.getStatTime();
    }

    public long endRemove(long start) {
        long end = DistributionStats.getStatTime();
        this.stats.incLong(removesId, 1L);
        this.stats.incLong(removeTimeId, end - start);
        return end;
    }

    public void incOplogReads() {
        this.stats.incLong(oplogReadsId, 1L);
    }

    public void incOplogSeeks() {
        this.stats.incLong(oplogSeeksId, 1L);
    }

    public void incInactiveOplogs(int delta) {
        this.stats.incInt(inactiveOplogsId, delta);
    }

    public void incCompactableOplogs(int delta) {
        this.stats.incInt(compactableOplogsId, delta);
    }

    public void endCompactionDeletes(int count, long delta) {
        this.stats.incLong(compactDeletesId, (long)count);
        this.stats.incLong(compactDeleteTimeId, delta);
    }

    public void endCompactionInsert(long start) {
        this.stats.incLong(compactInsertsId, 1L);
        this.stats.incLong(compactInsertTimeId, this.getStatTime() - start);
    }

    public void endCompactionUpdate(long start) {
        this.stats.incLong(compactUpdatesId, 1L);
        this.stats.incLong(compactUpdateTimeId, this.getStatTime() - start);
    }

    public long getStatTime() {
        return DistributionStats.getStatTime();
    }

    public void incOpenOplogs() {
        this.stats.incInt(openOplogsId, 1);
    }

    public void decOpenOplogs() {
        this.stats.incInt(openOplogsId, -1);
    }

    public void startBackup() {
        this.stats.incInt(backupsInProgress, 1);
    }

    public void endBackup() {
        this.stats.incInt(backupsInProgress, -1);
        this.stats.incInt(backupsCompleted, 1);
    }

    public Statistics getStats() {
        return this.stats;
    }

    static {
        String statName = "DiskStoreStatistics";
        String statDescription = "Statistics about a Region's use of the disk";
        String writesDesc = "The total number of region entries that have been written to disk. A write is done every time an entry is created on disk or every time its value is modified on disk.";
        String writeTimeDesc = "The total amount of time spent writing to disk";
        String bytesWrittenDesc = "The total number of bytes that have been written to disk";
        String flushesDesc = "The total number of times the an entry has been flushed from the async queue.";
        String flushTimeDesc = "The total amount of time spent doing an async queue flush.";
        String bytesFlushedDesc = "The total number of bytes written to disk by async queue flushes.";
        String readsDesc = "The total number of region entries that have been read from disk";
        String readTimeDesc = "The total amount of time spent reading from disk";
        String bytesReadDesc = "The total number of bytes that have been read from disk";
        String recoveryTimeDesc = "The total amount of time spent doing a recovery";
        String recoveredBytesDesc = "The total number of bytes that have been read from disk during a recovery";
        String oplogRecoveriesDesc = "The total number of oplogs recovered";
        String oplogRecoveryTimeDesc = "The total amount of time spent doing an oplog recovery";
        String oplogRecoveredBytesDesc = "The total number of bytes that have been read from oplogs during a recovery";
        String removesDesc = "The total number of region entries that have been removed from disk";
        String removeTimeDesc = "The total amount of time spent removing from disk";
        String queueSizeDesc = "The current number of entries in the async queue waiting to be flushed to disk";
        String backupsInProgressDesc = "The current number of backups in progress on this disk store";
        String backupsCompletedDesc = "The number of backups of this disk store that have been taking while this VM was alive";
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        type = f.createType(statName, statDescription, new StatisticDescriptor[]{f.createLongCounter("writes", "The total number of region entries that have been written to disk. A write is done every time an entry is created on disk or every time its value is modified on disk.", "ops"), f.createLongCounter("writeTime", "The total amount of time spent writing to disk", "nanoseconds"), f.createLongCounter("writtenBytes", "The total number of bytes that have been written to disk", "bytes"), f.createLongCounter("flushes", "The total number of times the an entry has been flushed from the async queue.", "ops"), f.createLongCounter("flushTime", "The total amount of time spent doing an async queue flush.", "nanoseconds"), f.createLongCounter("flushedBytes", "The total number of bytes written to disk by async queue flushes.", "bytes"), f.createLongCounter("reads", "The total number of region entries that have been read from disk", "ops"), f.createLongCounter("readTime", "The total amount of time spent reading from disk", "nanoseconds"), f.createLongCounter("readBytes", "The total number of bytes that have been read from disk", "bytes"), f.createIntGauge("recoveriesInProgress", "current number of persistent regions being recovered from disk", "ops"), f.createLongCounter("recoveryTime", "The total amount of time spent doing a recovery", "nanoseconds"), f.createLongCounter("recoveredBytes", "The total number of bytes that have been read from disk during a recovery", "bytes"), f.createLongCounter("recoveredEntryCreates", "The total number of entry create records processed while recovering oplog data.", "ops"), f.createLongCounter("recoveredEntryUpdates", "The total number of entry update records processed while recovering oplog data.", "ops"), f.createLongCounter("recoveredEntryDestroys", "The total number of entry destroy records processed while recovering oplog data.", "ops"), f.createLongCounter("recoveredValuesSkippedDueToLRU", "The total number of entry values that did not need to be recovered due to the LRU.", "values"), f.createLongCounter("recoveryRecordsSkipped", "The total number of oplog records skipped during recovery.", "ops"), f.createIntCounter("oplogRecoveries", "The total number of oplogs recovered", "ops"), f.createLongCounter("oplogRecoveryTime", "The total amount of time spent doing an oplog recovery", "nanoseconds"), f.createLongCounter("oplogRecoveredBytes", "The total number of bytes that have been read from oplogs during a recovery", "bytes"), f.createLongCounter("removes", "The total number of region entries that have been removed from disk", "ops"), f.createLongCounter("removeTime", "The total amount of time spent removing from disk", "nanoseconds"), f.createIntGauge("queueSize", "The current number of entries in the async queue waiting to be flushed to disk", "entries"), f.createLongCounter("compactInserts", "Total number of times an oplog compact did a db insert", "inserts"), f.createLongCounter("compactInsertTime", "Total amount of time, in nanoseconds, spent doing inserts during a compact", "nanoseconds"), f.createLongCounter("compactUpdates", "Total number of times an oplog compact did an update", "updates"), f.createLongCounter("compactUpdateTime", "Total amount of time, in nanoseconds, spent doing updates during a compact", "nanoseconds"), f.createLongCounter("compactDeletes", "Total number of times an oplog compact did a delete", "deletes"), f.createLongCounter("compactDeleteTime", "Total amount of time, in nanoseconds, spent doing deletes during a compact", "nanoseconds"), f.createIntGauge("compactsInProgress", "current number of oplog compacts that are in progress", "compacts"), f.createIntGauge("writesInProgress", "current number of oplog writes that are in progress", "writes"), f.createIntGauge("flushesInProgress", "current number of oplog flushes that are in progress", "flushes"), f.createLongCounter("compactTime", "Total amount of time, in nanoseconds, spent compacting oplogs", "nanoseconds"), f.createIntCounter("compacts", "Total number of completed oplog compacts", "compacts"), f.createIntGauge("openOplogs", "Current number of oplogs this disk store has open", "oplogs"), f.createIntGauge("compactableOplogs", "Current number of oplogs ready to be compacted", "oplogs"), f.createIntGauge("inactiveOplogs", "Current number of oplogs that are no longer being written but are not ready ready to compact", "oplogs"), f.createLongCounter("oplogReads", "Total number of oplog reads", "reads"), f.createLongCounter("oplogSeeks", "Total number of oplog seeks", "seeks"), f.createIntGauge("uncreatedRecoveredRegions", "The current number of regions that have been recovered but have not yet been created.", "regions"), f.createIntGauge("backupsInProgress", "The current number of backups in progress on this disk store", "backups"), f.createIntCounter("backupsCompleted", "The number of backups of this disk store that have been taking while this VM was alive", "backups")});
        writesId = type.nameToId("writes");
        writeTimeId = type.nameToId("writeTime");
        bytesWrittenId = type.nameToId("writtenBytes");
        flushesId = type.nameToId("flushes");
        flushTimeId = type.nameToId("flushTime");
        bytesFlushedId = type.nameToId("flushedBytes");
        readsId = type.nameToId("reads");
        readTimeId = type.nameToId("readTime");
        bytesReadId = type.nameToId("readBytes");
        recoveriesInProgressId = type.nameToId("recoveriesInProgress");
        recoveryTimeId = type.nameToId("recoveryTime");
        recoveredBytesId = type.nameToId("recoveredBytes");
        recoveredEntryCreatesId = type.nameToId("recoveredEntryCreates");
        recoveredEntryUpdatesId = type.nameToId("recoveredEntryUpdates");
        recoveredEntryDestroysId = type.nameToId("recoveredEntryDestroys");
        recoveredValuesSkippedDueToLRUId = type.nameToId("recoveredValuesSkippedDueToLRU");
        recoveryRecordsSkippedId = type.nameToId("recoveryRecordsSkipped");
        compactsInProgressId = type.nameToId("compactsInProgress");
        writesInProgressId = type.nameToId("writesInProgress");
        flushesInProgressId = type.nameToId("flushesInProgress");
        compactTimeId = type.nameToId("compactTime");
        compactsId = type.nameToId("compacts");
        oplogRecoveriesId = type.nameToId("oplogRecoveries");
        oplogRecoveryTimeId = type.nameToId("oplogRecoveryTime");
        oplogRecoveredBytesId = type.nameToId("oplogRecoveredBytes");
        removesId = type.nameToId("removes");
        removeTimeId = type.nameToId("removeTime");
        queueSizeId = type.nameToId("queueSize");
        compactDeletesId = type.nameToId("compactDeletes");
        compactDeleteTimeId = type.nameToId("compactDeleteTime");
        compactInsertsId = type.nameToId("compactInserts");
        compactInsertTimeId = type.nameToId("compactInsertTime");
        compactUpdatesId = type.nameToId("compactUpdates");
        compactUpdateTimeId = type.nameToId("compactUpdateTime");
        oplogReadsId = type.nameToId("oplogReads");
        oplogSeeksId = type.nameToId("oplogSeeks");
        openOplogsId = type.nameToId("openOplogs");
        inactiveOplogsId = type.nameToId("inactiveOplogs");
        compactableOplogsId = type.nameToId("compactableOplogs");
        uncreatedRecoveredRegionsId = type.nameToId("uncreatedRecoveredRegions");
        backupsInProgress = type.nameToId("backupsInProgress");
        backupsCompleted = type.nameToId("backupsCompleted");
    }
}

