/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.DiskId;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryBits;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PlaceHolderDiskRegion;
import com.gemstone.gemfire.internal.cache.RegionClearedException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionMap;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.VMLRURegionMap;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.cache.lru.LRUClockNode;
import com.gemstone.gemfire.internal.cache.lru.LRUEntry;
import com.gemstone.gemfire.internal.cache.persistence.BytesAndBits;
import com.gemstone.gemfire.internal.cache.persistence.DiskRecoveryStore;
import com.gemstone.gemfire.internal.cache.persistence.DiskRegionView;
import com.gemstone.gemfire.internal.cache.versions.VersionStamp;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.offheap.AddressableMemoryManager;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.gemstone.gemfire.internal.offheap.ReferenceCountHelper;
import com.gemstone.gemfire.internal.offheap.StoredObject;
import com.gemstone.gemfire.internal.util.BlobHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.Logger;

public interface DiskEntry
extends RegionEntry {
    public static final byte[] INVALID_BYTES = new byte[0];
    public static final byte[] LOCAL_INVALID_BYTES = new byte[0];
    public static final byte[] TOMBSTONE_BYTES = new byte[0];

    public void setValueWithContext(RegionEntryContext var1, Object var2);

    public void handleValueOverflow(RegionEntryContext var1);

    public void afterValueOverflow(RegionEntryContext var1);

    public boolean isRemovedFromDisk();

    public DiskId getDiskId();

    public void _removePhase1();

    public int updateAsyncEntrySize(EnableLRU var1);

    public DiskEntry getPrev();

    public DiskEntry getNext();

    public void setPrev(DiskEntry var1);

    public void setNext(DiskEntry var1);

    public static class RecoveredEntry {
        private final long recoveredKeyId;
        private final Object value;
        private final long offsetInOplog;
        private final byte userBits;
        private final int valueLength;
        private long oplogId;
        private VersionTag tag;

        public RecoveredEntry(long keyId, long oplogId, long offsetInOplog, byte userBits, int valueLength) {
            this(-keyId, oplogId, offsetInOplog, userBits, valueLength, null);
        }

        public RecoveredEntry(long keyId, long oplogId, long offsetInOplog, byte userBits, int valueLength, Object value) {
            this.recoveredKeyId = keyId;
            this.value = value;
            this.oplogId = oplogId;
            this.offsetInOplog = offsetInOplog;
            this.userBits = EntryBits.setRecoveredFromDisk(userBits, true);
            this.valueLength = valueLength;
        }

        public long getRecoveredKeyId() {
            return this.recoveredKeyId;
        }

        public Object getValue() {
            return this.value;
        }

        public byte getUserBits() {
            return this.userBits;
        }

        public int getValueLength() {
            return this.valueLength;
        }

        public long getOffsetInOplog() {
            return this.offsetInOplog;
        }

        public long getOplogId() {
            return this.oplogId;
        }

        public void setOplogId(long v) {
            this.oplogId = v;
        }

        public VersionTag getVersionTag() {
            return this.tag;
        }

        public void setVersionTag(VersionTag tag) {
            this.tag = tag;
        }
    }

    public static class Helper {
        private static final Logger logger = LogService.getLogger();
        private static final ValueWrapper INVALID_VW = new ByteArrayValueWrapper(true, INVALID_BYTES);
        private static final ValueWrapper LOCAL_INVALID_VW = new ByteArrayValueWrapper(true, LOCAL_INVALID_BYTES);
        private static final ValueWrapper TOMBSTONE_VW = new ByteArrayValueWrapper(true, TOMBSTONE_BYTES);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static Object getValueOnDisk(DiskEntry entry, DiskRegion dr) {
            Object object;
            DiskId id = entry.getDiskId();
            if (id == null) {
                return null;
            }
            dr.acquireReadLock();
            try {
                DiskId diskId = id;
                synchronized (diskId) {
                    if (id == null || dr.isBackup() && id.getKeyId() == 0L || !entry.isValueNull() && id.needsToBeWritten() && !EntryBits.isRecoveredFromDisk(id.getUserBits())) {
                        Object var4_4 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                        dr.releaseReadLock();
                        return var4_4;
                    }
                    object = dr.getNoBuffer(id);
                }
            }
            catch (Throwable throwable) {
                dr.releaseReadLock();
                throw throwable;
            }
            dr.releaseReadLock();
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Object getSerializedValueOnDisk(DiskEntry entry, DiskRegion dr) {
            Object object;
            DiskId did = entry.getDiskId();
            if (did == null) {
                return null;
            }
            dr.acquireReadLock();
            try {
                DiskId diskId = did;
                synchronized (diskId) {
                    if (did == null || dr.isBackup() && did.getKeyId() == 0L) {
                        Object var4_4 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 5, 9] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                        dr.releaseReadLock();
                        return var4_4;
                    }
                }
            }
            catch (Throwable throwable) {
                dr.releaseReadLock();
                throw throwable;
            }
            {
                if (!entry.isValueNull() && did.needsToBeWritten() && !EntryBits.isRecoveredFromDisk(did.getUserBits())) {
                    Object var4_5 = null;
                    // MONITOREXIT @DISABLED, blocks:[5, 7] lbl19 : MonitorExitStatement: MONITOREXIT : var3_3
                    dr.releaseReadLock();
                    return var4_5;
                }
                object = dr.getSerializedData(did);
            }
            dr.releaseReadLock();
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Object getValueOnDiskOrBuffer(DiskEntry entry, DiskRegion dr, RegionEntryContext context) {
            Object v = Helper.getOffHeapValueOnDiskOrBuffer(entry, dr, context);
            if (v instanceof CachedDeserializable) {
                CachedDeserializable cd = (CachedDeserializable)v;
                try {
                    v = cd.getDeserializedValue(null, null);
                }
                finally {
                    OffHeapHelper.release(cd);
                }
            }
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        static Object getOffHeapValueOnDiskOrBuffer(DiskEntry entry, DiskRegion dr, RegionEntryContext context) {
            Object syncObj;
            DiskId did;
            block11: {
                did = entry.getDiskId();
                syncObj = did;
                if (syncObj == null) {
                    syncObj = entry;
                }
                if (syncObj == did) {
                    dr.acquireReadLock();
                }
                try {
                    Object object = syncObj;
                    // MONITORENTER : object
                    if (did == null || !did.isPendingAsync()) break block11;
                    Object v = entry._getValueRetain(context, true);
                    if (Token.isRemovedFromDisk(v)) {
                        v = null;
                    }
                    Object object2 = v;
                    // MONITOREXIT : object
                    if (syncObj != did) return object2;
                    dr.releaseReadLock();
                    return object2;
                }
                catch (Throwable throwable) {
                    if (syncObj != did) throw throwable;
                    dr.releaseReadLock();
                    throw throwable;
                }
            }
            if (did == null || dr.isBackup() && did.getKeyId() == 0L || !entry.isValueNull() && did.needsToBeWritten() && !EntryBits.isRecoveredFromDisk(did.getUserBits())) {
                Object var6_7 = null;
                // MONITOREXIT : object
                if (syncObj != did) return var6_7;
                dr.releaseReadLock();
                return var6_7;
            }
            Object object = dr.getSerializedData(did);
            // MONITOREXIT : object
            if (syncObj != did) return object;
            dr.releaseReadLock();
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        static boolean isOverflowedToDisk(DiskEntry de, DiskRegion dr, DistributedRegion.DiskPosition dp, RegionEntryContext context) {
            Object syncObj;
            DiskId did;
            block15: {
                boolean bl;
                Object v = null;
                DiskEntry diskEntry = de;
                // MONITORENTER : diskEntry
                did = de.getDiskId();
                // MONITOREXIT : diskEntry
                syncObj = did;
                if (syncObj == null) {
                    syncObj = de;
                }
                if (syncObj == did) {
                    dr.acquireReadLock();
                }
                try {
                    Object object = syncObj;
                    // MONITORENTER : object
                    if (!de.isValueNull()) break block15;
                    if (did == null) {
                        DiskEntry diskEntry2 = de;
                        // MONITORENTER : diskEntry2
                        did = de.getDiskId();
                        // MONITOREXIT : diskEntry2
                        assert (did != null);
                        boolean bl2 = Helper.isOverflowedToDisk(de, dr, dp, context);
                        // MONITOREXIT : object
                        if (syncObj != did) return bl2;
                        dr.releaseReadLock();
                        return bl2;
                    }
                    dp.setPosition(did.getOplogId(), did.getOffsetInOplog());
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (syncObj != did) throw throwable;
                    dr.releaseReadLock();
                    throw throwable;
                }
                if (syncObj != did) return bl;
                dr.releaseReadLock();
                return bl;
            }
            boolean bl = false;
            // MONITOREXIT : object
            if (syncObj != did) return bl;
            dr.releaseReadLock();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        static boolean fillInValue(DiskEntry de, InitialImageOperation.Entry entry, DiskRegion dr, DM mgr, ByteArrayDataInput in, RegionEntryContext context) {
            Object syncObj;
            DiskId did;
            Object v;
            block46: {
                block47: {
                    v = null;
                    DiskEntry diskEntry = de;
                    // MONITORENTER : diskEntry
                    did = de.getDiskId();
                    // MONITOREXIT : diskEntry
                    syncObj = did;
                    if (syncObj == null) {
                        syncObj = de;
                    }
                    if (syncObj == did) {
                        dr.acquireReadLock();
                    }
                    try {
                        Object object = syncObj;
                        // MONITORENTER : object
                        entry.setLastModified(mgr, de.getLastModified());
                        ReferenceCountHelper.setReferenceCountOwner(entry);
                        v = de._getValueRetain(context, true);
                        ReferenceCountHelper.setReferenceCountOwner(null);
                        if (v != null) break block46;
                        if (did != null) break block47;
                        DiskEntry diskEntry2 = de;
                        // MONITORENTER : diskEntry2
                        did = de.getDiskId();
                        // MONITOREXIT : diskEntry2
                        assert (did != null);
                        boolean bl = Helper.fillInValue(de, entry, dr, mgr, in, context);
                        // MONITOREXIT : object
                        if (syncObj != did) return bl;
                        dr.releaseReadLock();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        if (syncObj != did) throw throwable;
                        dr.releaseReadLock();
                        throw throwable;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("DiskEntry.Helper.fillInValue, key={}; getting value from disk, disk id={}", new Object[]{entry.key, did});
                }
                BytesAndBits bb = null;
                try {
                    bb = dr.getBytesAndBits(did, false);
                }
                catch (DiskAccessException dae) {
                    boolean bl = false;
                    // MONITOREXIT : object
                    if (syncObj != did) return bl;
                    dr.releaseReadLock();
                    return bl;
                }
                if (EntryBits.isInvalid(bb.getBits())) {
                    entry.setInvalid();
                } else if (EntryBits.isLocalInvalid(bb.getBits())) {
                    entry.setLocalInvalid();
                } else if (EntryBits.isTombstone(bb.getBits())) {
                    entry.setTombstone();
                } else {
                    entry.value = bb.getBytes();
                    entry.setSerialized(EntryBits.isSerialized(bb.getBits()));
                }
                boolean dae = true;
                // MONITOREXIT : object
                if (syncObj != did) return dae;
                dr.releaseReadLock();
                return dae;
            }
            if (syncObj == did) {
                dr.releaseReadLock();
            }
            boolean isEagerDeserialize = entry.isEagerDeserialize();
            if (isEagerDeserialize) {
                entry.clearEagerDeserialize();
            }
            if (Token.isRemovedFromDisk(v)) {
                return false;
            }
            if (v instanceof CachedDeserializable) {
                CachedDeserializable cd = (CachedDeserializable)v;
                try {
                    if (!cd.isSerialized()) {
                        entry.setSerialized(false);
                        entry.value = cd.getDeserializedForReading();
                        return true;
                    }
                    Object tmp = cd.getValue();
                    if (tmp instanceof byte[]) {
                        byte[] bb = (byte[])tmp;
                        entry.value = bb;
                        entry.setSerialized(true);
                        return true;
                    }
                    if (isEagerDeserialize && tmp instanceof byte[][]) {
                        entry.value = tmp;
                        entry.setEagerDeserialize();
                        entry.setSerialized(true);
                        return true;
                    }
                    try {
                        HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                        BlobHelper.serializeTo(tmp, hdos);
                        hdos.trim();
                        entry.value = hdos;
                        entry.setSerialized(true);
                        return true;
                    }
                    catch (IOException e) {
                        IllegalArgumentException e2 = new IllegalArgumentException(LocalizedStrings.DiskEntry_AN_IOEXCEPTION_WAS_THROWN_WHILE_SERIALIZING.toLocalizedString());
                        e2.initCause(e);
                        throw e2;
                    }
                }
                finally {
                    if (v != entry.value) {
                        OffHeapHelper.releaseWithNoTracking(v);
                    }
                }
            }
            if (v instanceof byte[]) {
                entry.value = v;
                entry.setSerialized(false);
                return true;
            }
            if (isEagerDeserialize && v instanceof byte[][]) {
                entry.value = v;
                entry.setEagerDeserialize();
                return true;
            }
            if (v == Token.INVALID) {
                entry.setInvalid();
                return true;
            }
            if (v == Token.LOCAL_INVALID) {
                entry.setLocalInvalid();
                return true;
            }
            if (v == Token.TOMBSTONE) {
                entry.setTombstone();
                return true;
            }
            Object preparedValue = v;
            if (preparedValue != null && (preparedValue = AbstractRegionEntry.prepareValueForGII(preparedValue)) == null) {
                return false;
            }
            if (CachedDeserializableFactory.preferObject()) {
                entry.value = preparedValue;
                entry.setEagerDeserialize();
                return true;
            }
            try {
                HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                BlobHelper.serializeTo(preparedValue, hdos);
                hdos.trim();
                entry.value = hdos;
                entry.setSerialized(true);
                return true;
            }
            catch (IOException e) {
                IllegalArgumentException e2 = new IllegalArgumentException(LocalizedStrings.DiskEntry_AN_IOEXCEPTION_WAS_THROWN_WHILE_SERIALIZING.toLocalizedString());
                e2.initCause(e);
                throw e2;
            }
        }

        static void initialize(DiskEntry entry, DiskRecoveryStore r, Object newValue) {
            DiskRegionView drv = null;
            if (r instanceof LocalRegion) {
                drv = ((LocalRegion)r).getDiskRegion();
            } else if (r instanceof DiskRegionView) {
                drv = (DiskRegionView)((Object)r);
            }
            if (drv == null) {
                throw new IllegalArgumentException(LocalizedStrings.DiskEntry_DISK_REGION_IS_NULL.toLocalizedString());
            }
            if (newValue == null || Token.isRemovedFromDisk(newValue)) {
                DiskId did = entry.getDiskId();
                if (did != null) {
                    did.setKeyId(0L);
                }
            } else if (newValue instanceof RecoveredEntry) {
                RecoveredEntry re = (RecoveredEntry)newValue;
                DiskId did = entry.getDiskId();
                did.setOplogId(re.getOplogId());
                did.setOffsetInOplog(re.getOffsetInOplog());
                did.setKeyId(re.getRecoveredKeyId());
                did.setUserBits(re.getUserBits());
                did.setValueLength(re.getValueLength());
                if (re.getRecoveredKeyId() < 0L) {
                    drv.incNumOverflowOnDisk(1L);
                    drv.incNumOverflowBytesOnDisk(did.getValueLength());
                    Helper.incrementBucketStats(r, 0, 1, did.getValueLength());
                } else {
                    entry.setValueWithContext(drv, entry.prepareValueForCache((RegionEntryContext)((Object)r), re.getValue(), false));
                    drv.incNumEntriesInVM(1L);
                    Helper.incrementBucketStats(r, 1, 0, 0);
                }
            } else {
                DiskId did = entry.getDiskId();
                if (did != null) {
                    did.setKeyId(0L);
                }
                drv.incNumEntriesInVM(1L);
                Helper.incrementBucketStats(r, 1, 0, 0);
            }
        }

        public static boolean wrapOffHeapReference(Object o) {
            StoredObject so;
            return o instanceof StoredObject && (so = (StoredObject)o).hasRefCount();
        }

        public static ValueWrapper createValueWrapper(Object value, EntryEventImpl event) {
            byte[] bytes;
            if (value == Token.INVALID) {
                return INVALID_VW;
            }
            if (value == Token.LOCAL_INVALID) {
                return LOCAL_INVALID_VW;
            }
            if (value == Token.TOMBSTONE) {
                return TOMBSTONE_VW;
            }
            boolean isSerializedObject = true;
            if (value instanceof CachedDeserializable) {
                CachedDeserializable proxy = (CachedDeserializable)value;
                if (Helper.wrapOffHeapReference(proxy)) {
                    return new OffHeapValueWrapper((StoredObject)proxy);
                }
                isSerializedObject = proxy.isSerialized();
                bytes = isSerializedObject ? proxy.getSerializedValue() : (byte[])proxy.getDeserializedForReading();
                if (event != null && isSerializedObject) {
                    event.setCachedSerializedNewValue(bytes);
                }
            } else if (value instanceof byte[]) {
                isSerializedObject = false;
                bytes = (byte[])value;
            } else {
                Assert.assertTrue(!Token.isRemovedFromDisk(value));
                if (event != null && event.getCachedSerializedNewValue() != null) {
                    bytes = event.getCachedSerializedNewValue();
                } else {
                    bytes = EntryEventImpl.serialize(value);
                    if (bytes.length == 0) {
                        throw new IllegalStateException("serializing <" + value + "> produced empty byte array");
                    }
                    if (event != null) {
                        event.setCachedSerializedNewValue(bytes);
                    }
                }
            }
            return new ByteArrayValueWrapper(isSerializedObject, bytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ValueWrapper createValueWrapperFromEntry(DiskEntry entry, LocalRegion region, EntryEventImpl event) {
            if (event != null) {
                Object rawValue = null;
                if (!event.hasDelta() && Helper.wrapOffHeapReference(rawValue = event.getRawNewValue())) {
                    return new OffHeapValueWrapper((StoredObject)rawValue);
                }
                if (event.getCachedSerializedNewValue() != null) {
                    return new ByteArrayValueWrapper(true, event.getCachedSerializedNewValue());
                }
                if (rawValue != null) {
                    return Helper.createValueWrapper(rawValue, event);
                }
            }
            Object value = entry._getValueRetain(region, true);
            try {
                ValueWrapper valueWrapper = Helper.createValueWrapper(value, event);
                return valueWrapper;
            }
            finally {
                OffHeapHelper.release(value);
            }
        }

        private static void writeToDisk(DiskEntry entry, LocalRegion region, boolean async) throws RegionClearedException {
            Helper.writeToDisk(entry, region, async, null);
        }

        private static void writeToDisk(DiskEntry entry, LocalRegion region, boolean async, EntryEventImpl event) throws RegionClearedException {
            Helper.writeBytesToDisk(entry, region, async, Helper.createValueWrapperFromEntry(entry, region, event));
        }

        private static void writeBytesToDisk(DiskEntry entry, LocalRegion region, boolean async, ValueWrapper vw) throws RegionClearedException {
            entry.getDiskId().unmarkForWriting();
            region.getDiskRegion().put(entry, region, vw, async);
        }

        public static void update(DiskEntry entry, LocalRegion region, Object newValue) throws RegionClearedException {
            Helper.update(entry, region, newValue, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public static void update(DiskEntry entry, LocalRegion region, Object newValue, EntryEventImpl event) throws RegionClearedException {
            dr = region.getDiskRegion();
            if (newValue == null) {
                throw new NullPointerException(LocalizedStrings.DiskEntry_ENTRYS_VALUE_SHOULD_NOT_BE_NULL.toLocalizedString());
            }
            maintainRVV = region.concurrencyChecksEnabled != false && dr.isBackup() != false;
            oldValue = null;
            oldValueLength = 0;
            scheduleAsync = false;
            callRemoveFromDisk = false;
            did = entry.getDiskId();
            tag = null;
            syncObj = did;
            if (syncObj == null) {
                syncObj = entry;
            }
            if (syncObj == did) {
                dr.acquireReadLock();
            }
            try {
                var13_13 = syncObj;
                synchronized (var13_13) {
                    oldValue = entry.getValueAsToken();
                    if (Token.isRemovedFromDisk(newValue)) {
                        if (dr.isBackup()) {
                            dr.testIsRecoveredAndClear(did);
                        }
                        rte = null;
                        try {
                            if (Token.isRemovedFromDisk(oldValue)) ** GOTO lbl108
                            if (dr.isSync()) {
                                Helper.removeFromDisk(entry, region, false);
                            }
                            callRemoveFromDisk = true;
                        }
                        catch (RuntimeException e) {
                            rte = e;
                            throw e;
                        }
                        finally {
                            if (rte == null || !(rte instanceof CacheClosedException)) {
                                entry.setValueWithContext(region, newValue);
                            }
                        }
                    } else if (newValue instanceof RecoveredEntry) {
                        re = (RecoveredEntry)newValue;
                        oldKeyId = did.getKeyId();
                        oldOplogId = did.getOplogId();
                        newOplogId = re.getOplogId();
                        if (newOplogId != oldOplogId) {
                            did.setOplogId(newOplogId);
                            re.setOplogId(oldOplogId);
                        }
                        did.setOffsetInOplog(re.getOffsetInOplog());
                        did.setUserBits(re.getUserBits());
                        oldValueLength = did.getValueLength();
                        did.setValueLength(re.getValueLength());
                        if (oldKeyId < 0L) {
                            dr.incNumOverflowOnDisk(-1L);
                            dr.incNumOverflowBytesOnDisk(-oldValueLength);
                            Helper.incrementBucketStats(region, 0, -1, -oldValueLength);
                        } else {
                            dr.incNumEntriesInVM(-1L);
                            Helper.incrementBucketStats(region, -1, 0, 0);
                        }
                        if (re.getRecoveredKeyId() < 0L) {
                            if (!entry.isValueNull()) {
                                try {
                                    entry.handleValueOverflow(region);
                                    entry.setValueWithContext(region, null);
                                }
                                finally {
                                    entry.afterValueOverflow(region);
                                }
                            }
                            dr.incNumOverflowOnDisk(1L);
                            dr.incNumOverflowBytesOnDisk(did.getValueLength());
                            Helper.incrementBucketStats(region, 0, 1, did.getValueLength());
                        } else {
                            entry.setValueWithContext(region, entry.prepareValueForCache(region, re.getValue(), false));
                            dr.incNumEntriesInVM(1L);
                            Helper.incrementBucketStats(region, 1, 0, 0);
                        }
                    } else {
                        oldValueLength = did != null && did.isPendingAsync() != false ? 0 : Helper.getValueLength(did);
                        if (dr.isBackup()) {
                            dr.testIsRecoveredAndClear(did);
                            if (dr.isSync()) {
                                if (AbstractRegionEntry.isCompressible(dr, newValue)) {
                                    entry.setValueWithContext(region, newValue);
                                    Helper.writeToDisk(entry, region, false, event);
                                } else {
                                    Helper.writeBytesToDisk(entry, region, false, Helper.createValueWrapper(newValue, event));
                                    entry.setValueWithContext(region, newValue);
                                }
                            } else if (did.isPendingAsync() && !maintainRVV) {
                                entry.setValueWithContext(region, newValue);
                            } else {
                                scheduleAsync = true;
                                did.setPendingAsync(true);
                                stamp = entry.getVersionStamp();
                                if (stamp != null) {
                                    tag = stamp.asVersionTag();
                                }
                                entry.setValueWithContext(region, newValue);
                            }
                        } else if (did != null) {
                            entry.setValueWithContext(region, newValue);
                            did.markForWriting();
                        } else {
                            entry.setValueWithContext(region, newValue);
                        }
                        if (Token.isRemovedFromDisk(oldValue)) {
                            dr.incNumEntriesInVM(1L);
                            Helper.incrementBucketStats(region, 1, 0, 0);
                        }
                    }
lbl108:
                    // 8 sources

                    if (entry instanceof LRUEntry) {
                        le = (LRUEntry)entry;
                        wasEvicted = le.testEvicted();
                        le.unsetEvicted();
                        if (!Token.isRemovedFromDisk(newValue) && (oldValue == null || wasEvicted && did != null && did.isPendingAsync())) {
                            dr.incNumEntriesInVM(1L);
                            dr.incNumOverflowOnDisk(-1L);
                            dr.incNumOverflowBytesOnDisk(-oldValueLength);
                            Helper.incrementBucketStats(region, 1, -1, -oldValueLength);
                        }
                    }
                }
            }
            finally {
                if (syncObj == did) {
                    dr.releaseReadLock();
                }
            }
            if (callRemoveFromDisk) {
                Helper.removeFromDisk(entry, region, false, oldValue == null, false);
            } else if (scheduleAsync && did.isPendingAsync()) {
                Helper.scheduleAsyncWrite(new DiskStoreImpl.AsyncDiskEntry(region, entry, tag));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int getValueLength(DiskId did) {
            int result = 0;
            if (did != null) {
                DiskId diskId = did;
                synchronized (diskId) {
                    result = did.getValueLength();
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void updateRecoveredEntry(PlaceHolderDiskRegion drv, DiskEntry entry, RecoveredEntry newValue, RegionEntryContext context) {
            DiskId did;
            if (newValue == null) {
                throw new NullPointerException(LocalizedStrings.DiskEntry_ENTRYS_VALUE_SHOULD_NOT_BE_NULL.toLocalizedString());
            }
            DiskId diskId = did = entry.getDiskId();
            synchronized (diskId) {
                boolean oldValueWasNull = entry.isValueNull();
                int oldValueLength = did.getValueLength();
                long oldOplogId = did.getOplogId();
                long newOplogId = newValue.getOplogId();
                if (newOplogId != oldOplogId) {
                    did.setOplogId(newOplogId);
                    newValue.setOplogId(oldOplogId);
                }
                did.setOffsetInOplog(newValue.getOffsetInOplog());
                did.setUserBits(newValue.getUserBits());
                did.setValueLength(newValue.getValueLength());
                if (newValue.getRecoveredKeyId() >= 0L) {
                    entry.setValueWithContext(context, entry.prepareValueForCache(drv, newValue.getValue(), false));
                } else if (!oldValueWasNull) {
                    try {
                        entry.handleValueOverflow(context);
                        entry.setValueWithContext(context, null);
                    }
                    finally {
                        entry.afterValueOverflow(context);
                    }
                }
                if (entry instanceof LRUEntry) {
                    LRUEntry le = (LRUEntry)((Object)entry);
                    assert (!le.testEvicted());
                    if (oldValueWasNull) {
                        drv.incNumEntriesInVM(1L);
                        drv.incNumOverflowOnDisk(-1L);
                        drv.incNumOverflowBytesOnDisk(-oldValueLength);
                    }
                }
            }
        }

        public static Object getValueInVMOrDiskWithoutFaultIn(DiskEntry entry, LocalRegion region) {
            Object result = OffHeapHelper.copyAndReleaseIfNeeded(Helper.getValueOffHeapOrDiskWithoutFaultIn(entry, region));
            if (result instanceof CachedDeserializable) {
                result = ((CachedDeserializable)result).getDeserializedValue(null, null);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Object getValueOffHeapOrDiskWithoutFaultIn(DiskEntry entry, LocalRegion region) {
            Object v = entry._getValueRetain(region, true);
            if (v == null || Token.isRemovedFromDisk(v) && !region.isIndexCreationThread()) {
                DiskEntry diskEntry = entry;
                synchronized (diskEntry) {
                    v = entry._getValueRetain(region, true);
                    if (v == null) {
                        v = Helper.getOffHeapValueOnDiskOrBuffer(entry, region.getDiskRegion(), region);
                    }
                }
            }
            if (Token.isRemovedFromDisk(v)) {
                v = null;
            }
            return v;
        }

        public static Object faultInValue(DiskEntry entry, LocalRegion region) {
            return Helper.faultInValue(entry, region, false);
        }

        public static Object faultInValueRetain(DiskEntry entry, LocalRegion region) {
            return Helper.faultInValue(entry, region, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Object faultInValue(DiskEntry entry, LocalRegion region, boolean retainResult) {
            boolean lruFaultedIn;
            Object v;
            block19: {
                DiskRegion dr = region.getDiskRegion();
                v = entry._getValueRetain(region, true);
                lruFaultedIn = false;
                boolean done = false;
                try {
                    DiskEntry diskEntry;
                    if (entry instanceof LRUEntry && !dr.isSync()) {
                        diskEntry = entry;
                        synchronized (diskEntry) {
                            DiskId did = entry.getDiskId();
                            if (did != null && did.isPendingAsync()) {
                                done = true;
                                boolean evicted = ((LRUEntry)((Object)entry)).testEvicted();
                                if (evicted) {
                                    if (!dr.isBackup()) {
                                        did.setPendingAsync(false);
                                    }
                                    dr.incNumEntriesInVM(1L);
                                    dr.incNumOverflowOnDisk(-1L);
                                    Helper.incrementBucketStats(region, 1, -1, 0);
                                }
                                Helper.lruEntryFaultIn((LRUEntry)((Object)entry), region);
                                lruFaultedIn = true;
                            }
                        }
                    }
                    if (done || v != null && (!Token.isRemovedFromDisk(v) || region.isIndexCreationThread())) break block19;
                    diskEntry = entry;
                    synchronized (diskEntry) {
                        v = entry._getValueRetain(region, true);
                        if (v == null) {
                            v = Helper.readValueFromDisk(entry, region);
                            if (entry instanceof LRUEntry && v != null && !Token.isInvalid(v)) {
                                Helper.lruEntryFaultIn((LRUEntry)((Object)entry), region);
                                lruFaultedIn = true;
                            }
                        }
                    }
                }
                finally {
                    if (!retainResult) {
                        v = OffHeapHelper.copyAndReleaseIfNeeded(v);
                    }
                }
            }
            if (Token.isRemoved(v)) {
                v = null;
            } else {
                entry.setRecentlyUsed();
            }
            if (lruFaultedIn) {
                Helper.lruUpdateCallback(region);
            }
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void recoverValue(DiskEntry entry, long oplogId, DiskRecoveryStore recoveryStore, ByteArrayDataInput in) {
            boolean lruFaultedIn = false;
            DiskEntry diskEntry = entry;
            synchronized (diskEntry) {
                DiskId did;
                if (entry.isValueNull() && (did = entry.getDiskId()) != null) {
                    Object value = null;
                    DiskRecoveryStore region = recoveryStore;
                    DiskRegionView dr = region.getDiskRegionView();
                    dr.acquireReadLock();
                    try {
                        DiskId diskId = did;
                        synchronized (diskId) {
                            if (oplogId == did.getOplogId() && (value = Helper.getValueFromDisk(dr, did, in)) != null) {
                                Helper.setValueOnFaultIn(value, did, entry, dr, region);
                            }
                        }
                    }
                    finally {
                        dr.releaseReadLock();
                    }
                    if (entry instanceof LRUEntry && value != null && !Token.isInvalid(value)) {
                        Helper.lruEntryFaultIn((LRUEntry)((Object)entry), recoveryStore);
                        lruFaultedIn = true;
                    }
                }
            }
            if (lruFaultedIn) {
                Helper.lruUpdateCallback(recoveryStore);
            }
        }

        private static Object getValueFromDisk(DiskRegionView dr, DiskId did, ByteArrayDataInput in) {
            Object value;
            if (dr.isBackup() && did.getKeyId() == 0L) {
                value = null;
            } else {
                if (did.isKeyIdNegative()) {
                    did.setKeyId(-did.getKeyId());
                }
                if ((value = dr.getRaw(did)) instanceof BytesAndBits) {
                    BytesAndBits bb = (BytesAndBits)value;
                    value = EntryBits.isInvalid(bb.getBits()) ? Token.INVALID : (EntryBits.isLocalInvalid(bb.getBits()) ? Token.LOCAL_INVALID : (EntryBits.isTombstone(bb.getBits()) ? Token.TOMBSTONE : (EntryBits.isSerialized(bb.getBits()) ? Helper.readSerializedValue(bb.getBytes(), bb.getVersion(), in, false) : Helper.readRawValue(bb.getBytes(), bb.getVersion(), in))));
                }
            }
            return value;
        }

        private static void lruUpdateCallback(DiskRecoveryStore recoveryStore) {
            try {
                if (recoveryStore.getEvictionAttributes() != null && recoveryStore.getEvictionAttributes().getAlgorithm().isLIFO()) {
                    ((VMLRURegionMap)recoveryStore.getRegionMap()).updateStats();
                    return;
                }
                recoveryStore.getRegionMap().lruUpdateCallback();
            }
            catch (DiskAccessException dae) {
                recoveryStore.handleDiskAccessException(dae);
                throw dae;
            }
        }

        private static void lruEntryFaultIn(LRUEntry entry, DiskRecoveryStore recoveryStore) {
            RegionMap rm = recoveryStore.getRegionMap();
            try {
                rm.lruEntryFaultIn(entry);
            }
            catch (DiskAccessException dae) {
                recoveryStore.handleDiskAccessException(dae);
                throw dae;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static Object readValueFromDisk(DiskEntry entry, DiskRecoveryStore region) {
            Object object;
            Object value;
            DiskRegionView dr = region.getDiskRegionView();
            DiskId did = entry.getDiskId();
            if (did == null) {
                return null;
            }
            dr.acquireReadLock();
            try {
                DiskId diskId = did;
                synchronized (diskId) {
                    value = Helper.getValueFromDisk(dr, did, null);
                    if (value == null) {
                        Object var6_6 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 7] lbl12 : MonitorExitStatement: MONITOREXIT : var4_4
                        dr.releaseReadLock();
                        return var6_6;
                    }
                }
            }
            catch (Throwable throwable) {
                dr.releaseReadLock();
                throw throwable;
            }
            {
                Object preparedValue = Helper.setValueOnFaultIn(value, did, entry, dr, region);
                object = value;
            }
            dr.releaseReadLock();
            return object;
        }

        private static Object setValueOnFaultIn(Object value, DiskId did, DiskEntry entry, DiskRegionView dr, DiskRecoveryStore region) {
            int bytesOnDisk = Helper.getValueLength(did);
            Object preparedValue = entry.prepareValueForCache((RegionEntryContext)((Object)region), value, false);
            region.updateSizeOnFaultIn(entry.getKey(), region.calculateValueSize(preparedValue), bytesOnDisk);
            entry.setValueWithContext((RegionEntryContext)((Object)region), preparedValue);
            dr.incNumEntriesInVM(1L);
            dr.incNumOverflowOnDisk(-1L);
            dr.incNumOverflowBytesOnDisk(-bytesOnDisk);
            Helper.incrementBucketStats(region, 1, -1, -bytesOnDisk);
            return preparedValue;
        }

        static Object readSerializedValue(byte[] valueBytes, Version version, ByteArrayDataInput in, boolean forceDeserialize) {
            if (forceDeserialize) {
                return EntryEventImpl.deserialize(valueBytes, version, in);
            }
            return CachedDeserializableFactory.create(valueBytes);
        }

        static Object readRawValue(byte[] valueBytes, Version version, ByteArrayDataInput in) {
            return valueBytes;
        }

        public static void incrementBucketStats(Object owner, int entriesInVmDelta, int overflowOnDiskDelta, int overflowBytesOnDiskDelta) {
            if (owner instanceof BucketRegion) {
                ((BucketRegion)owner).incNumEntriesInVM(entriesInVmDelta);
                ((BucketRegion)owner).incNumOverflowOnDisk(overflowOnDiskDelta);
                ((BucketRegion)owner).incNumOverflowBytesOnDisk(overflowBytesOnDiskDelta);
            } else if (owner instanceof DiskRegionView) {
                ((DiskRegionView)owner).incNumOverflowBytesOnDisk(overflowBytesOnDiskDelta);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int overflowToDisk(DiskEntry entry, LocalRegion region, EnableLRU ccHelper) throws RegionClearedException {
            Token entryVal = entry.getValueAsToken();
            if (entryVal == null || Token.isRemovedFromDisk(entryVal)) {
                return 0;
            }
            DiskRegion dr = region.getDiskRegion();
            int oldSize = region.calculateRegionEntryValueSize(entry);
            DiskId did = entry.getDiskId();
            if (did == null) {
                ((LRUEntry)((Object)entry)).setDelayedDiskId(region);
                did = entry.getDiskId();
            }
            int change = 0;
            boolean scheduledAsyncHere = false;
            dr.acquireReadLock();
            try {
                DiskId diskId = did;
                synchronized (diskId) {
                    block21: {
                        if (!entry.isRemovedFromDisk()) break block21;
                        int n = 0;
                        return n;
                    }
                    boolean wasAlreadyPendingAsync = did.isPendingAsync();
                    if (did.needsToBeWritten()) {
                        if (dr.isSync()) {
                            Helper.writeToDisk(entry, region, false);
                        } else if (!wasAlreadyPendingAsync) {
                            scheduledAsyncHere = true;
                            did.setPendingAsync(true);
                        }
                    }
                    boolean movedValueToDisk = false;
                    if (scheduledAsyncHere || wasAlreadyPendingAsync) {
                        change = entry.updateAsyncEntrySize(ccHelper);
                    } else {
                        region.updateSizeOnEvict(entry.getKey(), oldSize);
                        try {
                            entry.handleValueOverflow(region);
                            entry.setValueWithContext(region, null);
                        }
                        finally {
                            entry.afterValueOverflow(region);
                        }
                        movedValueToDisk = true;
                        change = ((LRUClockNode)((Object)entry)).updateEntrySize(ccHelper);
                    }
                    int valueLength = 0;
                    if (movedValueToDisk) {
                        valueLength = Helper.getValueLength(did);
                    }
                    dr.incNumEntriesInVM(-1L);
                    dr.incNumOverflowOnDisk(1L);
                    dr.incNumOverflowBytesOnDisk(valueLength);
                    Helper.incrementBucketStats(region, -1, 1, valueLength);
                }
            }
            finally {
                dr.releaseReadLock();
            }
            if (scheduledAsyncHere && did.isPendingAsync()) {
                Helper.scheduleAsyncWrite(new DiskStoreImpl.AsyncDiskEntry(region, entry, null));
            }
            return change;
        }

        private static void scheduleAsyncWrite(DiskStoreImpl.AsyncDiskEntry ade) {
            DiskRegion dr = ade.region.getDiskRegion();
            dr.scheduleAsyncWrite(ade);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static void handleFullAsyncQueue(DiskEntry entry, LocalRegion region, VersionTag tag) {
            DiskRegion dr = region.getDiskRegion();
            DiskId did = entry.getDiskId();
            DiskEntry diskEntry = entry;
            synchronized (diskEntry) {
                dr.acquireReadLock();
                try {
                    DiskId diskId = did;
                    synchronized (diskId) {
                        if (did.isPendingAsync()) {
                            boolean remove;
                            int entryValSize;
                            Token entryVal;
                            block23: {
                                did.setPendingAsync(false);
                                entryVal = entry.getValueAsToken();
                                entryValSize = region.calculateRegionEntryValueSize(entry);
                                remove = false;
                                try {
                                    if (Token.isRemovedFromDisk(entryVal)) {
                                        dr.incNumOverflowBytesOnDisk(-did.getValueLength());
                                        Helper.incrementBucketStats(region, 0, 0, -did.getValueLength());
                                        dr.remove(region, entry, true, false);
                                        if (dr.isBackup()) {
                                            did.setKeyId(0L);
                                        }
                                        remove = true;
                                        break block23;
                                    }
                                    if (Token.isInvalid(entryVal) && !dr.isBackup()) break block23;
                                    if (entryVal != null) {
                                        Helper.writeToDisk(entry, region, true);
                                        break block23;
                                    }
                                    if (tag == null) return;
                                    Helper.doAsyncFlush(tag, region);
                                }
                                catch (RegionClearedException regionClearedException) {}
                                return;
                            }
                            assert (!dr.isSync());
                            if (!remove && !Token.isInvalid(entryVal) && entry instanceof LRUEntry && ((LRUEntry)((Object)entry)).testEvicted()) {
                                region.updateSizeOnEvict(entry.getKey(), entryValSize);
                                dr.incNumOverflowBytesOnDisk(did.getValueLength());
                                Helper.incrementBucketStats(region, 0, 0, did.getValueLength());
                                try {
                                    entry.handleValueOverflow(region);
                                    entry.setValueWithContext(region, null);
                                }
                                finally {
                                    entry.afterValueOverflow(region);
                                }
                            }
                            VersionStamp stamp = entry.getVersionStamp();
                            if (tag == null) return;
                            if (stamp == null) return;
                            if (stamp.getMemberID() == tag.getMemberID()) {
                                if (stamp.getRegionVersion() == tag.getRegionVersion()) return;
                            }
                            Helper.doAsyncFlush(tag, region);
                        } else {
                            if (tag == null) return;
                            Helper.doAsyncFlush(tag, region);
                        }
                    }
                }
                finally {
                    dr.releaseReadLock();
                }
                return;
            }
        }

        public static void doAsyncFlush(VersionTag tag, LocalRegion region) {
            if (region.isThisRegionBeingClosedOrDestroyed()) {
                return;
            }
            DiskRegion dr = region.getDiskRegion();
            if (!dr.isBackup()) {
                return;
            }
            assert (!dr.isSync());
            dr.acquireReadLock();
            try {
                dr.getDiskStore().putVersionTagOnly(region, tag, true);
            }
            finally {
                dr.releaseReadLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public static void doAsyncFlush(DiskEntry entry, LocalRegion region, VersionTag tag) {
            if (region.isThisRegionBeingClosedOrDestroyed()) {
                return;
            }
            DiskRegion dr = region.getDiskRegion();
            dr.setClearCountReference();
            DiskEntry diskEntry = entry;
            // MONITORENTER : diskEntry
            try {
                DiskId did;
                dr.acquireReadLock();
                DiskId diskId = did = entry.getDiskId();
                // MONITORENTER : diskId
                if (did.isPendingAsync()) {
                    block32: {
                        boolean remove;
                        int entryValSize;
                        Token entryVal;
                        block31: {
                            did.setPendingAsync(false);
                            entryVal = entry.getValueAsToken();
                            entryValSize = region.calculateRegionEntryValueSize(entry);
                            remove = false;
                            if (Token.isRemovedFromDisk(entryVal)) {
                                if (region.isThisRegionBeingClosedOrDestroyed()) {
                                    // MONITOREXIT : diskId
                                    dr.releaseReadLock();
                                    return;
                                }
                                dr.incNumOverflowBytesOnDisk(-did.getValueLength());
                                Helper.incrementBucketStats(region, 0, 0, -did.getValueLength());
                                dr.remove(region, entry, true, false);
                                if (dr.isBackup()) {
                                    did.setKeyId(0L);
                                }
                                remove = true;
                                break block31;
                            }
                            if ((Token.isInvalid(entryVal) || entryVal == Token.TOMBSTONE) && !dr.isBackup()) break block31;
                            if (entryVal != null) {
                                Helper.writeToDisk(entry, region, true);
                                break block31;
                            }
                            if (tag != null) {
                                Helper.doAsyncFlush(tag, region);
                            }
                            // MONITOREXIT : diskId
                            dr.releaseReadLock();
                            return;
                        }
                        try {
                            assert (!dr.isSync());
                            if (remove || Token.isInvalid(entryVal) || entryVal == Token.TOMBSTONE || !(entry instanceof LRUEntry) || !((LRUEntry)((Object)entry)).testEvicted()) break block32;
                            region.updateSizeOnEvict(entry.getKey(), entryValSize);
                            dr.incNumOverflowBytesOnDisk(did.getValueLength());
                            Helper.incrementBucketStats(region, 0, 0, did.getValueLength());
                            try {
                                entry.handleValueOverflow(region);
                                entry.setValueWithContext(region, null);
                            }
                            finally {
                                entry.afterValueOverflow(region);
                            }
                        }
                        catch (RegionClearedException regionClearedException) {
                            // empty catch block
                        }
                    }
                    VersionStamp stamp = entry.getVersionStamp();
                    if (tag == null || stamp == null || stamp.getMemberID() == tag.getMemberID() && stamp.getRegionVersion() == tag.getRegionVersion()) return;
                    Helper.doAsyncFlush(tag, region);
                    return;
                }
                if (tag != null) {
                    Helper.doAsyncFlush(tag, region);
                }
                // MONITOREXIT : diskId
                return;
            }
            finally {
                dr.removeClearCountReference();
            }
        }

        public static void removeFromDisk(DiskEntry entry, LocalRegion region, boolean isClear) throws RegionClearedException {
            Helper.removeFromDisk(entry, region, true, false, isClear);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void removeFromDisk(DiskEntry entry, LocalRegion region, boolean checkValue, boolean valueWasNull, boolean isClear) throws RegionClearedException {
            DiskRegion dr = region.getDiskRegion();
            boolean maintainRVV = region.concurrencyChecksEnabled && dr.isBackup();
            DiskId did = entry.getDiskId();
            VersionTag tag = null;
            Object syncObj = did;
            if (did == null) {
                syncObj = entry;
            }
            boolean scheduledAsyncHere = false;
            if (syncObj == did) {
                dr.acquireReadLock();
            }
            try {
                Object object = syncObj;
                synchronized (object) {
                    block21: {
                        if (did != null && (!dr.isBackup() || did.getKeyId() != 0L)) break block21;
                        dr.incNumEntriesInVM(-1L);
                        Helper.incrementBucketStats(region, -1, 0, 0);
                        dr.unscheduleAsyncWrite(did);
                        return;
                    }
                    did.unmarkForWriting();
                    int oldValueLength = 0;
                    if (dr.isSync() || isClear) {
                        oldValueLength = did.getValueLength();
                        dr.remove(region, entry, false, isClear);
                        if (dr.isBackup()) {
                            did.setKeyId(0L);
                        }
                        did.setPendingAsync(false);
                    } else if (!did.isPendingAsync() || maintainRVV) {
                        scheduledAsyncHere = true;
                        did.setPendingAsync(true);
                        VersionStamp stamp = entry.getVersionStamp();
                        if (stamp != null) {
                            tag = stamp.asVersionTag();
                        }
                    }
                    if (checkValue) {
                        valueWasNull = entry.isValueNull();
                        entry._removePhase1();
                    }
                    if (valueWasNull) {
                        dr.incNumOverflowOnDisk(-1L);
                        dr.incNumOverflowBytesOnDisk(-oldValueLength);
                        Helper.incrementBucketStats(region, 0, -1, -oldValueLength);
                    } else {
                        dr.incNumEntriesInVM(-1L);
                        Helper.incrementBucketStats(region, -1, 0, 0);
                        if (!dr.isSync()) {
                            did.setValueLength(0);
                        }
                    }
                }
            }
            finally {
                if (syncObj == did) {
                    dr.releaseReadLock();
                }
            }
            if (scheduledAsyncHere && did.isPendingAsync()) {
                Helper.scheduleAsyncWrite(new DiskStoreImpl.AsyncDiskEntry(region, entry, tag));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void updateVersionOnly(DiskEntry entry, LocalRegion region, VersionTag tag) {
            DiskRegion dr = region.getDiskRegion();
            if (!dr.isBackup()) {
                return;
            }
            assert (tag != null && tag.getMemberID() != null);
            boolean scheduleAsync = false;
            DiskId did = entry.getDiskId();
            Object syncObj = did;
            if (syncObj == null) {
                syncObj = entry;
            }
            if (syncObj == did) {
                dr.acquireReadLock();
            }
            try {
                Object object = syncObj;
                synchronized (object) {
                    if (dr.isSync()) {
                        dr.getDiskStore().putVersionTagOnly(region, tag, false);
                    } else {
                        scheduleAsync = true;
                    }
                }
            }
            finally {
                if (syncObj == did) {
                    dr.releaseReadLock();
                }
            }
            if (scheduleAsync) {
                Helper.scheduleAsyncWrite(new DiskStoreImpl.AsyncDiskEntry(region, tag));
            }
        }

        public static class OffHeapValueWrapper
        implements ValueWrapper {
            private final StoredObject offHeapData;

            public OffHeapValueWrapper(StoredObject so) {
                assert (so.hasRefCount());
                assert (!so.isCompressed());
                this.offHeapData = so;
            }

            @Override
            public boolean isSerialized() {
                return this.offHeapData.isSerialized();
            }

            @Override
            public int getLength() {
                return this.offHeapData.getDataSize();
            }

            @Override
            public byte getUserBits() {
                byte userBits = 0;
                if (this.isSerialized()) {
                    userBits = EntryBits.setSerialized(userBits, true);
                }
                return userBits;
            }

            @Override
            public void sendTo(ByteBuffer bb, Flushable flushable) throws IOException {
                ByteBuffer chunkbb;
                int maxOffset = this.getLength();
                if (maxOffset == 0) {
                    return;
                }
                if (maxOffset > bb.capacity() && (chunkbb = this.offHeapData.createDirectByteBuffer()) != null) {
                    flushable.flush(bb, chunkbb);
                    return;
                }
                long bbAddress = AddressableMemoryManager.getDirectByteBufferAddress(bb);
                if (bbAddress != 0L) {
                    int bytesRemaining = maxOffset;
                    int availableSpace = bb.remaining();
                    long addrToWrite = bbAddress + (long)bb.position();
                    long addrToRead = this.offHeapData.getAddressForReadingData(0, maxOffset);
                    if (bytesRemaining > availableSpace) {
                        do {
                            AddressableMemoryManager.copyMemory(addrToRead, addrToWrite, availableSpace);
                            bb.position(bb.position() + availableSpace);
                            addrToRead += (long)availableSpace;
                            flushable.flush();
                            addrToWrite = bbAddress + (long)bb.position();
                        } while ((bytesRemaining -= availableSpace) > (availableSpace = bb.remaining()));
                    }
                    AddressableMemoryManager.copyMemory(addrToRead, addrToWrite, bytesRemaining);
                    bb.position(bb.position() + bytesRemaining);
                } else {
                    long addr;
                    long endAddr = addr + (long)maxOffset;
                    for (addr = this.offHeapData.getAddressForReadingData(0, maxOffset); addr != endAddr; ++addr) {
                        bb.put(AddressableMemoryManager.readByte(addr));
                        if (bb.hasRemaining()) continue;
                        flushable.flush();
                    }
                }
            }

            @Override
            public String getBytesAsString() {
                return this.offHeapData.getStringForm();
            }
        }

        public static class CompactorValueWrapper
        extends ByteArrayValueWrapper {
            private final int length;

            public CompactorValueWrapper(byte[] bytes, int length) {
                super(false, bytes);
                this.length = length;
            }

            @Override
            public boolean isSerialized() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLength() {
                return this.length;
            }

            @Override
            public byte getUserBits() {
                throw new UnsupportedOperationException();
            }
        }

        public static class ByteArrayValueWrapper
        implements ValueWrapper {
            public final boolean isSerializedObject;
            public final byte[] bytes;

            public ByteArrayValueWrapper(boolean isSerializedObject, byte[] bytes) {
                this.isSerializedObject = isSerializedObject;
                this.bytes = bytes;
            }

            @Override
            public boolean isSerialized() {
                return this.isSerializedObject;
            }

            @Override
            public int getLength() {
                return this.bytes != null ? this.bytes.length : 0;
            }

            private boolean isInvalidToken() {
                return this == INVALID_VW;
            }

            private boolean isLocalInvalidToken() {
                return this == LOCAL_INVALID_VW;
            }

            private boolean isTombstoneToken() {
                return this == TOMBSTONE_VW;
            }

            @Override
            public byte getUserBits() {
                byte userBits = 0;
                if (this.isSerialized()) {
                    if (this.isTombstoneToken()) {
                        userBits = EntryBits.setTombstone(userBits, true);
                    } else if (this.isInvalidToken()) {
                        userBits = EntryBits.setInvalid(userBits, true);
                    } else if (this.isLocalInvalidToken()) {
                        userBits = EntryBits.setLocalInvalid(userBits, true);
                    } else {
                        if (this.bytes == null) {
                            throw new IllegalStateException("userBits==1 and value is null");
                        }
                        if (this.bytes.length == 0) {
                            throw new IllegalStateException("userBits==1 and value is zero length");
                        }
                        userBits = EntryBits.setSerialized(userBits, true);
                    }
                }
                return userBits;
            }

            @Override
            public void sendTo(ByteBuffer bb, Flushable flushable) throws IOException {
                int bytesThisTime;
                int maxOffset = this.getLength();
                for (int offset = 0; offset < maxOffset; offset += bytesThisTime) {
                    bytesThisTime = maxOffset - offset;
                    boolean needsFlush = false;
                    if (bytesThisTime > bb.remaining()) {
                        needsFlush = true;
                        bytesThisTime = bb.remaining();
                    }
                    bb.put(this.bytes, offset, bytesThisTime);
                    if (!needsFlush) continue;
                    flushable.flush();
                }
            }

            @Override
            public String getBytesAsString() {
                if (this.bytes == null) {
                    return "null";
                }
                StringBuffer sb = new StringBuffer();
                int len = this.getLength();
                for (int i = 0; i < len; ++i) {
                    sb.append(this.bytes[i]).append(", ");
                }
                return sb.toString();
            }
        }

        public static interface Flushable {
            public void flush() throws IOException;

            public void flush(ByteBuffer var1, ByteBuffer var2) throws IOException;
        }

        public static interface ValueWrapper {
            public boolean isSerialized();

            public int getLength();

            public byte getUserBits();

            public void sendTo(ByteBuffer var1, Flushable var2) throws IOException;

            public String getBytesAsString();
        }
    }
}

