/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.internal.ConflationKey;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.DistributedCacheOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.QueuedOperation;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.versions.ConcurrentCacheModificationException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class DestroyOperation
extends DistributedCacheOperation {
    public DestroyOperation(EntryEventImpl event) {
        super(event);
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        if (this.event.hasClientOrigin()) {
            DestroyWithContextMessage msgwithContxt = new DestroyWithContextMessage(this.event);
            msgwithContxt.context = ((EntryEventImpl)this.event).getContext();
            return msgwithContxt;
        }
        return new DestroyMessage(this.event);
    }

    @Override
    protected void initMessage(DistributedCacheOperation.CacheOperationMessage msg, DirectReplyProcessor processor) {
        super.initMessage(msg, processor);
        DestroyMessage m = (DestroyMessage)msg;
        EntryEventImpl event = this.getEvent();
        m.key = event.getKey();
        m.eventId = event.getEventId();
    }

    public static final class DestroyWithContextMessage
    extends DestroyMessage {
        transient ClientProxyMembershipID context;

        public DestroyWithContextMessage() {
        }

        public DestroyWithContextMessage(InternalCacheEvent event) {
            super(event);
        }

        @Override
        EntryEventImpl createEntryEvent(DistributedRegion rgn) {
            EntryEventImpl event = EntryEventImpl.create(rgn, this.getOperation(), this.key, null, this.callbackArg, true, this.getSender(), true);
            event.setContext(this.context);
            return event;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; membershipID=");
            buff.append(this.context == null ? "" : this.context.toString());
        }

        @Override
        public int getDSFID() {
            return 127;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.context = ClientProxyMembershipID.readCanonicalized(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.context, out);
        }
    }

    public static class DestroyMessage
    extends DistributedCacheOperation.CacheOperationMessage {
        protected EventID eventId = null;
        protected Object key;
        protected EntryEventImpl event = null;
        private Long tailKey = 0L;

        public DestroyMessage() {
        }

        public DestroyMessage(InternalCacheEvent event) {
            this.event = (EntryEventImpl)event;
        }

        @Override
        protected boolean operateOnRegion(CacheEvent event, DistributionManager dm) throws EntryNotFoundException {
            EntryEventImpl ev = (EntryEventImpl)event;
            DistributedRegion rgn = (DistributedRegion)ev.region;
            try {
                if (!rgn.isCacheContentProxy()) {
                    rgn.basicDestroy(ev, false, null);
                }
                this.appliedOperation = true;
            }
            catch (ConcurrentCacheModificationException e) {
                this.dispatchElidedEvent(rgn, ev);
                return true;
            }
            catch (EntryNotFoundException e) {
                this.dispatchElidedEvent(rgn, ev);
                if (!ev.isConcurrencyConflict()) {
                    rgn.notifyGatewaySender(EnumListenerEvent.AFTER_DESTROY, ev);
                }
                throw e;
            }
            catch (CacheWriterException e) {
                throw new Error(LocalizedStrings.DestroyOperation_CACHEWRITER_SHOULD_NOT_BE_CALLED.toLocalizedString(), e);
            }
            catch (TimeoutException e) {
                throw new Error(LocalizedStrings.DestroyOperation_DISTRIBUTEDLOCK_SHOULD_NOT_BE_ACQUIRED.toLocalizedString(), e);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            if (rgn.keyRequiresRegionContext()) {
                ((KeyWithRegionContext)this.key).setRegionContext(rgn);
            }
            EntryEventImpl ev = this.createEntryEvent(rgn);
            boolean evReturned = false;
            try {
                ev.setEventId(this.eventId);
                ev.setOldValueFromRegion();
                ev.setVersionTag(this.versionTag);
                if (this.filterRouting != null) {
                    ev.setLocalFilterInfo(this.filterRouting.getFilterInfo(rgn.getMyId()));
                }
                ev.setTailKey(this.tailKey);
                ev.setInhibitAllNotifications(this.inhibitAllNotifications);
                evReturned = true;
                EntryEventImpl entryEventImpl = ev;
                return entryEventImpl;
            }
            finally {
                if (!evReturned) {
                    ev.release();
                }
            }
        }

        EntryEventImpl createEntryEvent(DistributedRegion rgn) {
            EntryEventImpl event = EntryEventImpl.create((LocalRegion)rgn, this.getOperation(), this.key, null, this.callbackArg, true, this.getSender());
            this.setOldValueInEvent(event);
            event.setTailKey(this.tailKey);
            return event;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append(" key=").append(this.key).append(" id=").append(this.eventId);
        }

        @Override
        public int getDSFID() {
            return 102;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.eventId = (EventID)DataSerializer.readObject(in);
            this.key = DataSerializer.readObject(in);
            Boolean hasTailKey = DataSerializer.readBoolean(in);
            if (hasTailKey.booleanValue()) {
                this.tailKey = DataSerializer.readLong(in);
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.eventId, out);
            DataSerializer.writeObject(this.key, out);
            DistributedRegion region = (DistributedRegion)this.event.getRegion();
            if (region instanceof BucketRegion) {
                PartitionedRegion pr = region.getPartitionedRegion();
                if (pr.isParallelWanEnabled()) {
                    DataSerializer.writeBoolean(Boolean.TRUE, out);
                    DataSerializer.writeLong(this.event.getTailKey(), out);
                } else {
                    DataSerializer.writeBoolean(Boolean.FALSE, out);
                }
            } else if (region.isUsedForSerialGatewaySenderQueue()) {
                DataSerializer.writeBoolean(Boolean.TRUE, out);
                DataSerializer.writeLong(this.event.getTailKey(), out);
            } else {
                DataSerializer.writeBoolean(Boolean.FALSE, out);
            }
        }

        @Override
        public EventID getEventID() {
            return this.eventId;
        }

        @Override
        public List getOperations() {
            return Collections.singletonList(new QueuedOperation(this.getOperation(), this.key, null, null, 0, this.callbackArg));
        }

        @Override
        public ConflationKey getConflationKey() {
            if (!this.regionAllowsConflation || this.getProcessorId() != 0) {
                return null;
            }
            return new ConflationKey(this.key, this.regionPath, false);
        }

        @Override
        protected boolean mayAddToMultipleSerialGateways(DistributionManager dm) {
            return this._mayAddToMultipleSerialGateways(dm);
        }
    }
}

