/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalDataSet;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionRegionConfig;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.execute.InternalRegionFunctionContext;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.persistence.PRPersistentConfig;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ColocationHelper {
    private static final Logger logger = LogService.getLogger();
    public static boolean IGNORE_UNRECOVERED_QUEUE = Boolean.getBoolean("gemfire.IGNORE_UNRECOVERED_QUEUE");

    public static PartitionedRegion getColocatedRegionName(PartitionedRegion partitionedRegion) {
        PartitionedRegion colocatedPR;
        block7: {
            Assert.assertTrue(partitionedRegion != null);
            String colocatedWith = partitionedRegion.getPartitionAttributes().getColocatedWith();
            if (colocatedWith == null) {
                return null;
            }
            colocatedPR = partitionedRegion.getColocatedWithRegion();
            if (colocatedPR != null && !colocatedPR.isLocallyDestroyed && !colocatedPR.isDestroyed()) {
                return colocatedPR;
            }
            LocalRegion prRoot = PartitionedRegionHelper.getPRRoot(partitionedRegion.getCache());
            PartitionRegionConfig prConf = (PartitionRegionConfig)prRoot.get(ColocationHelper.getRegionIdentifier(colocatedWith));
            int prID = -1;
            try {
                if (prConf == null) {
                    colocatedPR = ColocationHelper.getColocatedPR(partitionedRegion, colocatedWith);
                } else {
                    prID = prConf.getPRId();
                    colocatedPR = PartitionedRegion.getPRFromId(prID);
                    if (colocatedPR == null && prID > 0) {
                        colocatedPR = ColocationHelper.getColocatedPR(partitionedRegion, colocatedWith);
                    }
                }
            }
            catch (PRLocallyDestroyedException e) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug("PRLocallyDestroyedException : Region with prId=" + prID + " is locally destroyed on this node", (Throwable)e);
            }
        }
        return colocatedPR;
    }

    private static PartitionedRegion getColocatedPR(PartitionedRegion partitionedRegion, String colocatedWith) {
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.HOPLOG_0_COLOCATE_WITH_REGION_1_NOT_INITIALIZED_YET, new Object[]{partitionedRegion.getFullPath(), colocatedWith}));
        PartitionedRegion colocatedPR = (PartitionedRegion)partitionedRegion.getCache().getPartitionedRegion(colocatedWith, false);
        assert (colocatedPR != null);
        return colocatedPR;
    }

    public static PartitionedRegion getColocatedRegion(PartitionedRegion partitionedRegion) {
        PartitionedRegion colocatedPR;
        block3: {
            Assert.assertTrue(partitionedRegion != null);
            String colocatedWith = partitionedRegion.getPartitionAttributes().getColocatedWith();
            if (colocatedWith == null) {
                return null;
            }
            LocalRegion prRoot = PartitionedRegionHelper.getPRRoot(partitionedRegion.getCache());
            PartitionRegionConfig prConf = (PartitionRegionConfig)prRoot.get(ColocationHelper.getRegionIdentifier(colocatedWith));
            int prID = prConf.getPRId();
            colocatedPR = null;
            try {
                colocatedPR = PartitionedRegion.getPRFromId(prID);
                colocatedPR.waitOnBucketMetadataInitialization();
            }
            catch (PRLocallyDestroyedException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("PRLocallyDestroyedException : Region with prId={} is locally destroyed on this node", new Object[]{prID, e});
            }
        }
        return colocatedPR;
    }

    public static boolean checkMembersColocation(PartitionedRegion partitionedRegion, InternalDistributedMember member) {
        String colocatedWithRegionName;
        ArrayList colocatedRegions = new ArrayList();
        ArrayList<PartitionRegionConfig> tempcolocatedRegions = new ArrayList<PartitionRegionConfig>();
        LocalRegion prRoot = PartitionedRegionHelper.getPRRoot(partitionedRegion.getCache());
        PartitionRegionConfig regionConfig = (PartitionRegionConfig)prRoot.get(partitionedRegion.getRegionIdentifier());
        if (regionConfig == null) {
            return false;
        }
        tempcolocatedRegions.add(regionConfig);
        colocatedRegions.addAll(tempcolocatedRegions);
        PartitionRegionConfig prConf = null;
        do {
            PartitionRegionConfig tempToBeColocatedWith = (PartitionRegionConfig)tempcolocatedRegions.remove(0);
            for (String prName : prRoot.keySet()) {
                try {
                    prConf = (PartitionRegionConfig)prRoot.get(prName);
                }
                catch (EntryDestroyedException ede) {
                    continue;
                }
                if (prConf == null || prConf.getColocatedWith() == null || !prConf.getColocatedWith().equals(tempToBeColocatedWith.getFullPath()) && !("/" + prConf.getColocatedWith()).equals(tempToBeColocatedWith.getFullPath())) continue;
                colocatedRegions.add(prConf);
                tempcolocatedRegions.add(prConf);
            }
        } while (!tempcolocatedRegions.isEmpty());
        PartitionRegionConfig tempColocatedWith = regionConfig;
        prConf = null;
        while ((colocatedWithRegionName = tempColocatedWith.getColocatedWith()) != null) {
            prConf = (PartitionRegionConfig)prRoot.get(ColocationHelper.getRegionIdentifier(colocatedWithRegionName));
            if (prConf == null) break;
            colocatedRegions.add(tempColocatedWith);
            tempColocatedWith = prConf;
        }
        for (PartitionRegionConfig config : colocatedRegions) {
            if (!config.isColocationComplete() || config.containsMember(member)) continue;
            return false;
        }
        return !ColocationHelper.hasOfflineColocatedChildRegions(partitionedRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasOfflineColocatedChildRegions(PartitionedRegion region) {
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
        try {
            GemFireCacheImpl cache = region.getCache();
            Collection<DiskStoreImpl> stores = cache.listDiskStores();
            for (DiskStoreImpl diskStore : stores) {
                for (Map.Entry<String, PRPersistentConfig> entry : diskStore.getAllPRs().entrySet()) {
                    PRPersistentConfig config = entry.getValue();
                    String childName = entry.getKey();
                    if (!region.getFullPath().equals(config.getColocatedWith())) continue;
                    PartitionedRegion childRegion = (PartitionedRegion)cache.getRegion(childName);
                    if (childRegion == null) {
                        if (ColocationHelper.ignoreUnrecoveredQueue(region, childName)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    if (!ColocationHelper.hasOfflineColocatedChildRegions(childRegion)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
        return false;
    }

    private static boolean ignoreUnrecoveredQueue(PartitionedRegion region, String childName) {
        if (!ParallelGatewaySenderQueue.isParallelQueue(childName)) {
            return false;
        }
        String senderId = ParallelGatewaySenderQueue.getSenderId(childName);
        return !region.getAsyncEventQueueIds().contains(senderId) && !region.getParallelGatewaySenderIds().contains(senderId) && IGNORE_UNRECOVERED_QUEUE;
    }

    public static boolean isColocationComplete(PartitionedRegion region) {
        LocalRegion prRoot = PartitionedRegionHelper.getPRRoot(region.getCache());
        PartitionRegionConfig config = (PartitionRegionConfig)prRoot.get(region.getRegionIdentifier());
        if (config == null) {
            Assert.assertTrue(region.isDestroyed() || region.isClosed, "Region is not destroyed, but there is no entry in the prRoot for region " + region);
            return false;
        }
        return config.isColocationComplete();
    }

    public static Map<String, PartitionedRegion> getAllColocationRegions(PartitionedRegion partitionedRegion) {
        PartitionedRegion colocatedWithRegion;
        HashMap<String, PartitionedRegion> colocatedRegions = new HashMap<String, PartitionedRegion>();
        List<PartitionedRegion> colocatedByRegion = partitionedRegion.getColocatedByList();
        if (colocatedByRegion.size() != 0) {
            ArrayList<PartitionedRegion> tempcolocatedRegions = new ArrayList<PartitionedRegion>();
            tempcolocatedRegions.addAll(colocatedByRegion);
            do {
                PartitionedRegion pRegion = (PartitionedRegion)tempcolocatedRegions.remove(0);
                pRegion.waitOnBucketMetadataInitialization();
                colocatedRegions.put(pRegion.getFullPath(), pRegion);
                tempcolocatedRegions.addAll(pRegion.getColocatedByList());
            } while (!tempcolocatedRegions.isEmpty());
        }
        PartitionedRegion tempColocatedWith = partitionedRegion;
        while ((colocatedWithRegion = tempColocatedWith.getColocatedWithRegion()) != null) {
            colocatedRegions.put(colocatedWithRegion.getFullPath(), colocatedWithRegion);
            tempColocatedWith = colocatedWithRegion;
        }
        return colocatedRegions;
    }

    public static Map<String, Region> getAllColocatedLocalDataSets(PartitionedRegion partitionedRegion, InternalRegionFunctionContext context) {
        Map<String, PartitionedRegion> colocatedRegions = ColocationHelper.getAllColocationRegions(partitionedRegion);
        HashMap<String, Region> colocatedLocalRegions = new HashMap<String, Region>();
        for (Map.Entry<String, PartitionedRegion> me : colocatedRegions.entrySet()) {
            Region pr = me.getValue();
            colocatedLocalRegions.put(me.getKey(), context.getLocalDataSet(pr));
        }
        return colocatedLocalRegions;
    }

    public static Map<String, LocalDataSet> constructAndGetAllColocatedLocalDataSet(PartitionedRegion region, Set<Integer> bucketSet) {
        HashMap<String, LocalDataSet> colocatedLocalDataSets = new HashMap<String, LocalDataSet>();
        if (region.getColocatedWith() == null && !region.isColocatedBy()) {
            colocatedLocalDataSets.put(region.getFullPath(), new LocalDataSet(region, bucketSet));
            return colocatedLocalDataSets;
        }
        Map<String, PartitionedRegion> colocatedRegions = ColocationHelper.getAllColocationRegions(region);
        for (Region region2 : colocatedRegions.values()) {
            colocatedLocalDataSets.put(region2.getFullPath(), new LocalDataSet((PartitionedRegion)region2, bucketSet));
        }
        colocatedLocalDataSets.put(region.getFullPath(), new LocalDataSet(region, bucketSet));
        return colocatedLocalDataSets;
    }

    public static Map<String, LocalDataSet> getColocatedLocalDataSetsForBuckets(PartitionedRegion region, Set<Integer> bucketSet) {
        if (region.getColocatedWith() == null && !region.isColocatedBy()) {
            return Collections.emptyMap();
        }
        HashMap<String, LocalDataSet> ret = new HashMap<String, LocalDataSet>();
        Map<String, PartitionedRegion> colocatedRegions = ColocationHelper.getAllColocationRegions(region);
        for (Region region2 : colocatedRegions.values()) {
            ret.put(region2.getFullPath(), new LocalDataSet((PartitionedRegion)region2, bucketSet));
        }
        return ret;
    }

    public static List<PartitionedRegion> getColocatedChildRegions(PartitionedRegion partitionedRegion) {
        ArrayList<PartitionedRegion> colocatedChildRegions = new ArrayList<PartitionedRegion>();
        LocalRegion prRoot = PartitionedRegionHelper.getPRRoot(partitionedRegion.getCache());
        PartitionRegionConfig prConf = null;
        Iterator itr = prRoot.keySet().iterator();
        while (itr.hasNext()) {
            try {
                int prID;
                PartitionedRegion prRegion;
                String prName = (String)itr.next();
                try {
                    prConf = (PartitionRegionConfig)prRoot.get(prName);
                }
                catch (EntryDestroyedException ede) {
                    continue;
                }
                if (prConf == null || (prRegion = PartitionedRegion.getPRFromId(prID = prConf.getPRId())) == null || prRegion.getColocatedWith() == null || !prRegion.getColocatedWith().equals(partitionedRegion.getFullPath()) && !("/" + prRegion.getColocatedWith()).equals(partitionedRegion.getFullPath())) continue;
                prRegion.waitOnBucketMetadataInitialization();
                colocatedChildRegions.add(prRegion);
            }
            catch (PRLocallyDestroyedException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("PRLocallyDestroyedException : Region ={} is locally destroyed on this node", new Object[]{prConf.getPRId(), e});
            }
            catch (RegionDestroyedException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("RegionDestroyedException : Region ={} is destroyed.", new Object[]{prConf.getPRId(), e});
            }
        }
        Collections.sort(colocatedChildRegions, new Comparator<PartitionedRegion>(){

            @Override
            public int compare(PartitionedRegion o1, PartitionedRegion o2) {
                if (o1.isShadowPR() == o2.isShadowPR()) {
                    return o1.getFullPath().compareTo(o2.getFullPath());
                }
                if (o1.isShadowPR()) {
                    return 1;
                }
                return -1;
            }
        });
        return colocatedChildRegions;
    }

    public static Function getFunctionInstance(Serializable function) {
        Function functionInstance = null;
        if (function instanceof String) {
            functionInstance = FunctionService.getFunction((String)((Object)function));
            Assert.assertTrue(functionInstance != null, "Function " + function + " is not registered on this node ");
        } else {
            functionInstance = (Function)function;
        }
        return functionInstance;
    }

    public static PartitionedRegion getLeaderRegion(PartitionedRegion prRegion) {
        PartitionedRegion parentRegion;
        while ((parentRegion = ColocationHelper.getColocatedRegion(prRegion)) != null) {
            prRegion = parentRegion;
        }
        return prRegion;
    }

    public static PartitionedRegion getLeaderRegionName(PartitionedRegion prRegion) {
        PartitionedRegion parentRegion;
        while ((parentRegion = ColocationHelper.getColocatedRegionName(prRegion)) != null) {
            prRegion = parentRegion;
        }
        return prRegion;
    }

    private static String getRegionIdentifier(String regionName) {
        if (regionName.startsWith("/")) {
            return regionName.replace("/", "#");
        }
        return "#" + regionName.replace("/", "#");
    }

    public static boolean hasPersistentChildRegion(PartitionedRegion region) {
        for (PartitionedRegion child : ColocationHelper.getColocatedChildRegions(region)) {
            if (!child.getDataPolicy().withPersistence()) continue;
            return true;
        }
        return false;
    }
}

