/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public final class CloseCacheMessage
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private int processorId;

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        boolean systemError = false;
        try {
            try {
                PartitionedRegionHelper.cleanUpMetaDataOnNodeFailure(this.getSender());
            }
            catch (VirtualMachineError err) {
                systemError = true;
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                if (logger.isDebugEnabled()) {
                    logger.debug("Throwable caught while processing cache close message from:{}", new Object[]{this.getSender(), t});
                }
            }
        }
        finally {
            if (!systemError) {
                ReplyMessage.send(this.getSender(), this.processorId, null, dm, false, false, true);
            }
        }
    }

    public void setProcessorId(int id) {
        this.processorId = id;
    }

    @Override
    public String toString() {
        return super.toString() + " (processorId=" + this.processorId + ")";
    }

    @Override
    public int getDSFID() {
        return 91;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
    }
}

