/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.SerialDistributionMessage;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.FilterProfile;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class AddCacheServerProfileMessage
extends SerialDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    int processorId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
        try {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache != null && !cache.isClosed()) {
                this.operateOnCache(cache);
            }
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
            ReplyMessage reply = new ReplyMessage();
            reply.setProcessorId(this.processorId);
            reply.setRecipient(this.getSender());
            try {
                dm.putOutgoing(reply);
            }
            catch (CancelException cancelException) {}
        }
    }

    private void operateOnCache(GemFireCacheImpl cache) {
        CacheDistributionAdvisor.CacheProfile cp;
        CacheDistributionAdvisor cda;
        boolean isDebugEnabled = logger.isDebugEnabled();
        for (DistributedRegion distributedRegion : this.getDistributedRegions(cache)) {
            cda = distributedRegion.getDistributionAdvisor();
            cp = (CacheDistributionAdvisor.CacheProfile)cda.getProfile(this.getSender());
            if (cp == null) continue;
            if (isDebugEnabled) {
                logger.debug("Setting hasCacheServer flag on region \"{}\" for {}", new Object[]{distributedRegion.getFullPath(), this.getSender()});
            }
            cp.hasCacheServer = true;
        }
        for (PartitionedRegion partitionedRegion : this.getPartitionedRegions(cache)) {
            cda = (CacheDistributionAdvisor)partitionedRegion.getDistributionAdvisor();
            cp = (CacheDistributionAdvisor.CacheProfile)cda.getProfile(this.getSender());
            if (cp == null) continue;
            if (isDebugEnabled) {
                logger.debug("Setting hasCacheServer flag on region \"{}\" for {}", new Object[]{partitionedRegion.getFullPath(), this.getSender()});
            }
            cp.hasCacheServer = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operateOnLocalCache(GemFireCacheImpl cache) {
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
        try {
            FilterProfile fp;
            for (LocalRegion localRegion : this.getAllRegions(cache)) {
                fp = localRegion.getFilterProfile();
                if (fp == null) continue;
                fp.getLocalProfile().hasCacheServer = true;
            }
            for (PartitionedRegion partitionedRegion : this.getPartitionedRegions(cache)) {
                fp = partitionedRegion.getFilterProfile();
                if (fp == null) continue;
                fp.getLocalProfile().hasCacheServer = true;
            }
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
    }

    private Set<LocalRegion> getAllRegions(GemFireCacheImpl gfc) {
        return gfc.getAllRegions();
    }

    private Set<DistributedRegion> getDistributedRegions(GemFireCacheImpl gfc) {
        HashSet<DistributedRegion> result = new HashSet<DistributedRegion>();
        for (LocalRegion r : gfc.getAllRegions()) {
            if (!(r instanceof DistributedRegion)) continue;
            result.add((DistributedRegion)r);
        }
        return result;
    }

    private Set<PartitionedRegion> getPartitionedRegions(GemFireCacheImpl gfc) {
        HashSet<PartitionedRegion> result = new HashSet<PartitionedRegion>(gfc.getPartitionedRegions());
        return result;
    }

    @Override
    public int getDSFID() {
        return -118;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
    }

    @Override
    public String toString() {
        return this.getShortClassName() + "(processorId=" + this.processorId + ")";
    }
}

