/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminRegion;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.CacheDisplay;
import com.gemstone.gemfire.internal.admin.remote.RemoteGemFireVM;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;

public final class RootRegionResponse
extends AdminResponse {
    private String[] regions;
    private String[] userAttrs;

    public static RootRegionResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        RootRegionResponse m = new RootRegionResponse();
        try {
            Cache cache = CacheFactory.getInstance(dm.getSystem());
            Set roots = !Boolean.getBoolean("gemfire.PRDebug") ? cache.rootRegions() : ((GemFireCacheImpl)cache).rootRegions(true);
            ArrayList<String> regionNames = new ArrayList<String>();
            ArrayList<Object> userAttributes = new ArrayList<Object>();
            for (Region r : roots) {
                regionNames.add(r.getName());
                userAttributes.add(CacheDisplay.getCachedObjectDisplay(r.getUserAttribute(), 100));
            }
            String[] temp = new String[]{};
            m.regions = regionNames.toArray(temp);
            m.userAttrs = userAttributes.toArray(temp);
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        m.setRecipient(recipient);
        return m;
    }

    public Region[] getRegions(RemoteGemFireVM vm) {
        if (this.regions.length > 0) {
            Region[] roots = new Region[this.regions.length];
            for (int i = 0; i < this.regions.length; ++i) {
                roots[i] = new AdminRegion(this.regions[i], vm, this.userAttrs[i]);
            }
            return roots;
        }
        return new Region[0];
    }

    @Override
    public int getDSFID() {
        return 1054;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.regions, out);
        DataSerializer.writeObject(this.userAttrs, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.regions = (String[])DataSerializer.readObject(in);
        this.userAttrs = (String[])DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "RootRegionResponse from " + this.getRecipient();
    }
}

